<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-bank me-2"></i> Contas Bancárias</h2>
        <p class="text-muted">Gerencie suas contas bancárias</p>
    </div>
    <div class="col-md-6 text-end">
        <button type="button" class="btn btn-outline-info me-2" onclick="abrirTutorialContas()"
            title="Tutorial do Módulo">
            <i class="bi bi-question-circle me-2"></i> Tutorial
        </button>
        <a href="<?= url('/contas/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Nova Conta
        </a>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Contas Bancárias</span>
        <span class="badge bg-primary"><?= count($contas ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($contas)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Banco</th>
                            <th>Agência</th>
                            <th>Conta</th>
                            <th>Tipo</th>

                            <th>Status</th>
                            <th width="120" class="text-center">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($contas as $conta): ?>
                            <tr>
                                <td><?= $conta['id'] ?></td>
                                <td>
                                    <strong><?= htmlspecialchars($conta['bank_name']) ?></strong>
                                    <?php if (!empty($conta['bank_code'])): ?>
                                        <br><small class="text-muted">Código: <?= htmlspecialchars($conta['bank_code']) ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($conta['agency'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($conta['account_number'] ?? '-') ?></td>
                                <td>
                                    <?php
                                    $tipos = [
                                        'corrente' => '<span class="badge bg-primary">Corrente</span>',
                                        'poupanca' => '<span class="badge bg-success">Poupança</span>',
                                        'investimento' => '<span class="badge bg-info">Investimento</span>'
                                    ];
                                    echo $tipos[$conta['account_type']] ?? '-';
                                    ?>
                                </td>

                                <td>
                                    <?php if ($conta['is_active']): ?>
                                        <span class="badge bg-success">Ativa</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inativa</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?= url('/contas/editar?id=' . $conta['id']) ?>"
                                            class="btn btn-outline-primary" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button class="btn btn-outline-danger" onclick="deletarConta(<?= $conta['id'] ?>)"
                                            title="Excluir">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php if (!empty($contas) && isset($totalPages) && $totalPages > 1): ?>
                <div class="d-flex justify-content-between align-items-center p-3 border-top">
                    <div class="text-muted">
                        Mostrando <?= (($page ?? 1) - 1) * ($perPage ?? 50) + 1 ?> a <?= min(($page ?? 1) * ($perPage ?? 50), $total ?? 0) ?> de <?= $total ?? 0 ?> contas
                    </div>
                    <nav>
                        <ul class="pagination pagination-sm mb-0">
                            <li class="page-item <?= ($page ?? 1) <= 1 ? 'disabled' : '' ?>">
                                <a class="page-link" href="?page=<?= max(1, ($page ?? 1) - 1) ?>" aria-label="Anterior">
                                    <span aria-hidden="true">&laquo;</span>
                                </a>
                            </li>
                            <?php for ($i = max(1, ($page ?? 1) - 2); $i <= min($totalPages, ($page ?? 1) + 2); $i++): ?>
                                <li class="page-item <?= ($i === ($page ?? 1)) ? 'active' : '' ?>">
                                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                                </li>
                            <?php endfor; ?>
                            <li class="page-item <?= ($page ?? 1) >= $totalPages ? 'disabled' : '' ?>">
                                <a class="page-link" href="?page=<?= min($totalPages, ($page ?? 1) + 1) ?>" aria-label="Próximo">
                                    <span aria-hidden="true">&raquo;</span>
                                </a>
                            </li>
                        </ul>
                    </nav>
                </div>
            <?php elseif (!empty($contas) && isset($total) && $total > 0): ?>
                <div class="text-center p-3 border-top">
                    <small class="text-muted">Mostrando todos os <?= $total ?> conta(s)</small>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-bank" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhuma conta bancária encontrada</p>
                <a href="<?= url('/contas/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeira Conta
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    async function deletarConta(id) {
        const confirmed = await confirmDelete('Tem certeza que deseja excluir esta conta bancária?');
        if (confirmed) {
            $.ajax({
                url: appUrl('/contas/deletar'),
                type: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        Toast.success(response.message);
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        Toast.error(response.message);
                    }
                }
            });
        }
    }

    // Função para abrir tutorial do módulo de Contas Bancárias
    function abrirTutorialContas() {
        Swal.fire({
            title: '<i class="bi bi-bank text-primary"></i> Tutorial Completo: Módulo de Contas Bancárias',
            html: `
            <div class="text-start" style="max-height: 70vh; overflow-y: auto;">
                <div class="mb-4">
                    <h5 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Visão Geral</h5>
                    <p class="text-muted">O módulo de Contas Bancárias permite cadastrar e gerenciar todas as contas bancárias da empresa, incluindo dados para emissão de boletos e integração com bancos digitais via API.</p>
                </div>

                <div class="accordion" id="tutorialAccordionContas">
                    <!-- ABA: DADOS BANCÁRIOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#dadosBancarios">
                                <i class="bi bi-bank me-2"></i> <strong>1. Aba: Dados Bancários</strong>
                            </button>
                        </h2>
                        <div id="dadosBancarios" class="accordion-collapse collapse show" data-bs-parent="#tutorialAccordionContas">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i>Seleção do Banco</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Selecione o Banco *:</strong> Escolha o banco da lista disponível
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-info">Ao selecionar, campos específicos do banco aparecerão automaticamente</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-123 me-2"></i>Dados da Conta</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Agência:</strong> Número da agência bancária (ex: 1234)
                                        <br><small class="text-muted">Opcional, mas recomendado</small>
                                    </li>
                                    <li><strong>Número da Conta:</strong> Número da conta bancária (ex: 12345-6)
                                        <br><small class="text-muted">Opcional, mas recomendado</small>
                                    </li>
                                    <li><strong>Tipo de Conta:</strong> Selecione o tipo
                                        <br><small class="text-info">• Conta Corrente: Para movimentações diárias</small>
                                        <br><small class="text-success">• Poupança: Conta poupança</small>
                                        <br><small class="text-warning">• Investimento: Conta de investimentos</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-qr-code me-2"></i>Chave PIX</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Chave PIX:</strong> Digite a chave PIX da conta
                                        <br><small class="text-muted">Opcional, mas útil para recebimentos via PIX</small>
                                    </li>
                                    <li><strong>Tipo de Chave PIX:</strong> Selecione o tipo da chave
                                        <br><small class="text-muted">• CPF: Chave usando CPF</small>
                                        <br><small class="text-muted">• CNPJ: Chave usando CNPJ</small>
                                        <br><small class="text-muted">• E-mail: Chave usando e-mail</small>
                                        <br><small class="text-muted">• Telefone: Chave usando telefone</small>
                                        <br><small class="text-muted">• Aleatória: Chave aleatória gerada pelo banco</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-currency-dollar me-2"></i>Valores Financeiros</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Saldo Inicial (R$):</strong> Saldo de referência inicial da conta
                                        <br><small class="text-muted">Use para registrar o saldo atual ao cadastrar a conta</small>
                                        <br><small class="text-info">Este valor é apenas uma referência inicial</small>
                                    </li>
                                    <li><strong>Limite de Crédito (R$):</strong> Limite de crédito disponível na conta
                                        <br><small class="text-muted">Útil para controle de limite de cheque especial ou cartão</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: DADOS DE BOLETO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#dadosBoleto">
                                <i class="bi bi-receipt me-2"></i> <strong>2. Aba: Dados de Boleto</strong>
                            </button>
                        </h2>
                        <div id="dadosBoleto" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionContas">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-person me-2"></i>Dados do Beneficiário</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Beneficiário:</strong> Nome ou Razão Social que aparecerá no boleto
                                        <br><small class="text-muted">Nome que receberá o pagamento</small>
                                    </li>
                                    <li><strong>CPF/CNPJ Beneficiário:</strong> Documento do beneficiário
                                        <br><small class="text-muted">Formato: 000.000.000-00 (CPF) ou 00.000.000/0000-00 (CNPJ)</small>
                                    </li>
                                    <li><strong>Endereço do Beneficiário:</strong> Endereço completo do beneficiário
                                        <br><small class="text-muted">Formato: Rua, número, bairro, cidade - UF</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-bank me-2"></i>Dados Bancários Gerais</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Carteira *:</strong> Carteira de cobrança do banco
                                        <br><small class="text-danger">Campo obrigatório para emissão de boletos</small>
                                        <br><small class="text-muted">Exemplos: 17, 18, 19 (varia por banco)</small>
                                    </li>
                                    <li><strong>Convênio:</strong> Número do convênio com o banco
                                        <br><small class="text-info">Aparece apenas para alguns bancos (ex: Banco do Brasil, Caixa)</small>
                                        <br><small class="text-muted">Ex: 7 dígitos (BB), 6 dígitos (CEF)</small>
                                    </li>
                                    <li><strong>Nosso Número:</strong> Sequencial de boletos
                                        <br><small class="text-muted">Número de controle dos boletos emitidos</small>
                                    </li>
                                    <li><strong>Variação:</strong> Variação da carteira
                                        <br><small class="text-info">Aparece apenas para alguns bancos</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i>Campos Específicos por Banco</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>SICOOB - Modalidade *:</strong>
                                        <br><small class="text-info">• 01 - Simples: Boleto sem registro</small>
                                        <br><small class="text-info">• 02 - Registrada: Boleto registrado</small>
                                    </li>
                                    <li><strong>SICREDI - Posto *:</strong> Código do posto (2 dígitos)</li>
                                    <li><strong>SICREDI - Byte ID *:</strong>
                                        <br><small class="text-info">• 1 - Cooperativa</small>
                                        <br><small class="text-info">• 2 - Posto</small>
                                        <br><small class="text-info">• 3 - Beneficiário</small>
                                    </li>
                                    <li><strong>SICREDI - Cooperativa:</strong> Código da cooperativa</li>
                                </ul>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Dica:</strong> Os campos obrigatórios variam conforme o banco selecionado. Preencha todos os campos marcados com * para garantir a emissão correta de boletos.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: CONFIGURAÇÕES -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#configuracoes">
                                <i class="bi bi-gear me-2"></i> <strong>3. Aba: Configurações</strong>
                            </button>
                        </h2>
                        <div id="configuracoes" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionContas">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-toggle-on me-2"></i>Status e Contatos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Conta Ativa:</strong> Marque para manter a conta ativa no sistema
                                        <br><small class="text-muted">Contas inativas não aparecem em seleções</small>
                                    </li>
                                    <li><strong>Gerente da Conta:</strong> Nome do gerente responsável pela conta
                                        <br><small class="text-muted">Opcional, para referência</small>
                                    </li>
                                    <li><strong>Telefone do Gerente:</strong> Telefone de contato do gerente
                                        <br><small class="text-muted">Formato: (11) 99999-9999</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-sticky me-2"></i>Observações</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Observações:</strong> Campo de texto livre para anotações
                                        <br><small class="text-muted">Use para registrar informações importantes sobre a conta</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- INTEGRAÇÃO COM BANCOS DIGITAIS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#integracaoAPI">
                                <i class="bi bi-plug me-2"></i> <strong>4. Integração com Bancos Digitais (API)</strong>
                            </button>
                        </h2>
                        <div id="integracaoAPI" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionContas">
                            <div class="accordion-body">
                                <p class="mb-3">Alguns bancos digitais (como Banco Inter) permitem integração via API para emissão automática de boletos e consulta de saldo.</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-key me-2"></i>Credenciais de API</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Client ID (Identificador da Aplicação) *:</strong>
                                        <br><small class="text-danger">Campo obrigatório para integração</small>
                                        <br><small class="text-muted">Identificador público fornecido ao criar a aplicação OAuth no painel do banco</small>
                                        <br><small class="text-info">Exemplo: a1b2c3d4-e5f6-7890-abcd-ef1234567890</small>
                                    </li>
                                    <li><strong>Client Secret (Chave Secreta) *:</strong>
                                        <br><small class="text-danger">Campo obrigatório para integração</small>
                                        <br><small class="text-warning">Mantenha essa chave em segredo! Ela permite acesso à sua conta</small>
                                        <br><small class="text-muted">Chave secreta fornecida pelo banco</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-shield-lock me-2"></i>Certificado Digital mTLS (Banco Inter)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Certificado (.crt) *:</strong>
                                        <br><small class="text-danger">Campo obrigatório para Banco Inter</small>
                                        <br><small class="text-muted">Arquivo: Inter API_Certificado.crt</small>
                                        <br><small class="text-info">Fornecido pelo Banco Inter ao criar a aplicação</small>
                                    </li>
                                    <li><strong>Chave Privada (.key) *:</strong>
                                        <br><small class="text-danger">Campo obrigatório para Banco Inter</small>
                                        <br><small class="text-muted">Arquivo: Inter API_Chave.key</small>
                                        <br><small class="text-info">Fornecido pelo Banco Inter ao criar a aplicação</small>
                                    </li>
                                    <li><strong>Senha do Certificado:</strong>
                                        <br><small class="text-muted">Opcional, apenas se o certificado tiver senha</small>
                                    </li>
                                </ul>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Importante:</strong> Os certificados e chaves são arquivos sensíveis. Mantenha-os seguros e não compartilhe com terceiros.</small>
                                </div>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <small><strong>Como obter:</strong> Acesse o painel do banco digital, crie uma aplicação OAuth e baixe os arquivos de certificado e chave fornecidos.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- COMO USAR -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#comoUsar">
                                <i class="bi bi-play-circle me-2"></i> <strong>5. Como Usar</strong>
                            </button>
                        </h2>
                        <div id="comoUsar" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionContas">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-plus-circle me-2"></i>Criando uma Conta Bancária</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Clique em "Nova Conta"</li>
                                    <li>Na aba "Dados Bancários", selecione o <strong>Banco</strong></li>
                                    <li>Preencha os dados da conta (Agência, Número, Tipo)</li>
                                    <li>Adicione a Chave PIX (opcional, mas recomendado)</li>
                                    <li>Informe o Saldo Inicial e Limite de Crédito (se aplicável)</li>
                                    <li>Na aba "Dados de Boleto", preencha os dados do beneficiário e carteira</li>
                                    <li>Se for banco digital com API, preencha as credenciais na aba "Dados de Boleto"</li>
                                    <li>Na aba "Configurações", configure status e observações</li>
                                    <li>Clique em "Salvar"</li>
                                </ol>

                                <h6 class="text-primary mb-3"><i class="bi bi-pencil me-2"></i>Editando uma Conta</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Na lista de contas, clique no ícone de editar (lápis)</li>
                                    <li>Modifique os campos desejados</li>
                                    <li>Clique em "Salvar"</li>
                                </ol>

                                <h6 class="text-warning mb-3"><i class="bi bi-x-circle me-2"></i>Desativando uma Conta</h6>
                                <p class="ms-3 mb-3">Para desativar uma conta sem excluir:</p>
                                <ol class="ms-3 mb-3">
                                    <li>Edite a conta</li>
                                    <li>Na aba "Configurações", desmarque "Conta Ativa"</li>
                                    <li>Salve as alterações</li>
                                    <li>A conta não aparecerá mais em seleções, mas os dados permanecem</li>
                                </ol>
                            </div>
                        </div>
                    </div>

                    <!-- BOAS PRÁTICAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#boasPraticas">
                                <i class="bi bi-lightbulb me-2"></i> <strong>6. Boas Práticas</strong>
                            </button>
                        </h2>
                        <div id="boasPraticas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionContas">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-check-circle me-2"></i>Preenchimento</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Preencha todos os campos obrigatórios marcados com *</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Adicione a Chave PIX para facilitar recebimentos</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Atualize o Saldo Inicial regularmente</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Preencha os dados de boleto corretamente para evitar erros na emissão</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-shield-check me-2"></i>Segurança</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Nunca compartilhe Client Secret ou certificados</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Mantenha os arquivos de certificado em local seguro</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Use senhas fortes para certificados</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Revise periodicamente as permissões de API</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-arrow-repeat me-2"></i>Manutenção</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Revise periodicamente os dados das contas</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Atualize o saldo inicial quando necessário</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Desative contas que não são mais utilizadas</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Mantenha os dados de boleto atualizados</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="alert alert-success mt-4">
                    <i class="bi bi-check-circle me-2"></i>
                    <strong>Pronto para começar!</strong> Agora você conhece todos os recursos do módulo de Contas Bancárias e pode cadastrar e gerenciar suas contas com segurança.
                </div>
            </div>
        `,
            width: '90%',
            heightAuto: false,
            confirmButtonText: 'Entendi, obrigado!',
            confirmButtonColor: '#0d6efd',
            icon: null,
            customClass: {
                popup: 'tutorial-popup',
                container: 'tutorial-container'
            }
        });
    }
</script>

<style>
    /* Estilos para o Tutorial */
    .tutorial-container {
        max-height: 90vh !important;
    }

    .tutorial-popup {
        max-width: 90vw !important;
        max-height: 90vh !important;
        width: 90% !important;
    }

    .tutorial-popup .swal2-html-container {
        padding: 0;
        max-height: calc(90vh - 150px);
        overflow-y: auto;
    }

    .tutorial-popup .accordion-button {
        font-size: 0.95rem;
        font-weight: 600;
        padding: 0.75rem 1rem;
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
    }

    .tutorial-popup .accordion-button:not(.collapsed) {
        background-color: #e7f3ff;
        color: #0d6efd;
        border-color: #0d6efd;
    }

    .tutorial-popup .accordion-button:focus {
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
    }

    .tutorial-popup .accordion-body {
        padding: 1.25rem;
        background-color: #ffffff;
        border-left: 3px solid #0d6efd;
    }

    .tutorial-popup .accordion-item {
        border: 1px solid #dee2e6;
        border-radius: 8px;
        overflow: hidden;
        margin-bottom: 0.5rem;
    }

    .tutorial-popup .list-unstyled li {
        padding: 0.25rem 0;
        line-height: 1.6;
    }

    .tutorial-popup .alert {
        margin-top: 1rem;
        border-left: 4px solid;
    }

    .tutorial-popup .text-muted {
        font-size: 0.875rem;
    }

    .tutorial-popup .text-info {
        color: #0dcaf0 !important;
    }

    .tutorial-popup .text-success {
        color: #198754 !important;
    }

    .tutorial-popup .text-warning {
        color: #ffc107 !important;
    }

    .tutorial-popup .text-primary {
        color: #0d6efd !important;
    }
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'contas';
include ROOT_PATH . '/views/layouts/app.php';
?>