<?php
$isEdit = isset($conta['id']);
?>

<!-- Tabs de Navegação -->
<ul class="nav nav-tabs" id="contaTabs" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados" type="button">
            <i class="bi bi-bank me-2"></i> Dados Bancários
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="boleto-tab" data-bs-toggle="tab" data-bs-target="#boleto" type="button">
            <i class="bi bi-receipt me-2"></i> Dados de Boleto
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="config-tab" data-bs-toggle="tab" data-bs-target="#config" type="button">
            <i class="bi bi-gear me-2"></i> Configurações
        </button>
    </li>
    <?php if ($isEdit): ?>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="info-tab" data-bs-toggle="tab" data-bs-target="#info" type="button">
            <i class="bi bi-graph-up me-2"></i> Informações
        </button>
    </li>
    <?php endif; ?>
</ul>

<!-- Conteúdo das Tabs -->
<div class="tab-content mt-3" id="contaTabContent">

    <!-- ABA 1: Dados Bancários -->
    <div class="tab-pane fade show active" id="dados" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-bank me-2"></i> Informações da Conta Bancária
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Selecionar Banco -->
                    <div class="col-md-12 mb-3">
                        <label for="banco_select" class="form-label">Selecione o Banco *</label>
                        <select class="form-select" id="banco_select" name="banco_select" required>
                            <option value="">Selecione um banco...</option>
                            <?php if (!empty($bancos)): ?>
                                <?php foreach ($bancos as $banco): ?>
                                    <option value="<?= $banco['codigo'] ?>"
                                        data-nome="<?= htmlspecialchars($banco['nome']) ?>"
                                        data-regras='<?= htmlspecialchars($banco['regras_validacao']) ?>'
                                        data-obs="<?= htmlspecialchars($banco['observacoes']) ?>"
                                        <?= ($conta['bank_code'] ?? '') === $banco['codigo'] ? 'selected' : '' ?>>
                                        [<?= $banco['codigo'] ?>] <?= htmlspecialchars($banco['nome']) ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <input type="hidden" id="bank_name" name="bank_name" value="<?= htmlspecialchars($conta['bank_name'] ?? '') ?>">
                        <input type="hidden" id="bank_code" name="bank_code" value="<?= htmlspecialchars($conta['bank_code'] ?? '') ?>">
                        <small class="text-muted" id="banco_obs">Escolha o banco para ver os campos específicos</small>
                    </div>

                    <!-- Agência -->
                    <div class="col-md-4 mb-3">
                        <label for="agency" class="form-label">Agência</label>
                        <input type="text" class="form-control" id="agency" name="agency"
                            placeholder="0000"
                            value="<?= htmlspecialchars($conta['agency'] ?? '') ?>">
                    </div>

                    <!-- Número da Conta -->
                    <div class="col-md-4 mb-3">
                        <label for="account_number" class="form-label">Número da Conta</label>
                        <input type="text" class="form-control" id="account_number" name="account_number"
                            placeholder="00000-0"
                            value="<?= htmlspecialchars($conta['account_number'] ?? '') ?>">
                    </div>

                    <!-- Tipo de Conta -->
                    <div class="col-md-4 mb-3">
                        <label for="account_type" class="form-label">Tipo de Conta</label>
                        <select class="form-select" id="account_type" name="account_type">
                            <option value="corrente" <?= ($conta['account_type'] ?? 'corrente') === 'corrente' ? 'selected' : '' ?>>Conta Corrente</option>
                            <option value="poupanca" <?= ($conta['account_type'] ?? '') === 'poupanca' ? 'selected' : '' ?>>Poupança</option>
                            <option value="investimento" <?= ($conta['account_type'] ?? '') === 'investimento' ? 'selected' : '' ?>>Investimento</option>
                        </select>
                    </div>

                    <!-- Chave PIX -->
                    <div class="col-md-8 mb-3">
                        <label for="pix_key" class="form-label">Chave PIX</label>
                        <input type="text" class="form-control" id="pix_key" name="pix_key"
                            placeholder="Digite a chave PIX..."
                            value="<?= htmlspecialchars($conta['pix_key'] ?? '') ?>">
                    </div>

                    <!-- Tipo de Chave PIX -->
                    <div class="col-md-4 mb-3">
                        <label for="pix_key_type" class="form-label">Tipo de Chave PIX</label>
                        <select class="form-select" id="pix_key_type" name="pix_key_type">
                            <option value="">Selecione...</option>
                            <option value="cpf" <?= ($conta['pix_key_type'] ?? '') === 'cpf' ? 'selected' : '' ?>>CPF</option>
                            <option value="cnpj" <?= ($conta['pix_key_type'] ?? '') === 'cnpj' ? 'selected' : '' ?>>CNPJ</option>
                            <option value="email" <?= ($conta['pix_key_type'] ?? '') === 'email' ? 'selected' : '' ?>>E-mail</option>
                            <option value="telefone" <?= ($conta['pix_key_type'] ?? '') === 'telefone' ? 'selected' : '' ?>>Telefone</option>
                            <option value="aleatoria" <?= ($conta['pix_key_type'] ?? '') === 'aleatoria' ? 'selected' : '' ?>>Aleatória</option>
                        </select>
                    </div>

                    <!-- Saldo Inicial -->
                    <div class="col-md-6 mb-3">
                        <label for="balance" class="form-label">Saldo Inicial (R$)</label>
                        <input type="number" class="form-control" id="balance" name="balance"
                            step="0.01" placeholder="0,00"
                            value="<?= $conta['balance'] ?? '0.00' ?>">
                        <small class="text-muted">Saldo de referência inicial</small>
                    </div>

                    <!-- Limite de Crédito -->
                    <div class="col-md-6 mb-3">
                        <label for="credit_limit" class="form-label">Limite de Crédito (R$)</label>
                        <input type="number" class="form-control" id="credit_limit" name="credit_limit"
                            step="0.01" placeholder="0,00"
                            value="<?= $conta['credit_limit'] ?? '0.00' ?>">
                        <small class="text-muted">Limite de crédito disponível</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ABA 2: Dados de Boleto -->
    <div class="tab-pane fade" id="boleto" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-receipt me-2"></i> Informações para Emissão de Boletos
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Beneficiário -->
                    <div class="col-md-8 mb-3">
                        <label for="beneficiario" class="form-label">Beneficiário</label>
                        <input type="text" class="form-control" id="beneficiario" name="beneficiario"
                            placeholder="Nome ou Razão Social do beneficiário"
                            value="<?= htmlspecialchars($conta['beneficiario'] ?? '') ?>">
                        <small class="text-muted">Nome que aparecerá no boleto como beneficiário</small>
                    </div>

                    <!-- CPF/CNPJ do Beneficiário -->
                    <div class="col-md-4 mb-3">
                        <label for="beneficiario_documento" class="form-label">CPF/CNPJ Beneficiário</label>
                        <input type="text" class="form-control" id="beneficiario_documento" name="beneficiario_documento"
                            placeholder="000.000.000-00"
                            value="<?= htmlspecialchars($conta['beneficiario_documento'] ?? '') ?>">
                    </div>

                    <!-- Endereço Beneficiário -->
                    <div class="col-md-12 mb-3">
                        <label for="beneficiario_endereco" class="form-label">Endereço do Beneficiário</label>
                        <input type="text" class="form-control" id="beneficiario_endereco" name="beneficiario_endereco"
                            placeholder="Rua, número, bairro, cidade - UF"
                            value="<?= htmlspecialchars($conta['beneficiario_endereco'] ?? '') ?>">
                    </div>

                    <div class="col-12"><hr></div>

                    <!-- Alert com informações do banco selecionado -->
                    <div class="col-12 mb-3" id="alert_banco_info" style="display: none;">
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong id="alert_banco_nome"></strong>
                            <p class="mb-0 small" id="alert_banco_obs"></p>
                        </div>
                    </div>

                    <!-- CAMPOS COMUNS A TODOS OS BANCOS -->
                    <div class="col-12 mb-2"><h6 class="text-primary"><i class="bi bi-bank me-2"></i> Dados Bancários Gerais</h6></div>

                    <!-- Carteira -->
                    <div class="col-md-3 mb-3">
                        <label for="carteira" class="form-label">Carteira <span class="text-danger campo-obrigatorio" data-campo="carteira">*</span></label>
                        <input type="text" class="form-control" id="carteira" name="carteira"
                            placeholder="Ex: 17, 18"
                            value="<?= htmlspecialchars($conta['carteira'] ?? '') ?>">
                        <small class="text-muted">Carteira de cobrança</small>
                    </div>

                    <!-- Convênio -->
                    <div class="col-md-3 mb-3" id="campo_convenio" style="display: none;">
                        <label for="convenio" class="form-label">Convênio <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="convenio" name="convenio"
                            placeholder="Número do convênio"
                            value="<?= htmlspecialchars($conta['convenio'] ?? '') ?>">
                        <small class="text-muted" id="hint_convenio">Ex: 7 dígitos (BB), 6 dígitos (CEF)</small>
                    </div>

                    <!-- Nosso Número -->
                    <div class="col-md-3 mb-3">
                        <label for="nosso_numero" class="form-label">Nosso Número</label>
                        <input type="text" class="form-control" id="nosso_numero" name="nosso_numero"
                            placeholder="000000000"
                            value="<?= htmlspecialchars($conta['nosso_numero'] ?? '') ?>">
                        <small class="text-muted">Sequencial de boletos</small>
                    </div>

                    <!-- Variação Carteira -->
                    <div class="col-md-3 mb-3" id="campo_variacao" style="display: none;">
                        <label for="variacao_carteira" class="form-label">Variação</label>
                        <input type="text" class="form-control" id="variacao_carteira" name="variacao_carteira"
                            placeholder="000"
                            value="<?= htmlspecialchars($conta['variacao_carteira'] ?? '') ?>">
                    </div>

                    <!-- CAMPOS ESPECÍFICOS SICOOB -->
                    <div class="col-md-3 mb-3" id="campo_modalidade" style="display: none;">
                        <label for="modalidade" class="form-label">Modalidade <span class="text-danger">*</span></label>
                        <select class="form-select" id="modalidade" name="modalidade">
                            <option value="">Selecione...</option>
                            <option value="01" <?= ($conta['modalidade'] ?? '') === '01' ? 'selected' : '' ?>>01 - Simples</option>
                            <option value="02" <?= ($conta['modalidade'] ?? '') === '02' ? 'selected' : '' ?>>02 - Registrada</option>
                        </select>
                    </div>

                    <!-- CAMPOS ESPECÍFICOS SICREDI -->
                    <div class="col-md-2 mb-3" id="campo_posto" style="display: none;">
                        <label for="posto" class="form-label">Posto <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="posto" name="posto"
                            placeholder="00"
                            maxlength="2"
                            value="<?= htmlspecialchars($conta['posto'] ?? '') ?>">
                    </div>

                    <div class="col-md-2 mb-3" id="campo_byte_id" style="display: none;">
                        <label for="byte_id" class="form-label">Byte ID <span class="text-danger">*</span></label>
                        <select class="form-select" id="byte_id" name="byte_id">
                            <option value="">Selecione...</option>
                            <option value="1" <?= ($conta['byte_id'] ?? '') === '1' ? 'selected' : '' ?>>1 - Cooperativa</option>
                            <option value="2" <?= ($conta['byte_id'] ?? '') === '2' ? 'selected' : '' ?>>2 - Posto</option>
                            <option value="3" <?= ($conta['byte_id'] ?? '') === '3' ? 'selected' : '' ?>>3 - Beneficiário</option>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3" id="campo_cooperativa" style="display: none;">
                        <label for="cooperativa" class="form-label">Cooperativa</label>
                        <input type="text" class="form-control" id="cooperativa" name="cooperativa"
                            placeholder="0000"
                            value="<?= htmlspecialchars($conta['cooperativa'] ?? '') ?>">
                    </div>

                    <!-- CAMPOS BANCOS DIGITAIS (API) -->
                    <div class="col-md-12 mb-3" id="campo_chave_api" style="display: none;">
                        <label for="chave_api" class="form-label">
                            <i class="bi bi-key me-2"></i> Client ID (Identificador da Aplicação)
                            <span class="text-danger">*</span>
                        </label>
                        <input type="text" class="form-control" id="chave_api" name="chave_api"
                            placeholder="Ex: a1b2c3d4-e5f6-7890-abcd-ef1234567890"
                            value="<?= htmlspecialchars($conta['chave_api'] ?? '') ?>">
                        <small class="text-muted">
                            <i class="bi bi-info-circle me-1"></i>
                            <strong>Banco Inter:</strong> Identificador público fornecido ao criar a aplicação OAuth no painel do banco
                        </small>
                    </div>

                    <!-- Client Secret (Banco Inter/Itaú) -->
                    <div class="col-md-12 mb-3" id="campo_client_secret" style="display: none;">
                        <label for="client_secret" class="form-label">
                            <i class="bi bi-shield-lock me-2"></i> Client Secret (Chave Secreta)
                            <span class="text-danger">*</span>
                        </label>
                        <input type="password" class="form-control" id="client_secret" name="client_secret"
                            placeholder="Cole aqui o Client Secret fornecido pelo banco"
                            value="<?= htmlspecialchars($conta['client_secret'] ?? '') ?>">
                        <small class="text-muted">
                            <i class="bi bi-exclamation-triangle me-1 text-warning"></i>
                            <strong>Importante:</strong> Mantenha essa chave em segredo! Ela permite acesso à sua conta.
                        </small>
                        <div class="form-check mt-2">
                            <input class="form-check-input" type="checkbox" id="show_secret">
                            <label class="form-check-label small text-muted" for="show_secret">
                                Mostrar Client Secret
                            </label>
                        </div>
                    </div>

                    <!-- Campos específicos Itaú -->
                    <div class="col-md-12 mb-3" id="campos_itau" style="display: none;">
                        <div class="alert alert-info">
                            <i class="bi bi-bank me-2"></i>
                            <strong>Configurações específicas do Itaú</strong>
                        </div>

                        <!-- Dígito da Conta Itaú -->
                        <div class="col-md-4 mb-3">
                            <label for="digito_conta_itau" class="form-label">
                                <i class="bi bi-hash me-2"></i> Dígito da Conta
                            </label>
                            <input type="text" class="form-control" id="digito_conta_itau" name="digito_conta_itau"
                                placeholder="0"
                                maxlength="2"
                                value="<?= htmlspecialchars($conta['digito_conta_itau'] ?? '') ?>">
                            <small class="text-muted">Dígito verificador da conta corrente</small>
                        </div>

                        <!-- Ambiente (Produção/Sandbox) -->
                        <div class="col-md-8 mb-3">
                            <label class="form-label">
                                <i class="bi bi-toggle-on me-2"></i> Ambiente
                            </label>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="is_producao_itau" name="is_producao_itau"
                                    <?= (!empty($conta['is_producao_itau']) && $conta['is_producao_itau'] == 1) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="is_producao_itau">
                                    <strong>Produção</strong> (desmarque para usar Sandbox/Homologação)
                                </label>
                            </div>
                            <small class="text-muted">
                                <i class="bi bi-info-circle me-1"></i>
                                Em <strong>Sandbox</strong>, os boletos são apenas para testes. Em <strong>Produção</strong>, os boletos são reais.
                            </small>
                        </div>
                    </div>

                    <!-- Token Webhook (separado) -->
                    <div class="col-md-12 mb-3" id="campo_token_webhook" style="display: none;">
                        <label for="token_webhook" class="form-label">
                            <i class="bi bi-webhook me-2"></i> Token Webhook (Opcional)
                        </label>
                        <input type="text" class="form-control" id="token_webhook" name="token_webhook"
                            placeholder="Token para validação de webhooks"
                            value="<?= htmlspecialchars($conta['token_webhook'] ?? '') ?>">
                        <small class="text-muted">Token opcional para validação de webhooks recebidos</small>
                    </div>

                    <!-- Upload Certificado Digital (Banco Inter) -->
                    <div class="col-md-12 mb-3" id="campo_certificado" style="display: none;">
                        <div class="alert alert-warning">
                            <i class="bi bi-shield-lock me-2"></i>
                            <strong>Certificado Digital mTLS:</strong> O Banco Inter exige certificado digital para autenticação OAuth 2.0.
                            Faça upload dos arquivos fornecidos pelo banco.
                        </div>

                        <!-- Certificado (.crt) -->
                        <div class="mb-3">
                            <label for="certificado_file" class="form-label">
                                <i class="bi bi-file-earmark-lock me-2"></i> Certificado (.crt)
                                <span class="text-danger">*</span>
                            </label>
                            <input type="file" class="form-control" id="certificado_file" name="certificado_file"
                                accept=".crt,.pem">
                            <small class="text-muted">Arquivo: Inter API_Certificado.crt</small>
                            <?php if (!empty($conta['certificado_path'])): ?>
                            <div class="mt-2">
                                <div class="alert alert-success alert-sm d-flex align-items-center">
                                    <i class="bi bi-check-circle me-2"></i>
                                    <span>Carregado: <code><?= htmlspecialchars(basename($conta['certificado_path'])) ?></code></span>
                                    <button type="button" class="btn btn-sm btn-outline-danger ms-auto" id="remover_certificado">
                                        <i class="bi bi-trash me-1"></i> Remover
                                    </button>
                                </div>
                                <input type="hidden" id="certificado_path_atual" name="certificado_path_atual"
                                    value="<?= htmlspecialchars($conta['certificado_path']) ?>">
                            </div>
                            <?php endif; ?>
                        </div>

                        <!-- Chave Privada (.key) -->
                        <div class="mb-3">
                            <label for="chave_privada_file" class="form-label">
                                <i class="bi bi-key me-2"></i> Chave Privada (.key)
                                <span class="text-danger">*</span>
                            </label>
                            <input type="file" class="form-control" id="chave_privada_file" name="chave_privada_file"
                                accept=".key,.pem">
                            <small class="text-muted">Arquivo: Inter API_Chave.key</small>
                            <?php if (!empty($conta['chave_privada_path'])): ?>
                            <div class="mt-2">
                                <div class="alert alert-success alert-sm d-flex align-items-center">
                                    <i class="bi bi-check-circle me-2"></i>
                                    <span>Carregado: <code><?= htmlspecialchars(basename($conta['chave_privada_path'])) ?></code></span>
                                    <button type="button" class="btn btn-sm btn-outline-danger ms-auto" id="remover_chave_privada">
                                        <i class="bi bi-trash me-1"></i> Remover
                                    </button>
                                </div>
                                <input type="hidden" id="chave_privada_path_atual" name="chave_privada_path_atual"
                                    value="<?= htmlspecialchars($conta['chave_privada_path']) ?>">
                            </div>
                            <?php endif; ?>
                        </div>

                        <!-- Senha do Certificado (opcional) -->
                        <div class="mb-3">
                            <label for="certificado_senha" class="form-label">
                                <i class="bi bi-lock me-2"></i> Senha do Certificado (se houver)
                            </label>
                            <input type="password" class="form-control" id="certificado_senha" name="certificado_senha"
                                placeholder="Deixe vazio se não tiver senha"
                                value="<?= htmlspecialchars($conta['certificado_senha'] ?? '') ?>">
                            <div class="form-check mt-2">
                                <input class="form-check-input" type="checkbox" id="show_cert_password">
                                <label class="form-check-label small text-muted" for="show_cert_password">
                                    Mostrar senha
                                </label>
                            </div>
                        </div>
                    </div>

                    <!-- Espécie -->
                    <div class="col-md-3 mb-3">
                        <label for="especie" class="form-label">Espécie</label>
                        <select class="form-select" id="especie" name="especie">
                            <option value="R$" <?= ($conta['especie'] ?? 'R$') === 'R$' ? 'selected' : '' ?>>R$ - Real</option>
                            <option value="DM" <?= ($conta['especie'] ?? '') === 'DM' ? 'selected' : '' ?>>DM - Duplicata Mercantil</option>
                            <option value="DS" <?= ($conta['especie'] ?? '') === 'DS' ? 'selected' : '' ?>>DS - Duplicata Serviço</option>
                            <option value="NP" <?= ($conta['especie'] ?? '') === 'NP' ? 'selected' : '' ?>>NP - Nota Promissória</option>
                        </select>
                    </div>

                    <!-- Aceite -->
                    <div class="col-md-3 mb-3">
                        <label for="aceite" class="form-label">Aceite</label>
                        <select class="form-select" id="aceite" name="aceite">
                            <option value="N" <?= ($conta['aceite'] ?? 'N') === 'N' ? 'selected' : '' ?>>N - Não</option>
                            <option value="S" <?= ($conta['aceite'] ?? '') === 'S' ? 'selected' : '' ?>>S - Sim</option>
                        </select>
                    </div>

                    <!-- Local de Pagamento -->
                    <div class="col-md-9 mb-3">
                        <label for="local_pagamento" class="form-label">Local de Pagamento</label>
                        <input type="text" class="form-control" id="local_pagamento" name="local_pagamento"
                            placeholder="Ex: Pagável em qualquer banco até o vencimento"
                            value="<?= htmlspecialchars($conta['local_pagamento'] ?? 'Pagável em qualquer banco até o vencimento') ?>">
                    </div>

                    <div class="col-12"><hr></div>
                    <div class="col-12 mb-2"><h6 class="text-success"><i class="bi bi-list-check me-2"></i> Instruções do Boleto</h6></div>

                    <!-- Instruções Linha 1 -->
                    <div class="col-md-12 mb-3">
                        <label for="instrucoes_1" class="form-label">Instruções (Linha 1)</label>
                        <input type="text" class="form-control" id="instrucoes_1" name="instrucoes_1"
                            placeholder="Exemplo: Não receber após o vencimento"
                            value="<?= htmlspecialchars($conta['instrucoes_1'] ?? '') ?>">
                    </div>

                    <!-- Instruções Linha 2 -->
                    <div class="col-md-12 mb-3">
                        <label for="instrucoes_2" class="form-label">Instruções (Linha 2)</label>
                        <input type="text" class="form-control" id="instrucoes_2" name="instrucoes_2"
                            placeholder="Exemplo: Multa de 2% após vencimento"
                            value="<?= htmlspecialchars($conta['instrucoes_2'] ?? '') ?>">
                    </div>

                    <!-- Instruções Linha 3 -->
                    <div class="col-md-12 mb-3">
                        <label for="instrucoes_3" class="form-label">Instruções (Linha 3)</label>
                        <input type="text" class="form-control" id="instrucoes_3" name="instrucoes_3"
                            placeholder="Exemplo: Juros de 1% ao mês"
                            value="<?= htmlspecialchars($conta['instrucoes_3'] ?? '') ?>">
                    </div>

                    <!-- Demonstrativo -->
                    <div class="col-md-12 mb-3">
                        <label for="demonstrativo" class="form-label">Demonstrativo</label>
                        <textarea class="form-control" id="demonstrativo" name="demonstrativo" rows="3"
                            placeholder="Informações adicionais que aparecerão no boleto..."><?= htmlspecialchars($conta['demonstrativo'] ?? '') ?></textarea>
                        <small class="text-muted">Texto livre para demonstrativo no boleto</small>
                    </div>
                </div>

                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Atenção:</strong> Os dados de boleto são utilizados para emissão de boletos bancários. Certifique-se de que todas as informações estão corretas conforme cadastrado no banco.
                </div>
            </div>
        </div>
    </div>

    <!-- ABA 3: Configurações -->
    <div class="tab-pane fade" id="config" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-gear me-2"></i> Configurações e Contatos
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Nome do Gerente -->
                    <div class="col-md-6 mb-3">
                        <label for="manager_name" class="form-label">Nome do Gerente</label>
                        <input type="text" class="form-control" id="manager_name" name="manager_name"
                            placeholder="Nome do gerente da conta..."
                            value="<?= htmlspecialchars($conta['manager_name'] ?? '') ?>">
                    </div>

                    <!-- Telefone do Gerente -->
                    <div class="col-md-6 mb-3">
                        <label for="manager_phone" class="form-label">Telefone do Gerente</label>
                        <input type="text" class="form-control" id="manager_phone" name="manager_phone"
                            placeholder="(00) 00000-0000"
                            value="<?= htmlspecialchars($conta['manager_phone'] ?? '') ?>">
                    </div>

                    <!-- Observações -->
                    <div class="col-md-12 mb-3">
                        <label for="notes" class="form-label">Observações</label>
                        <textarea class="form-control" id="notes" name="notes" rows="4"
                            placeholder="Informações adicionais sobre a conta bancária..."><?= htmlspecialchars($conta['notes'] ?? '') ?></textarea>
                    </div>

                    <!-- Status Ativo/Inativo -->
                    <?php if ($isEdit): ?>
                    <div class="col-md-6 mb-4">
                        <label class="form-label">Status da Conta</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                                <?= ($conta['is_active'] ?? 1) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="is_active">
                                Conta Ativa
                            </label>
                        </div>
                        <small class="text-muted">Contas inativas não aparecem em seleções</small>
                    </div>
                    <?php endif; ?>
                </div>

                <div class="alert alert-info">
                    <i class="bi bi-lightbulb me-2"></i>
                    <strong>Dica:</strong> O saldo inicial serve apenas como referência. As movimentações financeiras (pagamentos, recebimentos) atualizarão automaticamente o saldo da conta.
                </div>
            </div>
        </div>
    </div>

    <!-- ABA 4: Informações -->
    <?php if ($isEdit): ?>
    <div class="tab-pane fade" id="info" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-graph-up me-2"></i> Informações do Sistema
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">ID da Conta</label>
                        <p class="form-control-plaintext">#<?= $conta['id'] ?></p>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Criado em</label>
                        <p class="form-control-plaintext">
                            <?= date('d/m/Y \à\s H:i', strtotime($conta['created_at'])) ?>
                        </p>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Última Atualização</label>
                        <p class="form-control-plaintext">
                            <?= date('d/m/Y \à\s H:i', strtotime($conta['updated_at'])) ?>
                        </p>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Status Atual</label>
                        <p class="form-control-plaintext">
                            <?php if ($conta['is_active']): ?>
                                <span class="badge bg-success">Ativa</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Inativa</span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

</div>

<?php if ($isEdit): ?>
<input type="hidden" name="id" value="<?= $conta['id'] ?>">
<?php endif; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Atualizar campos ao selecionar banco
    const bancoSelect = document.getElementById('banco_select');
    console.log('Banco select encontrado:', bancoSelect);

    if (bancoSelect) {
        bancoSelect.addEventListener('change', function(e) {
            const selectedOption = e.target.options[e.target.selectedIndex];
            const codigo = selectedOption.value;
            const nome = selectedOption.getAttribute('data-nome');
            const obs = selectedOption.getAttribute('data-obs');

            console.log('Banco selecionado:', codigo, nome);

            // Atualizar campos hidden
            document.getElementById('bank_code').value = codigo;
            document.getElementById('bank_name').value = nome;

            // Atualizar observação na tab de dados bancários
            const obsElement = document.getElementById('banco_obs');
            if (obs && obsElement) {
                obsElement.innerHTML = '<i class="bi bi-info-circle me-1"></i> ' + obs;
                obsElement.className = 'text-info small';
            } else if (obsElement) {
                obsElement.textContent = 'Escolha o banco para ver os campos específicos';
                obsElement.className = 'text-muted';
            }

            // Controlar campos específicos por banco
            ocultarTodosCamposEspecificos();

            if (codigo) {
                mostrarCamposEspecificosBanco(codigo, nome, obs);
            }
        });

        // Trigger no carregamento se já houver banco selecionado
        if (bancoSelect.value) {
            bancoSelect.dispatchEvent(new Event('change'));
        }
    }

    // Função para ocultar todos os campos específicos
    function ocultarTodosCamposEspecificos() {
        const camposEspecificos = [
            'campo_convenio', 'campo_variacao', 'campo_modalidade',
            'campo_posto', 'campo_byte_id', 'campo_cooperativa', 'campo_chave_api', 'campo_client_secret', 'campo_certificado'
        ];
        camposEspecificos.forEach(id => {
            const elem = document.getElementById(id);
            if (elem) elem.style.display = 'none';
        });

        const alertInfo = document.getElementById('alert_banco_info');
        if (alertInfo) alertInfo.style.display = 'none';

        // Reexibir todos os campos tradicionais de boleto
        reexibirCamposBoletoTradicional();
    }

    // Função para reexibir campos tradicionais de boleto
    function reexibirCamposBoletoTradicional() {
        const camposReexibir = [
            'carteira', 'especie', 'aceite', 'local_pagamento',
            'instrucoes_1', 'instrucoes_2', 'instrucoes_3', 'demonstrativo',
            'beneficiario', 'beneficiario_documento', 'beneficiario_endereco'
        ];

        camposReexibir.forEach(id => {
            const campo = document.getElementById(id);
            if (campo) {
                const container = campo.closest('.col-md-12, .col-md-9, .col-md-8, .col-md-6, .col-md-4, .col-md-3');
                if (container) {
                    container.style.display = 'block';
                }
            }
        });

        // Reexibir seções
        const secoes = document.querySelectorAll('.col-12 h6');
        secoes.forEach(h6 => {
            if (h6.textContent.includes('Instruções do Boleto')) {
                h6.parentElement.style.display = 'block';
            }
        });

        // Restaurar label original do Nosso Número
        const nossoNumeroLabel = document.querySelector('label[for="nosso_numero"]');
        if (nossoNumeroLabel) {
            nossoNumeroLabel.textContent = 'Nosso Número';
        }
    }

    // Função para mostrar campos específicos do banco
    function mostrarCamposEspecificosBanco(codigo, nome, obs) {
        console.log('Mostrando campos para banco:', codigo);

        // Mostrar alert com info do banco (se existir)
        const alertNome = document.getElementById('alert_banco_nome');
        const alertObs = document.getElementById('alert_banco_obs');
        const alertInfo = document.getElementById('alert_banco_info');

        if (alertNome && alertObs && alertInfo) {
            alertNome.textContent = nome;
            alertObs.textContent = obs || '';
            alertInfo.style.display = 'block';
        }

        // Banco do Brasil (001) - Convênio obrigatório, variação carteira
        if (codigo === '001') {
            console.log('BB selecionado, mostrando convênio e variação');
            const convenio = document.getElementById('campo_convenio');
            const variacao = document.getElementById('campo_variacao');
            const hint = document.getElementById('hint_convenio');

            if (convenio) {
                convenio.style.display = 'block';
                console.log('✅ Campo convênio mostrado');
            } else {
                console.error('❌ Campo convenio não encontrado!');
            }

            if (hint) hint.textContent = '4 a 7 dígitos';

            if (variacao) {
                variacao.style.display = 'block';
                console.log('✅ Campo variação mostrado');
            } else {
                console.error('❌ Campo variacao não encontrado!');
            }
        }

        // Caixa (104) - Convênio obrigatório de 6 dígitos
        else if (codigo === '104') {
            console.log('Caixa selecionada, mostrando convênio');
            const convenio = document.getElementById('campo_convenio');
            const hint = document.getElementById('hint_convenio');

            if (convenio) convenio.style.display = 'block';
            if (hint) hint.textContent = 'Obrigatório 6 dígitos';
        }

        // Sicoob (756) - Modalidade obrigatória
        else if (codigo === '756') {
            console.log('Sicoob selecionado, mostrando modalidade');
            const modalidade = document.getElementById('campo_modalidade');
            if (modalidade) modalidade.style.display = 'block';
        }

        // Sicredi (748) - Posto, Byte ID e Cooperativa
        else if (codigo === '748') {
            console.log('Sicredi selecionado, mostrando posto, byte_id e cooperativa');
            const posto = document.getElementById('campo_posto');
            const byteId = document.getElementById('campo_byte_id');
            const coop = document.getElementById('campo_cooperativa');

            if (posto) posto.style.display = 'block';
            if (byteId) byteId.style.display = 'block';
            if (coop) coop.style.display = 'block';
        }

        // Banco Inter (077) - API de Cobrança Digital
        else if (codigo === '077') {
            console.log('Banco Inter selecionado - API de Cobrança Digital');
            const chaveApi = document.getElementById('campo_chave_api');
            const clientSecret = document.getElementById('campo_client_secret');
            const certificado = document.getElementById('campo_certificado');
            const camposItau = document.getElementById('campos_itau');
            const tokenWebhook = document.getElementById('campo_token_webhook');

            if (chaveApi) chaveApi.style.display = 'block';
            if (clientSecret) clientSecret.style.display = 'block';
            if (certificado) certificado.style.display = 'block';
            if (camposItau) camposItau.style.display = 'none';
            if (tokenWebhook) tokenWebhook.style.display = 'block';

            // Ocultar campos tradicionais de boleto (não usados na API)
            ocultarCamposBoletoTradicional();

            // Destacar campo Nosso Número para API do Inter
            const nossoNumeroLabel = document.querySelector('label[for="nosso_numero"]');
            if (nossoNumeroLabel) {
                nossoNumeroLabel.innerHTML = 'Nosso Número (Sequencial de Boletos) <span class="text-info"><i class="bi bi-info-circle ms-1" title="Contador automático de boletos emitidos via API"></i></span>';
            }

            // Mostrar aviso sobre API
            mostrarAvisoApiInter();
        }

        // Itaú (341) - API de Cobrança Registrada
        else if (codigo === '341') {
            console.log('Itaú selecionado - API de Cobrança Registrada');
            const chaveApi = document.getElementById('campo_chave_api');
            const clientSecret = document.getElementById('campo_client_secret');
            const certificado = document.getElementById('campo_certificado');
            const camposItau = document.getElementById('campos_itau');
            const tokenWebhook = document.getElementById('campo_token_webhook');

            if (chaveApi) chaveApi.style.display = 'block';
            if (clientSecret) clientSecret.style.display = 'block';
            if (certificado) certificado.style.display = 'block';
            if (camposItau) camposItau.style.display = 'block';
            if (tokenWebhook) tokenWebhook.style.display = 'block';

            // Ocultar campos tradicionais de boleto (não usados na API)
            ocultarCamposBoletoTradicional();

            // Atualizar labels para Itaú
            const chaveApiLabel = document.querySelector('label[for="chave_api"]');
            if (chaveApiLabel) {
                chaveApiLabel.innerHTML = '<i class="bi bi-key me-2"></i> Client ID (Identificador da Aplicação) <span class="text-danger">*</span>';
            }

            const clientSecretLabel = document.querySelector('label[for="client_secret"]');
            if (clientSecretLabel) {
                clientSecretLabel.innerHTML = '<i class="bi bi-shield-lock me-2"></i> Client Secret (Chave Secreta) <span class="text-danger">*</span>';
            }

            // Mostrar aviso sobre API Itaú
            mostrarAvisoApiItau();
        }

        // Nubank (260) - Chave API
        else if (codigo === '260') {
            console.log('Nubank selecionado, mostrando chave API');
            const chaveApi = document.getElementById('campo_chave_api');
            if (chaveApi) chaveApi.style.display = 'block';
        }
    }

    // Função para ocultar campos tradicionais de boleto (para API do Inter)
    function ocultarCamposBoletoTradicional() {
        const camposOcultar = [
            'carteira', 'especie', 'aceite', 'local_pagamento',
            'instrucoes_1', 'instrucoes_2', 'instrucoes_3', 'demonstrativo',
            'beneficiario', 'beneficiario_documento', 'beneficiario_endereco'
        ];

        camposOcultar.forEach(id => {
            const campo = document.getElementById(id);
            if (campo) {
                const container = campo.closest('.col-md-12, .col-md-9, .col-md-8, .col-md-6, .col-md-4, .col-md-3');
                if (container) {
                    container.style.display = 'none';
                }
            }
        });

        // Ocultar seções inteiras
        const secoes = document.querySelectorAll('.col-12 h6');
        secoes.forEach(h6 => {
            if (h6.textContent.includes('Instruções do Boleto')) {
                h6.parentElement.style.display = 'none';
            }
        });
    }

    // Função para mostrar aviso sobre API do Inter
    function mostrarAvisoApiInter() {
        const alertInfo = document.getElementById('alert_banco_info');
        const alertNome = document.getElementById('alert_banco_nome');
        const alertObs = document.getElementById('alert_banco_obs');

        if (alertInfo && alertNome && alertObs) {
            alertInfo.className = 'alert alert-info';
            alertNome.innerHTML = '<i class="bi bi-cloud me-2"></i> Banco Inter - Cobrança Digital via API (OAuth 2.0)';
            alertObs.innerHTML = `
                <strong>Configuração necessária (obtenha no Internet Banking):</strong><br>
                • <strong>Client ID:</strong> Identificador público da aplicação (gerado ao criar aplicação OAuth)<br>
                • <strong>Client Secret:</strong> Chave secreta para autenticação (gerado junto com o Client ID)<br>
                • <strong>Certificado Digital:</strong> Arquivo .crt e .key (faça upload no painel do Inter)<br>
                • <strong>Conta Digital:</strong> Número da sua conta corrente digital Inter<br>
                <br>
                <strong>📍 Como obter:</strong><br>
                1. Acesse o Internet Banking do Inter<br>
                2. Vá em "Configurações" → "API de Cobrança"<br>
                3. Crie uma nova aplicação e copie o Client ID e Client Secret<br>
                <br>
                <small class="text-muted">⚠️ Os campos tradicionais de boleto não são necessários para a API de cobrança digital.</small>
            `;
            alertInfo.style.display = 'block';
        }
    }

    // Função para mostrar aviso sobre API do Itaú
    function mostrarAvisoApiItau() {
        const alertInfo = document.getElementById('alert_banco_info');
        const alertNome = document.getElementById('alert_banco_nome');
        const alertObs = document.getElementById('alert_banco_obs');

        if (alertInfo && alertNome && alertObs) {
            alertInfo.className = 'alert alert-info';
            alertNome.innerHTML = '<i class="bi bi-bank me-2"></i> Itaú - Cobrança Registrada via API (OAuth 2.0)';
            alertObs.innerHTML = `
                <strong>Configuração necessária (obtenha no Developer Portal do Itaú):</strong><br>
                • <strong>Client ID:</strong> Identificador público da aplicação (gerado no Developer Portal)<br>
                • <strong>Client Secret:</strong> Chave secreta para autenticação (gerado junto com o Client ID)<br>
                • <strong>Certificado Digital:</strong> Arquivo .crt e .key (opcional, dependendo do tipo de autenticação)<br>
                • <strong>Agência e Conta:</strong> Número da agência e conta corrente Itaú<br>
                • <strong>Dígito da Conta:</strong> Dígito verificador da conta<br>
                <br>
                <strong>📍 Como obter:</strong><br>
                1. Acesse o Developer Portal do Itaú: <a href="https://developer.itau.com.br" target="_blank">developer.itau.com.br</a><br>
                2. Crie uma aplicação para "Cobrança Registrada"<br>
                3. Copie o Client ID e Client Secret<br>
                4. Configure o webhook: <code><?= url('/webhook/itau') ?></code><br>
                <br>
                <small class="text-muted">⚠️ Os campos tradicionais de boleto não são necessários para a API de cobrança registrada.</small>
            `;
            alertInfo.style.display = 'block';
        }
    }

    // Máscara para telefone
    const phoneInput = document.getElementById('manager_phone');
    if (phoneInput) {
        phoneInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length <= 11) {
                value = value.replace(/^(\d{2})(\d{5})(\d{4}).*/, '($1) $2-$3');
                if (value.length < 15) {
                    value = value.replace(/^(\d{2})(\d{4})(\d{0,4}).*/, '($1) $2-$3');
                }
            }
            e.target.value = value;
        });
    }

    // Máscara para código do banco (apenas números, máximo 3 dígitos)
    const bankCodeInput = document.getElementById('bank_code');
    if (bankCodeInput) {
        bankCodeInput.addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/\D/g, '').substring(0, 3);
        });
    }

    // Toggle para mostrar/ocultar Client Secret
    const showSecretCheckbox = document.getElementById('show_secret');
    const clientSecretInput = document.getElementById('client_secret');

    if (showSecretCheckbox && clientSecretInput) {
        showSecretCheckbox.addEventListener('change', function(e) {
            clientSecretInput.type = e.target.checked ? 'text' : 'password';
        });
    }

    // Máscara para CPF/CNPJ do beneficiário
    const beneficiarioDocInput = document.getElementById('beneficiario_documento');
    if (beneficiarioDocInput) {
        beneficiarioDocInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');

            if (value.length <= 11) {
                // CPF: 000.000.000-00
                value = value.replace(/^(\d{3})(\d{3})(\d{3})(\d{2}).*/, '$1.$2.$3-$4');
                value = value.replace(/^(\d{3})(\d{3})(\d{3})(\d{0,2}).*/, '$1.$2.$3-$4');
                value = value.replace(/^(\d{3})(\d{3})(\d{0,3}).*/, '$1.$2.$3');
                value = value.replace(/^(\d{3})(\d{0,3})/, '$1.$2');
            } else {
                // CNPJ: 00.000.000/0000-00
                value = value.substring(0, 14);
                value = value.replace(/^(\d{2})(\d{3})(\d{3})(\d{4})(\d{2}).*/, '$1.$2.$3/$4-$5');
            }

            e.target.value = value;
        });
    }

    // Máscara para carteira (apenas números)
    const carteiraInput = document.getElementById('carteira');
    if (carteiraInput) {
        carteiraInput.addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/\D/g, '');
        });
    }

    // Máscara para convênio (apenas números)
    const convenioInput = document.getElementById('convenio');
    if (convenioInput) {
        convenioInput.addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/\D/g, '');
        });
    }
});
</script>
