<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-pencil me-2"></i> Editar Conta Bancária</h2>
        <p class="text-muted"><?= htmlspecialchars($conta['bank_name'] ?? '') ?></p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/contas') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<form id="formConta" method="POST" action="<?= url('/contas/editar') ?>">
    <?php include __DIR__ . '/form.php'; ?>

    <div class="row mt-4">
        <div class="col-12">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-check-circle me-2"></i> Atualizar Conta
            </button>
            <a href="<?= url('/contas') ?>" class="btn btn-outline-secondary btn-lg ms-2">
                <i class="bi bi-x-circle me-2"></i> Cancelar
            </a>
        </div>
    </div>
</form>

<script>
(function aguardarJQuery() {
    if (typeof jQuery === 'undefined') {
        setTimeout(aguardarJQuery, 100);
        return;
    }

    $(document).ready(function() {
        // Botão remover certificado
        $('#remover_certificado').on('click', function() {
            Swal.fire({
                title: 'Remover certificado?',
                text: 'O certificado será removido ao salvar a conta.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sim, remover',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#certificado_path_atual').val('');
                    $(this).closest('.alert').fadeOut(300, function() {
                        $(this).remove();
                    });
                }
            });
        });

        // Botão remover chave privada
        $('#remover_chave_privada').on('click', function() {
            Swal.fire({
                title: 'Remover chave privada?',
                text: 'A chave privada será removida ao salvar a conta.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sim, remover',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#chave_privada_path_atual').val('');
                    $(this).closest('.alert').fadeOut(300, function() {
                        $(this).remove();
                    });
                }
            });
        });

        // Toggle senha do certificado
        $('#show_cert_password').on('change', function() {
            const type = $(this).is(':checked') ? 'text' : 'password';
            $('#certificado_senha').attr('type', type);
        });

        $('#formConta').on('submit', function(e) {
            e.preventDefault();

            // Verificar se há arquivo para upload
            const certificadoFile = document.getElementById('certificado_file');
            const chavePrivadaFile = document.getElementById('chave_privada_file');
            const hasFile = (certificadoFile && certificadoFile.files.length > 0) ||
                          (chavePrivadaFile && chavePrivadaFile.files.length > 0);

            if (hasFile) {
                // Usar FormData para enviar arquivo
                const formData = new FormData(this);

                // Garantir que certificado_path_atual e chave_privada_path_atual sejam enviados
                const certificadoPathAtual = $('#certificado_path_atual').val() || '';
                const chavePrivadaPathAtual = $('#chave_privada_path_atual').val() || '';
                formData.set('certificado_path_atual', certificadoPathAtual);
                formData.set('chave_privada_path_atual', chavePrivadaPathAtual);

                // Adicionar checkboxes não marcados
                $('input[type="checkbox"]').each(function() {
                    if (!$(this).is(':checked')) {
                        formData.append($(this).attr('name'), '0');
                    }
                });

                $.ajax({
                    url: appUrl('/contas/editar'),
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message,
                                timer: 1500
                            }).then(() => {
                                window.location.href = response.redirect || appUrl('/contas');
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message
                            });
                        }
                    },
                    error: function(xhr) {
                        console.error('Erro:', xhr);
                        const errorMsg = xhr.responseJSON?.message || 'Erro ao atualizar conta. Verifique os dados.';
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: errorMsg
                        });
                    }
                });
            } else {
                // Formulário normal sem arquivo
                const formData = $(this).serializeArray();
                const data = {};
                formData.forEach(item => {
                    data[item.name] = item.value;
                });

                // Garantir que certificado_path_atual e chave_privada_path_atual sejam enviados
                const certificadoPathAtual = $('#certificado_path_atual').val() || '';
                const chavePrivadaPathAtual = $('#chave_privada_path_atual').val() || '';
                data['certificado_path_atual'] = certificadoPathAtual;
                data['chave_privada_path_atual'] = chavePrivadaPathAtual;

                $('input[type="checkbox"]').each(function() {
                    if (!$(this).is(':checked')) {
                        data[$(this).attr('name')] = '0';
                    }
                });

                $.ajax({
                    url: appUrl('/contas/editar'),
                    type: 'POST',
                    data: data,
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message,
                                timer: 1500
                            }).then(() => {
                                window.location.href = response.redirect || appUrl('/contas');
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message
                            });
                        }
                    },
                    error: function(xhr) {
                        console.error('Erro:', xhr);
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Erro ao atualizar conta. Verifique os dados.'
                        });
                    }
                });
            }
        });
    });
})();
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'contas';
include ROOT_PATH . '/views/layouts/app.php';
?>
