<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-bank me-2"></i> Nova Conta Bancária</h2>
        <p class="text-muted">Cadastre uma nova conta bancária</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/contas') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<form id="formConta" method="POST" action="<?= url('/contas/criar') ?>">
    <?php include __DIR__ . '/form.php'; ?>

    <div class="row mt-4">
        <div class="col-12">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-check-circle me-2"></i> Salvar Conta
            </button>
            <a href="<?= url('/contas') ?>" class="btn btn-outline-secondary btn-lg ms-2">
                <i class="bi bi-x-circle me-2"></i> Cancelar
            </a>
        </div>
    </div>
</form>

<script>
(function aguardarJQuery() {
    if (typeof jQuery === 'undefined') {
        setTimeout(aguardarJQuery, 100);
        return;
    }

    $(document).ready(function() {
        $('#formConta').on('submit', function(e) {
            e.preventDefault();

            // Verificar se há arquivo para upload
            const certificadoFile = document.getElementById('certificado_file');
            const chavePrivadaFile = document.getElementById('chave_privada_file');
            const hasFile = (certificadoFile && certificadoFile.files.length > 0) ||
                          (chavePrivadaFile && chavePrivadaFile.files.length > 0);

            if (hasFile) {
                // Usar FormData para enviar arquivo
                const formData = new FormData(this);

                // Adicionar checkboxes não marcados
                $('input[type="checkbox"]').each(function() {
                    if (!$(this).is(':checked')) {
                        formData.append($(this).attr('name'), '0');
                    }
                });

                $.ajax({
                    url: appUrl('/contas/criar'),
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message,
                                timer: 1500
                            }).then(() => {
                                window.location.href = response.redirect || appUrl('/contas');
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message
                            });
                        }
                    },
                    error: function(xhr) {
                        console.error('Erro:', xhr);
                        const errorMsg = xhr.responseJSON?.message || 'Erro ao salvar conta. Verifique os dados.';
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: errorMsg
                        });
                    }
                });
            } else {
                // Formulário normal sem arquivo
                const formData = $(this).serializeArray();
                const data = {};
                formData.forEach(item => {
                    data[item.name] = item.value;
                });

                $('input[type="checkbox"]').each(function() {
                    if (!$(this).is(':checked')) {
                        data[$(this).attr('name')] = '0';
                    }
                });

                $.ajax({
                    url: appUrl('/contas/criar'),
                    type: 'POST',
                    data: data,
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message,
                                timer: 1500
                            }).then(() => {
                                window.location.href = response.redirect || appUrl('/contas');
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message
                            });
                        }
                    },
                    error: function(xhr) {
                        console.error('Erro:', xhr);
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Erro ao salvar conta. Verifique os dados.'
                        });
                    }
                });
            }
        });
    });
})();
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'contas';
include ROOT_PATH . '/views/layouts/app.php';
?>
