<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="bi bi-cart-plus me-2"></i> Compra #<?= htmlspecialchars($compra['numero'] ?? $compra['id']) ?></h2>
                <p class="text-muted mb-0">
                    Realizada em <?= date('d/m/Y', strtotime($compra['data_compra'])) ?>
                </p>
            </div>
            <div>
                <a href="<?= url('/compras') ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left me-2"></i> Voltar
                </a>
                <a href="<?= url('/compras/imprimir?id=' . $compra['id']) ?>" class="btn btn-primary" target="_blank">
                    <i class="bi bi-printer me-2"></i> Imprimir Pedido
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Primeira Linha de Cards -->
<div class="row cards-equal mb-4">
    <!-- Coluna Esquerda -->
    <div class="col-md-6">
        <!-- Informações da Compra -->
        <div class="card h-100">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-info-circle me-2"></i> Informações da Compra</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless mb-0">
                    <tbody>
                        <tr>
                            <td class="text-muted" width="150"><strong>Número:</strong></td>
                            <td><?= htmlspecialchars($compra['numero'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td class="text-muted"><strong>Data:</strong></td>
                            <td><?= date('d/m/Y', strtotime($compra['data_compra'])) ?></td>
                        </tr>
                        <?php if (!empty($compra['data_entrega'])): ?>
                        <tr>
                            <td class="text-muted"><strong>Data Entrega:</strong></td>
                            <td><?= date('d/m/Y', strtotime($compra['data_entrega'])) ?></td>
                        </tr>
                        <?php endif; ?>
                        <tr>
                            <td class="text-muted"><strong>Status:</strong></td>
                            <td>
                                <?php
                                    $statusBadges = [
                                        'orcamento' => '<span class="badge bg-secondary">Orçamento</span>',
                                        'pedido' => '<span class="badge bg-warning">Pedido</span>',
                                        'recebido' => '<span class="badge bg-success">Recebido</span>',
                                        'cancelado' => '<span class="badge bg-danger">Cancelado</span>'
                                    ];
                                    echo $statusBadges[$compra['status']] ?? '-';
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted"><strong>Tipo:</strong></td>
                            <td>
                                <?php
                                    $typeBadges = [
                                        'compra' => '<span class="badge bg-info">Compra</span>',
                                        'devolucao' => '<span class="badge bg-warning">Devolução</span>'
                                    ];
                                    echo $typeBadges[$compra['type']] ?? '-';
                                ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Coluna Direita -->
    <div class="col-md-6">
        <!-- Dados do Fornecedor -->
        <div class="card h-100">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="bi bi-building me-2"></i> Fornecedor</h5>
            </div>
            <div class="card-body">
                <?php if ($fornecedor): ?>
                <table class="table table-borderless mb-0">
                    <tbody>
                        <tr>
                            <td class="text-muted" width="150"><strong>Nome:</strong></td>
                            <td><?= htmlspecialchars($fornecedor['name']) ?></td>
                        </tr>
                        <?php if (!empty($fornecedor['document'])): ?>
                        <tr>
                            <td class="text-muted"><strong>CPF/CNPJ:</strong></td>
                            <td><?= htmlspecialchars($fornecedor['document']) ?></td>
                        </tr>
                        <?php endif; ?>
                        <?php if (!empty($fornecedor['phone'])): ?>
                        <tr>
                            <td class="text-muted"><strong>Telefone:</strong></td>
                            <td><?= htmlspecialchars($fornecedor['phone']) ?></td>
                        </tr>
                        <?php endif; ?>
                        <?php if (!empty($fornecedor['email'])): ?>
                        <tr>
                            <td class="text-muted"><strong>E-mail:</strong></td>
                            <td><?= htmlspecialchars($fornecedor['email']) ?></td>
                        </tr>
                        <?php endif; ?>
                        <?php if (!empty($fornecedor['city'])): ?>
                        <tr>
                            <td class="text-muted"><strong>Cidade:</strong></td>
                            <td><?= htmlspecialchars($fornecedor['city']) ?> - <?= htmlspecialchars($fornecedor['state']) ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <?php else: ?>
                <div class="text-center text-muted py-3">
                    <i class="bi bi-building" style="font-size: 3rem; opacity: 0.3;"></i>
                    <p class="mb-0 mt-2">Fornecedor não informado</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Itens da Compra -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-box-seam me-2"></i> Itens da Compra</h5>
            </div>
            <div class="card-body">
                <?php if (!empty($itens)): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Produto</th>
                                <th>Unidade</th>
                                <th class="text-center">Quantidade</th>
                                <th class="text-end">Valor Un.</th>
                                <th class="text-end">Desconto</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($itens as $item): ?>
                            <tr>
                                <td><?= htmlspecialchars($item['item_code'] ?? '-') ?></td>
                                <td>
                                    <strong><?= htmlspecialchars($item['item_name']) ?></strong>
                                </td>
                                <td><?= htmlspecialchars($item['unit'] ?? 'UN') ?></td>
                                <td class="text-center"><?= number_format($item['quantity'], 3, ',', '.') ?></td>
                                <td class="text-end">R$ <?= number_format($item['unit_price'], 2, ',', '.') ?></td>
                                <td class="text-end text-danger">
                                    <?php if (($item['discount'] ?? 0) > 0): ?>
                                    - R$ <?= number_format($item['discount'], 2, ',', '.') ?>
                                    <?php else: ?>
                                    -
                                    <?php endif; ?>
                                </td>
                                <td class="text-end"><strong>R$ <?= number_format($item['total'], 2, ',', '.') ?></strong></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="text-center text-muted py-5">
                    <i class="bi bi-box-seam" style="font-size: 4rem; opacity: 0.3;"></i>
                    <p class="mb-0 mt-3">Nenhum item cadastrado nesta compra</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Terceira Linha de Cards -->
<div class="row cards-equal">
    <div class="col-md-6">
        <!-- Valores -->
        <div class="card h-100">
            <div class="card-header bg-warning text-dark">
                <h5 class="mb-0"><i class="bi bi-cash-stack me-2"></i> Valores</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless mb-0">
                    <tbody>
                        <tr>
                            <td class="text-muted" width="150"><strong>Subtotal:</strong></td>
                            <td>R$ <?= number_format($compra['subtotal'] ?? 0, 2, ',', '.') ?></td>
                        </tr>
                        <?php if (($compra['discount'] ?? 0) > 0): ?>
                        <tr>
                            <td class="text-muted"><strong>Desconto:</strong></td>
                            <td class="text-danger">- R$ <?= number_format($compra['discount'] ?? 0, 2, ',', '.') ?></td>
                        </tr>
                        <?php endif; ?>
                        <?php if (($compra['shipping'] ?? 0) > 0): ?>
                        <tr>
                            <td class="text-muted"><strong>Frete:</strong></td>
                            <td>R$ <?= number_format($compra['shipping'] ?? 0, 2, ',', '.') ?></td>
                        </tr>
                        <?php endif; ?>
                        <tr class="border-top">
                            <td class="text-muted"><strong>TOTAL:</strong></td>
                            <td><strong class="text-success" style="font-size: 1.25rem;">R$ <?= number_format($compra['total'], 2, ',', '.') ?></strong></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <!-- Observações -->
        <div class="card h-100">
            <div class="card-header bg-secondary text-white">
                <h5 class="mb-0"><i class="bi bi-chat-square-text me-2"></i> Observações</h5>
            </div>
            <div class="card-body">
                <?php if (!empty($compra['notes'])): ?>
                <p class="mb-0"><?= nl2br(htmlspecialchars($compra['notes'])) ?></p>
                <?php else: ?>
                <div class="text-center text-muted py-3">
                    <i class="bi bi-chat-square-text" style="font-size: 3rem; opacity: 0.3;"></i>
                    <p class="mb-0 mt-2">Nenhuma observação registrada</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
/* Equalizar altura dos cards */
.cards-equal {
    display: flex;
    flex-wrap: wrap;
}

.cards-equal > [class*='col-'] {
    display: flex;
    flex-direction: column;
}

.cards-equal .card {
    flex: 1;
}

@media (max-width: 767px) {
    .cards-equal {
        display: block;
    }
}
</style>

<?php
$content = ob_get_clean();
include \ROOT_PATH . '/views/layouts/app.php';
?>

