<?php
/**
 * Tela de relacionamento de produtos do XML com produtos do sistema
 */
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-link-45deg me-2"></i> Relacionar Produtos do XML</h2>
        <p class="text-muted">Relacione os produtos do XML com produtos do sistema</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/compras/editar?id=' . ($compra['id'] ?? '')) ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<div class="row">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">
                        <i class="bi bi-link-45deg me-2"></i>
                        Relacionar Produtos do XML
                    </h4>
                    <div>
                        <span class="badge bg-info">Compra #<?= htmlspecialchars($compra['id'] ?? '') ?></span>
                        <?php if ($fornecedor): ?>
                            <span class="badge bg-secondary ms-2"><?= htmlspecialchars($fornecedor['name'] ?? '') ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <form id="form-relacionamento" method="POST"
                        action="<?= url('/compras/salvar-relacionamento-produtos') ?>">
                        <input type="hidden" name="compra_id" value="<?= htmlspecialchars($compra['id'] ?? '') ?>">

                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            Relacione cada produto do XML com um produto do sistema. Produtos sem relacionamento não
                            serão adicionados à compra.
                        </div>

                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th width="3%">#</th>
                                        <th width="20%">Produto do XML</th>
                                        <th width="12%">Código/EAN</th>
                                        <th width="8%">Qtd</th>
                                        <th width="12%">Valor Unit.</th>
                                        <th width="12%">Valor Total</th>
                                        <th width="33%">Produto do Sistema</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($itens_xml as $index => $item): ?>
                                        <tr>
                                            <td><?= $index + 1 ?></td>
                                            <td>
                                                <strong><?= htmlspecialchars($item['nome'] ?? 'Sem nome') ?></strong>
                                                <?php if (!empty($item['ncm'])): ?>
                                                    <br><small class="text-muted">NCM:
                                                        <?= htmlspecialchars($item['ncm']) ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if (!empty($item['codigo_produto'])): ?>
                                                    <strong>Código:</strong>
                                                    <?= htmlspecialchars($item['codigo_produto']) ?><br>
                                                <?php endif; ?>
                                                <?php if (!empty($item['ean']) && $item['ean'] !== 'SEM GTIN'): ?>
                                                    <strong>EAN:</strong> <?= htmlspecialchars($item['ean']) ?>
                                                <?php endif; ?>
                                            </td>
                                            <td><?= number_format($item['quantidade'] ?? 0, 3, ',', '.') ?></td>
                                            <td>R$ <?= number_format($item['valor_unitario'] ?? 0, 2, ',', '.') ?></td>
                                            <td><strong>R$
                                                    <?= number_format($item['valor_total'] ?? 0, 2, ',', '.') ?></strong>
                                            </td>
                                            <td>
                                                <div class="d-flex gap-2">
                                                    <div class="position-relative flex-grow-1">
                                                        <input type="hidden" name="relacionamentos[<?= $index ?>]"
                                                            id="produto_id_<?= $index ?>"
                                                            value="<?= $relacionamentos_existentes[$index] ?? '' ?>">
                                                        <input type="text" class="form-control produto-autocomplete"
                                                            id="produto_input_<?= $index ?>" data-index="<?= $index ?>"
                                                            data-item-xml='<?= json_encode($item) ?>'
                                                            placeholder="Digite para buscar produto..." autocomplete="off"
                                                            value="<?php
                                                            if (isset($relacionamentos_existentes[$index])) {
                                                                foreach ($produtos as $p) {
                                                                    if ($p['id'] == $relacionamentos_existentes[$index]) {
                                                                        echo htmlspecialchars($p['name'] . (!empty($p['code']) ? ' (' . $p['code'] . ')' : ''));
                                                                        break;
                                                                    }
                                                                }
                                                            }
                                                            ?>">
                                                        <div class="autocomplete-results" id="autocomplete_<?= $index ?>"
                                                            style="display: none;"></div>
                                                    </div>
                                                    <button type="button"
                                                        class="btn btn-outline-success btn-sm flex-shrink-0"
                                                        onclick="criarProdutoRapido(<?= $index ?>)"
                                                        title="Criar novo produto">
                                                        <i class="bi bi-plus-circle"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="6" class="text-end"><strong>Total:</strong></td>
                                        <td>
                                            <strong>R$
                                                <?= number_format(array_sum(array_column($itens_xml, 'valor_total')), 2, ',', '.') ?></strong>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <a href="<?= url('/compras/editar?id=' . ($compra['id'] ?? '')) ?>"
                                class="btn btn-secondary">
                                <i class="bi bi-arrow-left me-1"></i> Voltar
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle me-1"></i> Salvar Relacionamento
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para criar produto rapidamente -->
<div class="modal fade" id="modalCriarProduto" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Criar Novo Produto</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="form-criar-produto-rapido">
                    <input type="hidden" id="criar_produto_index" value="">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="criar_produto_nome" class="form-label">Nome do Produto <span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="criar_produto_nome" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="criar_produto_codigo" class="form-label">Código/SKU</label>
                            <input type="text" class="form-control" id="criar_produto_codigo">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="criar_produto_ean" class="form-label">EAN/Barcode</label>
                            <input type="text" class="form-control" id="criar_produto_ean">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="criar_produto_ncm" class="form-label">NCM</label>
                            <input type="text" class="form-control" id="criar_produto_ncm">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="criar_produto_unidade" class="form-label">Unidade</label>
                            <input type="text" class="form-control" id="criar_produto_unidade" value="UN"
                                placeholder="UN, KG, etc">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="criar_produto_preco" class="form-label">Preço de Compra</label>
                            <input type="text" class="form-control" id="criar_produto_preco" placeholder="0,00">
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="salvarProdutoRapido()">
                    <i class="bi bi-check-circle me-1"></i> Criar e Relacionar
                </button>
            </div>
        </div>
    </div>
</div>

<style>
    .autocomplete-results {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: white;
        border: 1px solid #ced4da;
        border-radius: 0.375rem;
        max-height: 300px;
        overflow-y: auto;
        z-index: 1000;
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        margin-top: 2px;
    }

    .autocomplete-item {
        padding: 0.5rem 0.75rem;
        cursor: pointer;
        border-bottom: 1px solid #f0f0f0;
    }

    .autocomplete-item:hover,
    .autocomplete-item.active {
        background-color: #f8f9fa;
    }

    .autocomplete-item:last-child {
        border-bottom: none;
    }

    .autocomplete-item strong {
        display: block;
        color: #212529;
    }

    .autocomplete-item small {
        color: #6c757d;
        font-size: 0.875rem;
    }
</style>

<script>
    let timeoutBusca = null;
    let itemAtualFocado = null;

    // Inicializar autocomplete para todos os campos
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.produto-autocomplete').forEach(function (input) {
            const index = input.dataset.index;
            const hiddenInput = document.getElementById('produto_id_' + index);
            const resultsDiv = document.getElementById('autocomplete_' + index);

            // Evento de digitação
            input.addEventListener('input', function (e) {
                const termo = e.target.value.trim();

                clearTimeout(timeoutBusca);

                if (termo.length < 2) {
                    resultsDiv.style.display = 'none';
                    hiddenInput.value = '';
                    return;
                }

                timeoutBusca = setTimeout(function () {
                    buscarProdutos(termo, index, resultsDiv, hiddenInput, input);
                }, 300);
            });

            // Evento de foco
            input.addEventListener('focus', function () {
                itemAtualFocado = index;
                if (input.value.trim().length >= 2) {
                    buscarProdutos(input.value.trim(), index, resultsDiv, hiddenInput, input);
                }
            });

            // Fechar ao clicar fora
            document.addEventListener('click', function (e) {
                if (!input.contains(e.target) && !resultsDiv.contains(e.target)) {
                    resultsDiv.style.display = 'none';
                }
            });

            // Navegação com teclado
            input.addEventListener('keydown', function (e) {
                const items = resultsDiv.querySelectorAll('.autocomplete-item');
                let activeItem = resultsDiv.querySelector('.autocomplete-item.active');
                let activeIndex = activeItem ? Array.from(items).indexOf(activeItem) : -1;

                if (e.key === 'ArrowDown') {
                    e.preventDefault();
                    if (activeIndex < items.length - 1) {
                        if (activeItem) activeItem.classList.remove('active');
                        items[activeIndex + 1].classList.add('active');
                        items[activeIndex + 1].scrollIntoView({ block: 'nearest' });
                    } else if (items.length > 0) {
                        items[0].classList.add('active');
                    }
                } else if (e.key === 'ArrowUp') {
                    e.preventDefault();
                    if (activeIndex > 0) {
                        if (activeItem) activeItem.classList.remove('active');
                        items[activeIndex - 1].classList.add('active');
                        items[activeIndex - 1].scrollIntoView({ block: 'nearest' });
                    }
                } else if (e.key === 'Enter') {
                    e.preventDefault();
                    if (activeItem) {
                        const produtoId = activeItem.dataset.produtoId;
                        const produtoNome = activeItem.dataset.produtoNome;
                        selecionarProdutoAutocomplete(produtoId, produtoNome, index, hiddenInput, input, resultsDiv);
                    }
                } else if (e.key === 'Escape') {
                    resultsDiv.style.display = 'none';
                }
            });
        });
    });

    function buscarProdutos(termo, index, resultsDiv, hiddenInput, input) {
        $.ajax({
            url: appUrl('/produtos/buscar'),
            type: 'GET',
            data: {
                q: termo
            },
            dataType: 'json',
            success: function (response) {
                if (response.success && response.data && response.data.data && response.data.data.length > 0) {
                    resultsDiv.innerHTML = '';
                    response.data.data.forEach(function (produto) {
                        const item = document.createElement('div');
                        item.className = 'autocomplete-item';
                        item.dataset.produtoId = produto.id;
                        item.dataset.produtoNome = produto.name || '';
                        item.innerHTML = `
                            <strong>${produto.name || ''}</strong>
                            ${produto.sku ? `<small>Código: ${produto.sku}</small>` : ''}
                        `;
                        item.addEventListener('click', function () {
                            selecionarProdutoAutocomplete(produto.id, produto.name || '', index, hiddenInput, input, resultsDiv);
                        });
                        resultsDiv.appendChild(item);
                    });
                    resultsDiv.style.display = 'block';
                } else {
                    resultsDiv.innerHTML = '<div class="autocomplete-item text-muted">Nenhum produto encontrado</div>';
                    resultsDiv.style.display = 'block';
                }
            },
            error: function () {
                resultsDiv.innerHTML = '<div class="autocomplete-item text-danger">Erro ao buscar produtos</div>';
                resultsDiv.style.display = 'block';
            }
        });
    }

    function selecionarProdutoAutocomplete(produtoId, produtoNome, index, hiddenInput, input, resultsDiv) {
        hiddenInput.value = produtoId;
        input.value = produtoNome;
        resultsDiv.style.display = 'none';

        // Adicionar classe de sucesso visual
        input.classList.add('is-valid');
        setTimeout(function () {
            input.classList.remove('is-valid');
        }, 2000);
    }

    function criarProdutoRapido(index) {
        const input = document.getElementById('produto_input_' + index);
        const itemXml = JSON.parse(input.dataset.itemXml || '{}');

        // Preencher modal com dados do XML
        document.getElementById('criar_produto_index').value = index;
        document.getElementById('criar_produto_nome').value = itemXml.nome || '';
        document.getElementById('criar_produto_codigo').value = itemXml.codigo_produto || '';
        document.getElementById('criar_produto_ean').value = (itemXml.ean && itemXml.ean !== 'SEM GTIN') ? itemXml.ean : '';
        document.getElementById('criar_produto_ncm').value = itemXml.ncm || '';
        document.getElementById('criar_produto_unidade').value = itemXml.unidade || 'UN';
        document.getElementById('criar_produto_preco').value = itemXml.valor_unitario ? parseFloat(itemXml.valor_unitario).toFixed(2).replace('.', ',') : '';

        const modal = new bootstrap.Modal(document.getElementById('modalCriarProduto'));
        modal.show();
    }

    function salvarProdutoRapido() {
        const index = document.getElementById('criar_produto_index').value;
        const nome = document.getElementById('criar_produto_nome').value.trim();

        if (!nome) {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                text: 'O nome do produto é obrigatório!'
            });
            return;
        }

        Swal.fire({
            title: 'Criando produto...',
            text: 'Aguarde enquanto criamos o produto',
            allowOutsideClick: false,
            showConfirmButton: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        const preco = parseFloat(document.getElementById('criar_produto_preco').value.replace(',', '.') || '0');
        const codigoInformado = document.getElementById('criar_produto_codigo').value.trim();
        const ean = document.getElementById('criar_produto_ean').value.trim();
        const ncm = document.getElementById('criar_produto_ncm').value.trim();
        const unidade = document.getElementById('criar_produto_unidade').value.trim() || 'UN';

        // Garantir que price seja sempre numérico e >= 0
        const priceValue = isNaN(preco) || preco < 0 ? 0.00 : preco;

        const dadosProduto = {
            name: nome,
            description: '',
            barcode: ean || '',
            purchase_price: priceValue,
            price: priceValue,
            cost_price: priceValue,
            type: 'produto',
            is_active: 1,
            stock_quantity: 0,
            min_stock: 0,
            max_stock: 0,
            profit_margin: 0,
            quantidade_embalagem: 1,
            consumo_proprio: 0,
            balanca: 0,
            fracionado: 0,
            category_id: '',
            grupo_id: '',
            subgrupo_id: '',
            grupo_tributacao_id: '',
            stock_address: '',
            stock_entry_location: '',
            stock_exit_location: '',
            weight: '',
            height_cm: '',
            width_cm: '',
            length_cm: '',
            image: ''
        };

        // Adicionar NCM e Unit se preenchidos
        if (ncm) { dadosProduto.ncm = ncm; }
        if (unidade) { dadosProduto.unit = unidade; }

        console.log('Dados do produto a serem enviados:', dadosProduto);

        $.ajax({
            url: appUrl('/produtos/criar'),
            type: 'POST',
            data: dadosProduto,
            dataType: 'json',
            success: function (response) {
                Swal.close();
                if (response.success && response.data && response.data.id) {
                    const produtoId = response.data.id;
                    const produtoNome = response.data.name || nome;

                    // Se informou código, atualizar SKU diretamente
                    if (codigoInformado) {
                        $.ajax({
                            url: appUrl('/compras/atualizar-sku-produto'),
                            type: 'POST',
                            data: {
                                produto_id: produtoId,
                                sku: codigoInformado
                            },
                            dataType: 'json',
                            success: function () {
                                // SKU atualizado
                            },
                            error: function () {
                                // Ignora erro de atualização de SKU
                            }
                        });
                    }

                    // Relacionar automaticamente
                    const hiddenInput = document.getElementById('produto_id_' + index);
                    const input = document.getElementById('produto_input_' + index);

                    hiddenInput.value = produtoId;
                    input.value = produtoNome + (codigoInformado ? ' (' + codigoInformado + ')' : '');
                    input.classList.add('is-valid');

                    // Fechar modal
                    const modal = bootstrap.Modal.getInstance(document.getElementById('modalCriarProduto'));
                    modal.hide();

                    Swal.fire({
                        icon: 'success',
                        title: 'Produto criado!',
                        text: 'Produto criado e relacionado com sucesso',
                        timer: 2000,
                        showConfirmButton: false
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message || 'Erro ao criar produto'
                    });
                }
            },
            error: function (xhr) {
                Swal.close();
                const response = xhr.responseJSON || {};
                console.error('Erro ao criar produto:', response);
                console.error('Status:', xhr.status);
                console.error('Response Text:', xhr.responseText);

                let errorMsg = response.message || 'Erro ao criar produto';
                let errorDetails = '';

                // Se houver erros de validação, mostrar detalhes
                if (response.errors) {
                    if (Array.isArray(response.errors)) {
                        errorDetails = response.errors.join(', ');
                    } else if (typeof response.errors === 'object') {
                        if (response.errors.exception) {
                            errorDetails = response.errors.exception;
                        } else {
                            const errorList = Object.values(response.errors).flat();
                            errorDetails = errorList.join(', ');
                        }
                    }

                    if (errorDetails) {
                        errorMsg += '<br><br><strong>Detalhes:</strong><br>' + errorDetails;
                    }
                } else if (response.data && response.data.exception) {
                    errorMsg += '<br><br><strong>Detalhes:</strong><br>' + response.data.exception;
                }

                // Se não houver detalhes, mostrar mensagem genérica com instrução para verificar logs
                if (!errorDetails) {
                    errorMsg += '<br><br><small class="text-muted">Verifique os logs do servidor para mais detalhes.</small>';
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Erro ao criar produto',
                    html: errorMsg,
                    width: '600px'
                });
            }
        });
    }

    // Auto-preenchimento baseado em relacionamentos existentes e código/EAN
    document.addEventListener('DOMContentLoaded', function () {
        const itensXml = <?= json_encode($itens_xml) ?>;
        const relacionamentosExistentes = <?= json_encode($relacionamentos_existentes ?? []) ?>;
        const produtos = <?= json_encode($produtos) ?>;

        itensXml.forEach(function (item, index) {
            const input = document.getElementById('produto_input_' + index);
            const hiddenInput = document.getElementById('produto_id_' + index);

            if (!input || !hiddenInput) return;

            // Prioridade 1: Relacionamento existente salvo
            if (relacionamentosExistentes[index]) {
                const produto = produtos.find(p => p.id == relacionamentosExistentes[index]);
                if (produto) {
                    hiddenInput.value = produto.id;
                    input.value = produto.name + (produto.code ? ' (' + produto.code + ')' : '');
                    return;
                }
            }

            // Prioridade 2: Buscar por código/EAN do XML
            const codigoXml = item.codigo_produto || '';
            const eanXml = (item.ean && item.ean !== 'SEM GTIN') ? item.ean : '';

            if (codigoXml || eanXml) {
                const produtoEncontrado = produtos.find(function (p) {
                    return (codigoXml && p.code === codigoXml) || (eanXml && p.barcode === eanXml);
                });

                if (produtoEncontrado) {
                    hiddenInput.value = produtoEncontrado.id;
                    input.value = produtoEncontrado.name + (produtoEncontrado.code ? ' (' + produtoEncontrado.code + ')' : '');
                }
            }
        });
    });


    // Submissão do formulário
    document.getElementById('form-relacionamento')?.addEventListener('submit', function (e) {
        e.preventDefault();

        // Coletar relacionamentos dos campos hidden
        const relacionamentos = {};
        document.querySelectorAll('input[type="hidden"][name^="relacionamentos["]').forEach(function (input) {
            const match = input.name.match(/\[(\d+)\]/);
            if (match && input.value && input.value !== 'null' && input.value !== '0') {
                relacionamentos[match[1]] = input.value;
            }
        });

        if (Object.keys(relacionamentos).length === 0) {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                text: 'Selecione pelo menos um produto para relacionar.'
            });
            return;
        }

        Swal.fire({
            title: 'Salvando...',
            text: 'Relacionando produtos e adicionando à compra',
            allowOutsideClick: false,
            showConfirmButton: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        const compraId = document.querySelector('input[name="compra_id"]')?.value;

        if (!compraId) {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'ID da compra não encontrado'
            });
            return;
        }

        $.ajax({
            url: appUrl('/compras/salvar-relacionamento-produtos'),
            type: 'POST',
            data: {
                compra_id: compraId,
                relacionamentos: relacionamentos
            },
            dataType: 'json',
            success: function (response) {
                Swal.close();
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = appUrl('/compras/editar?id=' + compraId);
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message
                    });
                }
            },
            error: function (xhr) {
                Swal.close();
                const response = xhr.responseJSON || {};
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: response.message || 'Erro ao salvar relacionamento'
                });
            }
        });
    });
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'compras';
$pageTitle = 'Relacionar Produtos - Compra #' . ($compra['id'] ?? '');
include \ROOT_PATH . '/views/layouts/app.php';
?>