<?php
ob_start();
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?= url('/compras') ?>">Compras</a></li>
                        <li class="breadcrumb-item active">Importar NFe XML</li>
                    </ol>
                </div>
                <h4 class="page-title">
                    <i class="bi bi-file-earmark-code me-2"></i> Importar NFe XML
                </h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8 offset-lg-2">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="bi bi-upload me-2"></i> Upload de Arquivo XML
                    </h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle me-2"></i>
                        <strong>Instruções:</strong>
                        <ul class="mb-0 mt-2">
                            <li>Selecione o arquivo XML da Nota Fiscal Eletrônica (NFe)</li>
                            <li>O sistema irá verificar se o fornecedor já está cadastrado</li>
                            <li>Se o fornecedor não existir, será cadastrado automaticamente</li>
                            <li>Os produtos serão verificados e cadastrados se necessário</li>
                            <li>Uma compra será criada automaticamente com todos os itens</li>
                        </ul>
                    </div>

                    <form id="formImportarXml" enctype="multipart/form-data">
                        <div class="mb-4">
                            <label for="xml_file" class="form-label">
                                <strong>Arquivo XML da NFe</strong> <span class="text-danger">*</span>
                            </label>
                            <input type="file" class="form-control form-control-lg" id="xml_file" name="xml_file"
                                accept=".xml,application/xml,text/xml" required>
                            <small class="text-muted">Formatos aceitos: XML (máx. 10MB)</small>
                        </div>

                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <a href="<?= url('/compras') ?>" class="btn btn-secondary">
                                <i class="bi bi-arrow-left me-2"></i> Cancelar
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-upload me-2"></i> Importar XML
                            </button>
                        </div>
                    </form>

                    <div id="previewXml" class="mt-4" style="display: none;">
                        <hr>
                        <h6 class="mb-3">Pré-visualização dos Dados</h6>
                        <div id="previewContent" class="bg-light p-3 rounded"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('formImportarXml');
    const fileInput = document.getElementById('xml_file');
    const previewDiv = document.getElementById('previewXml');
    const previewContent = document.getElementById('previewContent');

    // Preview do XML (opcional)
    fileInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file && file.type === 'application/xml' || file.name.endsWith('.xml')) {
            const reader = new FileReader();
            reader.onload = function(e) {
                try {
                    const parser = new DOMParser();
                    const xmlDoc = parser.parseFromString(e.target.result, 'text/xml');

                    // Verificar erros de parsing
                    const parserError = xmlDoc.querySelector('parsererror');
                    if (parserError) {
                        previewContent.innerHTML = '<div class="alert alert-danger">Erro ao ler XML: ' + parserError.textContent + '</div>';
                        previewDiv.style.display = 'block';
                        return;
                    }

                    // Extrair informações básicas
                    const emit = xmlDoc.querySelector('emit');
                    const ide = xmlDoc.querySelector('ide');

                    let html = '<div class="row">';

                    if (emit) {
                        const cnpj = emit.querySelector('CNPJ')?.textContent || '';
                        const nome = emit.querySelector('xNome')?.textContent || '';
                        html += '<div class="col-md-6"><strong>Fornecedor:</strong><br>';
                        html += nome + '<br><small class="text-muted">CNPJ: ' + cnpj + '</small></div>';
                    }

                    if (ide) {
                        const nNF = ide.querySelector('nNF')?.textContent || '';
                        const serie = ide.querySelector('serie')?.textContent || '';
                        const dhEmi = ide.querySelector('dhEmi')?.textContent || '';
                        html += '<div class="col-md-6"><strong>NFe:</strong><br>';
                        html += 'Número: ' + nNF + ' | Série: ' + serie + '<br>';
                        html += '<small class="text-muted">Emissão: ' + dhEmi + '</small></div>';
                    }

                    html += '</div>';
                    previewContent.innerHTML = html;
                    previewDiv.style.display = 'block';
                } catch (error) {
                    previewContent.innerHTML = '<div class="alert alert-warning">Não foi possível fazer preview do XML</div>';
                    previewDiv.style.display = 'block';
                }
            };
            reader.readAsText(file);
        }
    });

    // Submissão do formulário
    form.addEventListener('submit', function(e) {
        e.preventDefault();

        const formData = new FormData(this);
        const file = fileInput.files[0];

        if (!file) {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Por favor, selecione um arquivo XML'
            });
            return;
        }

        // Validar tamanho (10MB)
        if (file.size > 10 * 1024 * 1024) {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'O arquivo é muito grande. Tamanho máximo: 10MB'
            });
            return;
        }

        Swal.fire({
            title: 'Importando XML...',
            text: 'Por favor, aguarde enquanto processamos a NFe',
            allowOutsideClick: false,
            allowEscapeKey: false,
            showConfirmButton: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: appUrl('/compras/processar-xml'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message,
                        confirmButtonText: 'Ver Compra',
                        showCancelButton: true,
                        cancelButtonText: 'Fechar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = appUrl(response.data?.redirect || '/compras');
                        } else {
                            window.location.href = appUrl('/compras');
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message || 'Erro ao processar XML'
                    });
                }
            },
            error: function(xhr) {
                let errorMsg = 'Erro ao processar XML';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMsg = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: errorMsg
                });
            }
        });
    });
});
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'compras';
include ROOT_PATH . '/views/layouts/app.php';
?>

