<?php
$isEdit = isset($compra['id']);
$proximoNumero = $proximoNumero ?? 'CPR-000001';
$usarLoteCompra = $usarLoteCompra ?? false;
?>

<!-- Abas -->
<ul class="nav nav-tabs mb-4" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados" type="button" role="tab">
            <i class="bi bi-file-earmark-text me-2"></i> Dados da Compra
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="itens-tab" data-bs-toggle="tab" data-bs-target="#itens" type="button" role="tab">
            <i class="bi bi-box-seam me-2"></i> Itens
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="despesas-tab" data-bs-toggle="tab" data-bs-target="#despesas" type="button" role="tab">
            <i class="bi bi-receipt me-2"></i> Despesas
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="entrega-tab" data-bs-toggle="tab" data-bs-target="#entrega" type="button" role="tab">
            <i class="bi bi-truck me-2"></i> Frete e Entrega
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pagamento-tab" data-bs-toggle="tab" data-bs-target="#pagamento" type="button" role="tab">
            <i class="bi bi-credit-card me-2"></i> Pagamento e Valores
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="centro-custos-tab" data-bs-toggle="tab" data-bs-target="#centro-custos" type="button" role="tab">
            <i class="bi bi-diagram-3 me-2"></i> Centro de Custos
        </button>
    </li>
</ul>

<!-- Conteúdo das Abas -->
<div class="tab-content">
    <!-- Aba: Dados da Compra -->
    <div class="tab-pane fade show active" id="dados" role="tabpanel">
        <div class="card">
            <div class="card-header bg-success text-white">
                <i class="bi bi-file-earmark-text me-2"></i> Informações Principais
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label for="numero" class="form-label">Número da Compra *</label>
                        <input type="text" class="form-control" id="numero" name="numero"
                            value="<?= htmlspecialchars($compra['numero'] ?? $proximoNumero) ?>" required>
                        <small class="text-muted">Identificador único</small>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="data_compra" class="form-label">Data da Compra *</label>
                        <input type="date" class="form-control" id="data_compra" name="data_compra"
                            value="<?= $compra['data_compra'] ?? date('Y-m-d') ?>" required>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="data_entrega" class="form-label">Previsão Entrega</label>
                        <input type="date" class="form-control" id="data_entrega" name="data_entrega"
                            value="<?= $compra['data_entrega'] ?? '' ?>">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="status" class="form-label">Status *</label>
                        <select class="form-select" id="status" name="status" required>
                            <?php
                            // Lista estática de status
                            $statusLista = [
                                'orcamento' => 'Orçamento',
                                'faturado' => 'Faturado',
                                'aguardando_entrega' => 'Aguardando Entrega',
                                'recebido' => 'Recebido',
                                'cancelado' => 'Cancelado'
                            ];

                            $statusAtual = $compra['status'] ?? 'orcamento';

                            foreach ($statusLista as $codigo => $nome) {
                                $selected = ($statusAtual === $codigo) ? 'selected' : '';
                                echo "<option value=\"{$codigo}\" {$selected}>{$nome}</option>\n";
                            }
                            ?>
                        </select>
                    </div>
                </div>
<hr class="my-4">

                <!-- Empresa -->
                <h6 class="text-success mb-3">
                    <i class="bi bi-building me-2"></i> Empresa
                </h6>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <select class="form-select" id="empresa_id" name="empresa_id" <?= ($isEdit && !empty($itens)) ? '' : 'required' ?>>
                            <option value="">Selecione uma empresa...</option>
                            <?php if (!empty($empresasVinculadas ?? [])): ?>
                                <?php foreach ($empresasVinculadas as $empresa): ?>
                                    <?php
                                    $nome = $empresa['razao_social'] ?? $empresa['nome_fantasia'] ?? 'Empresa';
                                    $cnpj = $empresa['cnpj'] ?? '';
                                    if ($cnpj && strlen($cnpj) === 14) {
                                        $cnpj = preg_replace('/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/', '$1.$2.$3/$4-$5', $cnpj);
                                    }
                                    $empresaIdCompra = $empresaSelecionadaId ?? (isset($compra) && isset($compra['empresa_id']) ? $compra['empresa_id'] : '');
                                    $selected = ($empresaIdCompra == $empresa['id']) ? 'selected' : '';
                                    ?>
                                    <option value="<?= $empresa['id'] ?>" <?= $selected ?>>
                                        <?= htmlspecialchars($nome) ?>
                                        <?= $cnpj ? ' - ' . htmlspecialchars($cnpj) : '' ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <small class="text-muted">Empresa que está realizando a compra</small>
                    </div>
                </div>
                <hr class="my-4">

                <!-- Fornecedor com Autocomplete -->
                <h6 class="text-success mb-3">
                    <i class="bi bi-building me-2"></i> Fornecedor
                </h6>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <div class="position-relative">
                            <input type="text" class="form-control" id="fornecedor_search"
                                placeholder="Digite nome, razão social ou CNPJ do fornecedor..." autocomplete="off"
                                value="<?= htmlspecialchars($fornecedor['name'] ?? '') ?>" required>
                            <div id="fornecedor_dropdown" class="autocomplete-dropdown" style="display: none;"></div>
                        </div>
                        <input type="hidden" id="fornecedor_id" name="fornecedor_id" value="<?= $compra['fornecedor_id'] ?? '' ?>" required>
                    </div>
                    <div class="col-md-12" id="fornecedor_info" style="display: none;">
                        <div class="alert alert-info mb-3">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1" id="fornecedor_info_dados"></div>
                                <button type="button" class="btn btn-sm btn-outline-danger ms-2" onclick="limparFornecedor()">
                                    <i class="bi bi-x"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label for="notes" class="form-label">Observações</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3"
                            placeholder="Observações sobre esta compra..."><?= htmlspecialchars($compra['notes'] ?? '') ?></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Itens -->
    <div class="tab-pane fade" id="itens" role="tabpanel">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <i class="bi bi-box-seam me-2"></i> Produtos/Itens
            </div>
            <div class="card-body">
                <!-- Bloco fixo para adicionar item -->
                <div class="card bg-light mb-4">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Item</h6>
                        <div class="row">
                            <div class="<?= ($usarLoteCompra ?? false) ? 'col-md-6' : 'col-md-12' ?> mb-3">
                                <label class="form-label">Item</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control item-search" id="item_search_principal"
                                        placeholder="Digite para buscar produto..." autocomplete="off">
                                    <div id="item_dropdown_principal" class="autocomplete-dropdown" style="display: none;"></div>
                                </div>
                                <input type="hidden" id="produto_id_principal" value="">
                            </div>
                            <?php if ($usarLoteCompra ?? false): ?>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">Lote</label>
                                <input type="text" class="form-control" id="lote_principal" placeholder="Nº do lote">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">Data Fabricação</label>
                                <input type="date" class="form-control" id="data_fabricacao_principal">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">Data Validade</label>
                                <input type="date" class="form-control" id="data_validade_principal">
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="row">
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Qtd</label>
                                <input type="number" class="form-control form-control-sm text-center" id="qtd_principal"
                                    min="0.001" step="0.001" value="1">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Preço Unit. (R$)</label>
                                <input type="number" class="form-control form-control-sm" id="preco_principal"
                                    step="0.01" min="0" value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Desc. (R$)</label>
                                <input type="number" class="form-control form-control-sm" id="desconto_principal"
                                    step="0.01" min="0" value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Total (R$)</label>
                                <input type="number" class="form-control form-control-sm fw-bold" id="total_principal"
                                    step="0.01" readonly value="0">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">Obs.</label>
                                <input type="text" class="form-control form-control-sm" id="obs_principal" placeholder="Obs">
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="form-label small">&nbsp;</label>
                                <button type="button" class="btn btn-sm btn-success w-100" onclick="adicionarItemNaTabela()">
                                    <i class="bi bi-plus-circle me-1"></i> Adicionar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tabela de itens -->
                <div id="tabela-itens">
                    <table class="table table-hover table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="<?= ($usarLoteCompra ?? false) ? '20%' : '35%' ?>">Item</th>
                                <?php if ($usarLoteCompra ?? false): ?>
                                <th width="10%">Lote</th>
                                <th width="10%">Fab.</th>
                                <th width="10%">Val.</th>
                                <?php endif; ?>
                                <th width="8%" class="text-center">Qtd</th>
                                <th width="10%" class="text-end">Unit.</th>
                                <th width="10%" class="text-end">Desc.</th>
                                <th width="10%" class="text-end">Total</th>
                                <th width="<?= ($usarLoteCompra ?? false) ? '12%' : '17%' ?>">Obs.</th>
                                <th width="10%"></th>
                            </tr>
                        </thead>
                        <tbody id="tbody-itens"></tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="4" class="text-end"><strong>Total:</strong></td>
                                <td class="text-end"><strong id="total-geral">R$ 0,00</strong></td>
                                <td colspan="2"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="alert alert-info" id="alert-sem-itens">
                    <i class="bi bi-info-circle me-2"></i>
                    Nenhum item adicionado. Use o formulário acima para adicionar itens.
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Despesas -->
    <div class="tab-pane fade" id="despesas" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-receipt me-2"></i> Despesas Adicionais
            </div>
            <div class="card-body">
                <div class="card bg-light mb-4">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Despesa</h6>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="despesa_tipo" class="form-label">Tipo de Despesa</label>
                                <select class="form-select" id="despesa_tipo">
                                    <option value="">Selecione...</option>
                                    <option value="frete">Frete</option>
                                    <option value="seguro">Seguro</option>
                                    <option value="desembaraco">Desembaraço Aduaneiro</option>
                                    <option value="taxa_administrativa">Taxa Administrativa</option>
                                    <option value="embalagem">Embalagem</option>
                                    <option value="outro">Outro</option>
                                </select>
                            </div>
                            <div class="col-md-5 mb-3">
                                <label for="despesa_descricao" class="form-label">Descrição</label>
                                <input type="text" class="form-control" id="despesa_descricao" placeholder="Descrição da despesa">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label for="despesa_valor" class="form-label">Valor (R$)</label>
                                <input type="number" class="form-control" id="despesa_valor" step="0.01" min="0" placeholder="0,00">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">&nbsp;</label>
                                <button type="button" class="btn btn-success w-100" onclick="adicionarDespesa()">
                                    <i class="bi bi-plus-circle me-1"></i> Adicionar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="tabela-despesas" style="display: none;">
                    <table class="table table-hover table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="20%">Tipo</th>
                                <th width="50%">Descrição</th>
                                <th width="20%" class="text-end">Valor</th>
                                <th width="10%"></th>
                            </tr>
                        </thead>
                        <tbody id="tbody-despesas"></tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="2" class="text-end"><strong>Total Despesas:</strong></td>
                                <td class="text-end"><strong id="total-despesas">R$ 0,00</strong></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="alert alert-info" id="alert-sem-despesas">
                    <i class="bi bi-info-circle me-2"></i>
                    Nenhuma despesa adicionada. Use o formulário acima para adicionar despesas.
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Frete e Entrega -->
    <div class="tab-pane fade" id="entrega" role="tabpanel">
        <div class="row">
            <div class="col-lg-6">
                <div class="card h-100">
                    <div class="card-header">
                        <i class="bi bi-geo-alt me-2"></i> Local de Recebimento
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8 mb-3">
                                <label for="delivery_street" class="form-label">Rua/Logradouro</label>
                                <input type="text" class="form-control" id="delivery_street" name="delivery_street"
                                    value="<?= htmlspecialchars($compra['delivery_street'] ?? '') ?>" placeholder="Nome da rua">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="delivery_number" class="form-label">Número</label>
                                <input type="text" class="form-control" id="delivery_number" name="delivery_number"
                                    value="<?= htmlspecialchars($compra['delivery_number'] ?? '') ?>" placeholder="123">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="delivery_complement" class="form-label">Complemento</label>
                                <input type="text" class="form-control" id="delivery_complement" name="delivery_complement"
                                    value="<?= htmlspecialchars($compra['delivery_complement'] ?? '') ?>" placeholder="Apartamento, bloco...">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-5 mb-3">
                                <label for="delivery_city" class="form-label">Cidade</label>
                                <input type="text" class="form-control" id="delivery_city" name="delivery_city"
                                    value="<?= htmlspecialchars($compra['delivery_city'] ?? '') ?>" placeholder="Cidade">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label for="delivery_state" class="form-label">UF</label>
                                <input type="text" class="form-control text-uppercase" id="delivery_state" name="delivery_state"
                                    value="<?= htmlspecialchars($compra['delivery_state'] ?? '') ?>" placeholder="UF" maxlength="2">
                            </div>
                            <div class="col-md-5 mb-3">
                                <label for="delivery_zip" class="form-label">CEP</label>
                                <input type="text" class="form-control" id="delivery_zip" name="delivery_zip"
                                    value="<?= htmlspecialchars($compra['delivery_zip'] ?? '') ?>" placeholder="00000-000">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="delivery_notes" class="form-label">Observações de Recebimento</label>
                                <textarea class="form-control" id="delivery_notes" name="delivery_notes" rows="3"
                                    placeholder="Instruções especiais..."><?= htmlspecialchars($compra['delivery_notes'] ?? '') ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card h-100">
                    <div class="card-header">
                        <i class="bi bi-truck-front-fill me-2"></i> Transportadora e Frete
                    </div>
                    <div class="card-body">
                        <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i> Transportadora</h6>
                        <div class="mb-3">
                            <label for="carrier_name" class="form-label">Nome da Transportadora</label>
                            <input type="text" class="form-control" id="carrier_name" name="carrier_name"
                                value="<?= htmlspecialchars($compra['carrier_name'] ?? '') ?>" placeholder="Nome">
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="carrier_cnpj" class="form-label">CNPJ</label>
                                <input type="text" class="form-control" id="carrier_cnpj" name="carrier_cnpj"
                                    value="<?= htmlspecialchars($compra['carrier_cnpj'] ?? '') ?>" placeholder="00.000.000/0000-00">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="carrier_ie" class="form-label">Inscrição Estadual</label>
                                <input type="text" class="form-control" id="carrier_ie" name="carrier_ie"
                                    value="<?= htmlspecialchars($compra['carrier_ie'] ?? '') ?>" placeholder="IE">
                            </div>
                        </div>

                        <hr class="my-3">

                        <h6 class="text-primary mb-3"><i class="bi bi-box-seam me-2"></i> Frete e Volumes</h6>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="freight_type" class="form-label">Tipo de Frete</label>
                                <select class="form-select" id="freight_type" name="freight_type">
                                    <option value="">Selecione...</option>
                                    <option value="cif" <?= ($compra['freight_type'] ?? '') === 'cif' ? 'selected' : '' ?>>CIF (Por conta do remetente)</option>
                                    <option value="fob" <?= ($compra['freight_type'] ?? '') === 'fob' ? 'selected' : '' ?>>FOB (Por conta do destinatário)</option>
                                    <option value="terceiros" <?= ($compra['freight_type'] ?? '') === 'terceiros' ? 'selected' : '' ?>>Terceiros</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="freight_value" class="form-label">Valor Frete (R$)</label>
                                <input type="number" class="form-control" id="freight_value" name="freight_value"
                                    step="0.01" min="0" value="<?= $compra['freight_value'] ?? '0.00' ?>" placeholder="0,00">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="volume_quantity" class="form-label">Quantidade Volumes</label>
                                <input type="number" class="form-control" id="volume_quantity" name="volume_quantity"
                                    min="0" value="<?= $compra['volume_quantity'] ?? '' ?>" placeholder="0">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="volume_species" class="form-label">Espécie</label>
                                <input type="text" class="form-control" id="volume_species" name="volume_species"
                                    value="<?= htmlspecialchars($compra['volume_species'] ?? '') ?>" placeholder="Caixa, Pacote...">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Centro de Custos -->
    <div class="tab-pane fade" id="centro-custos" role="tabpanel">
        <div class="card">
            <div class="card-header bg-info text-white">
                <i class="bi bi-diagram-3 me-2"></i> Distribuição por Centro de Custos
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <i class="bi bi-info-circle me-2"></i>
                    <strong>Distribua o total da compra entre um ou mais centros de custos.</strong>
                    <br>A soma dos valores deve ser igual ao total da compra.
                </div>

                <div class="card bg-light mb-4">
                    <div class="card-body">
                        <h6 class="mb-3"><i class="bi bi-plus-circle me-2"></i> Adicionar Centro de Custo</h6>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="centro_custo_select" class="form-label">Centro de Custo *</label>
                                <select class="form-select" id="centro_custo_select">
                                    <option value="">Selecione...</option>
                                    <?php if (!empty($centrosCustos)): ?>
                                    <?php foreach ($centrosCustos as $centro): ?>
                                    <option value="<?= $centro['id'] ?>" data-code="<?= htmlspecialchars($centro['code']) ?>">
                                        <?= htmlspecialchars($centro['code']) ?> - <?= htmlspecialchars($centro['name']) ?>
                                    </option>
                                    <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="centro_custo_valor" class="form-label">Valor (R$) *</label>
                                <input type="number" class="form-control" id="centro_custo_valor" step="0.01" min="0" placeholder="0,00">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">&nbsp;</label>
                                <button type="button" class="btn btn-info w-100" onclick="adicionarCentroCusto()">
                                    <i class="bi bi-plus-circle me-1"></i> Adicionar
                                </button>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text-muted">Total da Compra: <strong id="total-compra-display">R$ 0,00</strong></span>
                                    <span class="text-muted">Total Distribuído: <strong id="total-distribuido-display" class="text-success">R$ 0,00</strong></span>
                                    <span class="text-muted">Restante: <strong id="total-restante-display" class="text-warning">R$ 0,00</strong></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="tabela-centro-custos" style="display: none;">
                    <table class="table table-hover table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="15%">Código</th>
                                <th width="40%">Centro de Custo</th>
                                <th width="20%" class="text-end">Valor (R$)</th>
                                <th width="15%" class="text-end">Percentual</th>
                                <th width="10%"></th>
                            </tr>
                        </thead>
                        <tbody id="tbody-centro-custos"></tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="2" class="text-end"><strong>Total:</strong></td>
                                <td class="text-end"><strong id="total-centro-custos">R$ 0,00</strong></td>
                                <td class="text-end"><strong id="total-percentual">0%</strong></td>
                                <td></td>
                                <td style="display: none;"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="alert alert-info" id="alert-sem-centro-custos">
                    <i class="bi bi-info-circle me-2"></i>
                    Nenhum centro de custo adicionado. Use o formulário acima para distribuir o valor da compra.
                </div>
            </div>
        </div>
    </div>

    <!-- Aba: Pagamento e Valores -->
    <div class="tab-pane fade" id="pagamento" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-credit-card me-2"></i> Pagamento e Valores
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Coluna Esquerda: Valores -->
                    <div class="col-lg-6">
                        <h6 class="text-primary mb-3"><i class="bi bi-currency-dollar me-2"></i> Valores</h6>

                        <div class="mb-3">
                            <label class="form-label"><strong>Subtotal</strong></label>
                            <div class="input-group">
                                <span class="input-group-text">R$</span>
                                <input type="text" class="form-control text-end" id="subtotal_display" readonly value="<?= isset($compra['subtotal']) ? number_format($compra['subtotal'], 2, ',', '.') : '0,00' ?>">
                            </div>
                            <input type="hidden" id="subtotal" name="subtotal" value="<?= isset($compra['subtotal']) ? number_format($compra['subtotal'], 2, '.', '') : '0.00' ?>">
                            <small class="text-muted">Itens + Despesas + Frete</small>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="discount_type" class="form-label">Tipo de Desconto</label>
                                <select class="form-select" id="discount_type" name="discount_type">
                                    <option value="fixed" <?= ($compra['discount_type'] ?? 'fixed') === 'fixed' ? 'selected' : '' ?>>Valor Fixo (R$)</option>
                                    <option value="percent" <?= ($compra['discount_type'] ?? '') === 'percent' ? 'selected' : '' ?>>Percentual (%)</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="discount" class="form-label">Desconto</label>
                                <input type="number" class="form-control" id="discount" name="discount"
                                    step="0.01" min="0" value="<?= $compra['discount'] ?? '0.00' ?>" placeholder="0,00">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="plano_contas_id" class="form-label">Plano de Contas</label>
                            <select class="form-select" id="plano_contas_id" name="plano_contas_id">
                                <option value="">Selecione...</option>
                                <?php if (!empty($planoContas)): ?>
                                <?php foreach ($planoContas as $conta): ?>
                                <option value="<?= $conta['id'] ?>" <?= ($compra['plano_contas_id'] ?? '') == $conta['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars(($conta['codigo'] ?? $conta['code'] ?? '')) ?> - <?= htmlspecialchars(($conta['nome'] ?? $conta['name'] ?? '')) ?>
                                </option>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                            <small class="text-muted">Selecione a conta contábil para esta compra</small>
                        </div>

                        <hr class="my-3">

                        <div class="mb-3">
                            <label class="form-label"><strong class="text-success fs-5">TOTAL FINAL</strong></label>
                            <div class="input-group input-group-lg">
                                <span class="input-group-text bg-success text-white fw-bold">R$</span>
                                <input type="text" class="form-control text-end fw-bold" id="total_display" readonly value="<?= isset($compra['total']) ? number_format($compra['total'], 2, ',', '.') : '0,00' ?>">
                            </div>
                            <input type="hidden" id="total" name="total" value="<?= isset($compra['total']) ? number_format($compra['total'], 2, '.', '') : '0.00' ?>">
                            <input type="hidden" id="shipping" name="shipping" value="0.00">
                        </div>
                    </div>

                    <!-- Coluna Direita: Forma de Pagamento -->
                    <div class="col-lg-6">
                        <h6 class="text-primary mb-3"><i class="bi bi-credit-card me-2"></i> Forma de Pagamento</h6>

                        <div class="mb-3">
                            <label for="payment_method_id" class="form-label">Método de Pagamento</label>
                            <select class="form-select" id="payment_method_id" name="payment_method_id">
                                <option value="">Selecione...</option>
                                <?php if (!empty($metodosPagamento)): ?>
                                <?php foreach ($metodosPagamento as $metodo): ?>
                                <option value="<?= $metodo['id'] ?>"
                                    <?= ($compra['payment_method_id'] ?? '') == $metodo['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($metodo['name']) ?>
                                </option>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        <input type="hidden" id="installments" name="installments" value="<?= $compra['installments'] ?? 1 ?>">

                        <!-- Exibição do Parcelamento -->
                        <div id="parcelamento-info" class="alert alert-info mb-3 d-none">
                            <div class="d-flex align-items-start">
                                <i class="bi bi-calendar-check me-2 mt-1" style="font-size: 1.25rem;"></i>
                                <div class="flex-grow-1">
                                    <strong class="d-block mb-2" style="color: #0d6efd;">
                                        <i class="bi bi-receipt-cutoff me-1"></i> Parcelamento Selecionado
                                    </strong>
                                    <div id="parcelamento-detalhes" style="font-size: 0.95rem;"></div>
                                </div>
                                <button type="button" class="btn btn-sm btn-link text-primary p-0 ms-2"
                                    onclick="$('#payment_method_id').trigger('change')" title="Alterar">
                                    <i class="bi bi-pencil-fill"></i>
                                </button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($isEdit): ?>
<input type="hidden" name="id" value="<?= $compra['id'] ?>">
<?php endif; ?>

<style>
.autocomplete-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: #fff;
    border: 1px solid #dee2e6;
    border-top: none;
    border-radius: 0 0 0.375rem 0.375rem;
    max-height: 300px;
    overflow-y: auto;
    z-index: 1000;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.autocomplete-item {
    padding: 0.875rem 1rem;
    cursor: pointer;
    border-bottom: 1px solid #f0f0f0;
    transition: all 0.15s ease-in-out;
}

.autocomplete-item:hover {
    background-color: #0d6efd;
    color: white;
    transform: translateX(3px);
}

.autocomplete-item:hover .text-muted {
    color: rgba(255, 255, 255, 0.8) !important;
}

.autocomplete-item:last-child {
    border-bottom: none;
}

.autocomplete-no-results {
    padding: 1rem;
    text-align: center;
    color: #6c757d;
    font-style: italic;
}
</style>

<script>
// Declarar variáveis
let itensTabela = [];
let itensCompra = []; // Array para validação e envio
let itemIndex = 0;
let itemTimeoutPrincipal = null;
let despesasTabela = [];
let despesaIndex = 0;
let centrosCustosTabela = [];
let centroCustoIndex = 0;

// Dados do PHP
const fornecedoresData = <?= json_encode($fornecedores ?? []) ?>;
const produtosData = <?= json_encode($produtos ?? []) ?>;
let selectedFornecedor = null;
let selectedProduto = null;
let autocompleteTimeout = null;

// Aguardar jQuery
(function aguardarJQuery() {
    if (typeof jQuery === 'undefined') {
        setTimeout(aguardarJQuery, 100);
        return;
    }
    inicializarFormularioCompra();
})();

function inicializarFormularioCompra() {
    // Inicializar autocomplete
    inicializarAutocompleteFornecedor();
    inicializarAutocompleteItemPrincipal();

    // Eventos de cálculo
    $('#discount, #discount_type, #freight_value').on('input change', function() {
        calcularTotalGeral();
        atualizarTotalCompraDisplay();
    });
    $('#qtd_principal, #preco_principal, #desconto_principal').on('input', calcularTotalPrincipal);

    // Atualizar total da compra quando mudar
    $('#total').on('change', atualizarTotalCompraDisplay);

    // Inicializar total da compra
    atualizarTotalCompraDisplay();

    // Método de pagamento
    $('#payment_method_id').on('change', function() {
        const metodoId = $(this).val();
        $('#parcelamento-info').addClass('d-none');
        $('#installments').val(1);
        if (metodoId) {
            mostrarPrazosMetodoPagamento(metodoId);
        }
    });

    // Inicializar: sempre começa com tabela oculta
    $('#tabela-itens').hide();
    $('#alert-sem-itens').show();

    // Carregar itens existentes (se houver)
    <?php if ($isEdit && !empty($itens)): ?>
    <?php foreach ($itens as $item): ?>
    adicionarItemNaTabela(<?= json_encode($item) ?>, true);
    <?php endforeach; ?>
    <?php endif; ?>

    // Recalcular totais
    atualizarTotalGeral();
    calcularTotalGeral();

    // Atualizar display do total na aba de Centro de Custos
    atualizarTotalCompraDisplay();
}

// ============================================
// AUTOCOMPLETE DE FORNECEDOR
// ============================================
function inicializarAutocompleteFornecedor() {
    const $search = $('#fornecedor_search');
    const $dropdown = $('#fornecedor_dropdown');

    $search.on('input', function() {
        const query = $(this).val().trim().toLowerCase();
        clearTimeout(autocompleteTimeout);

        if (query.length < 2) {
            $dropdown.hide();
            return;
        }

        autocompleteTimeout = setTimeout(() => buscarFornecedores(query), 300);
    });

    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarFornecedores($(this).val().trim().toLowerCase());
        }
    });

    $(document).on('click', function(e) {
        if (!$(e.target).closest('#fornecedor_search, #fornecedor_dropdown').length) {
            $dropdown.hide();
        }
    });

    // Carregar fornecedor existente
    <?php if ($isEdit && !empty($compra['fornecedor_id']) && !empty($fornecedor)): ?>
    selecionarFornecedor(<?= json_encode($fornecedor) ?>);
    <?php endif; ?>
}

function buscarFornecedores(query) {
    const $dropdown = $('#fornecedor_dropdown');

    // Filtrar fornecedores
    const results = fornecedoresData.filter(forn => {
        const name = (forn.name || '').toLowerCase();
        const tradeName = (forn.trade_name || '').toLowerCase();
        const document = (forn.document || '').toLowerCase();
        const email = (forn.email || '').toLowerCase();
        const phone = (forn.phone || '').toLowerCase();
        const mobile = (forn.mobile || '').toLowerCase();

        // Normalizar query e documento para busca mais flexível
        const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
        const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

        return name.includes(query) || tradeName.includes(query) ||
               document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
               email.includes(query) || phone.includes(query) || mobile.includes(query);
    });

    // Montar HTML
    let html = '';

    if (results.length > 0) {
        results.forEach(forn => {
            const nomeFantasia = forn.trade_name || '-';
            const razaoSocial = forn.name || '-';
            const documento = forn.document || 'Não informado';
            const codigo = String(forn.id).padStart(4, '0');
            const telefone = forn.phone || forn.mobile || '-';
            const email = forn.email || '-';

            html += `
                <div class="autocomplete-item" data-id="${forn.id}">
                    <div class="mb-1">
                        <strong>Código: ${codigo}</strong>  |  <strong>CNPJ/CPF:</strong> ${documento}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                    </div>
                    <div class="text-muted small">
                        <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                    </div>
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhum fornecedor encontrado</div>';
    }

    $dropdown.html(html).show();

    // Event listeners
    $dropdown.find('.autocomplete-item').on('click', function() {
        const fornecedorId = $(this).data('id');
        const fornecedor = fornecedoresData.find(f => f.id == fornecedorId);
        if (fornecedor) {
            selecionarFornecedor(fornecedor);
        }
    });
}

function selecionarFornecedor(forn) {
    selectedFornecedor = forn;

    const nomeFantasia = forn.trade_name || '-';
    const razaoSocial = forn.name || '-';
    const nomeExibir = nomeFantasia !== '-' ? nomeFantasia : razaoSocial;
    const codigo = String(forn.id).padStart(4, '0');
    const documento = forn.document || 'Não informado';
    const telefone = forn.phone || forn.mobile || '-';
    const email = forn.email || '-';

    // Preencher campos hidden
    $('#fornecedor_id').val(forn.id);
    $('#fornecedor_search').val(nomeExibir);

    let infoHtml = `
        <div style="line-height: 1.6;">
            <div class="mb-1">
                <strong>Código: ${codigo}</strong>  |  <strong>CNPJ/CPF:</strong> ${documento}
            </div>
            <div class="mb-1">
                <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
            </div>
            <div class="text-muted small">
                <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
            </div>
        </div>
    `;

    $('#fornecedor_info_dados').html(infoHtml);
    $('#fornecedor_info').slideDown();
    $('#fornecedor_dropdown').hide();
}

function limparFornecedor() {
    selectedFornecedor = null;
    $('#fornecedor_id').val('');
    $('#fornecedor_search').val('');
    $('#fornecedor_info').slideUp();
}

// ============================================
// AUTOCOMPLETE DE ITEM
// ============================================
function inicializarAutocompleteItemPrincipal() {
    const $search = $('#item_search_principal');
    const $dropdown = $('#item_dropdown_principal');

    $search.on('input', function() {
        const query = $(this).val().trim().toLowerCase();
        clearTimeout(itemTimeoutPrincipal);
        if (query.length < 2) {
            $dropdown.hide();
            return;
        }
        itemTimeoutPrincipal = setTimeout(() => buscarProdutosPrincipal(query), 300);
    });

    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarProdutosPrincipal($(this).val().trim().toLowerCase());
        }
    });

    $(document).on('click', function(e) {
        if (!$(e.target).closest('#item_search_principal, #item_dropdown_principal').length) {
            $dropdown.hide();
        }
    });
}

function buscarProdutosPrincipal(query) {
    const $dropdown = $('#item_dropdown_principal');
    const results = produtosData.filter(produto => {
        const name = (produto.name || '').toLowerCase();
        const code = (produto.code || '').toLowerCase();
        return name.includes(query) || code.includes(query);
    });

    let html = '';
    if (results.length > 0) {
        results.forEach(produto => {
            const preco = parseFloat(produto.purchase_price || produto.cost_price || 0);
            html += `
                <div class="autocomplete-item" data-id="${produto.id}">
                    <div class="mb-1"><strong>${produto.name}</strong> ${produto.code ? '<span class="text-muted">(' + produto.code + ')</span>' : ''}</div>
                    <div class="text-muted small">
                        <strong>Preço:</strong> R$ ${preco.toFixed(2).replace('.', ',')} |
                        <strong>Estoque:</strong> ${produto.stock_quantity || 0} ${produto.unit || 'UN'}
                    </div>
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhum produto encontrado</div>';
    }

    $dropdown.html(html).show();
    $dropdown.find('.autocomplete-item').on('click', function() {
        const id = $(this).data('id');
        const produto = produtosData.find(p => p.id == id);
        if (produto) selecionarProdutoPrincipal(produto);
    });
}

function selecionarProdutoPrincipal(produto) {
    selectedProduto = produto;
    $('#produto_id_principal').val(produto.id);
    $('#item_search_principal').val(produto.name);
    $('#preco_principal').val(parseFloat(produto.purchase_price || produto.cost_price || 0).toFixed(2));
    $('#item_dropdown_principal').hide();
    $('#qtd_principal').focus().select();
    calcularTotalPrincipal();

    // Dados fiscais
    selectedProduto.fiscal = {
        ncm: produto.ncm || '',
        cest: produto.cest || '',
        cfop: produto.cfop || '',
        origem: produto.origem || '',
        cst_icms: produto.cst_icms || '',
        aliquota_icms: produto.aliquota_icms || 0,
        cst_pis: produto.cst_pis || '',
        aliquota_pis: produto.aliquota_pis || 0,
        cst_cofins: produto.cst_cofins || '',
        aliquota_cofins: produto.aliquota_cofins || 0,
        cst_ipi: produto.cst_ipi || '',
        aliquota_ipi: produto.aliquota_ipi || 0
    };
}

function calcularTotalPrincipal() {
    const qtd = parseFloat($('#qtd_principal').val()) || 0;
    const preco = parseFloat($('#preco_principal').val()) || 0;
    const desconto = parseFloat($('#desconto_principal').val()) || 0;
    const total = (qtd * preco) - desconto;
    $('#total_principal').val(total.toFixed(2));
}

// ============================================
// GERENCIAMENTO DE ITENS
// ============================================
function adicionarItemNaTabela(itemData = null, isLoad = false) {
    let item;

    const usarLote = <?= $usarLoteCompra ? 'true' : 'false' ?>;

    if (itemData) {
        item = {
            item_id: itemData.item_id || itemData.product_id || '',
            item_name: itemData.item_name || itemData.product_name || '',
            item_code: itemData.item_code || itemData.product_sku || '',
            unit: itemData.unit || 'UN',
            quantity: itemData.quantity || 1,
            unit_price: itemData.unit_price || 0,
            discount: itemData.discount || 0,
            discount_type: 'fixed',
            total: itemData.total || itemData.total_price || 0,
            notes: itemData.notes || '',
            lote: itemData.lote || '',
            data_fabricacao: itemData.data_fabricacao || '',
            data_validade: itemData.data_validade || '',
            ncm: itemData.ncm || '',
            cest: itemData.cest || '',
            cfop: itemData.cfop || '',
            origem: itemData.origem || '',
            cst_icms: itemData.cst_icms || '',
            aliquota_icms: itemData.aliquota_icms || 0,
            cst_pis: itemData.cst_pis || '',
            aliquota_pis: itemData.aliquota_pis || 0,
            cst_cofins: itemData.cst_cofins || '',
            aliquota_cofins: itemData.aliquota_cofins || 0,
            cst_ipi: itemData.cst_ipi || '',
            aliquota_ipi: itemData.aliquota_ipi || 0
        };
    } else {
        item = {
            item_id: $('#produto_id_principal').val() || '',
            item_name: $('#item_search_principal').val() || '',
            item_code: selectedProduto?.code || '',
            unit: selectedProduto?.unit || 'UN',
            quantity: $('#qtd_principal').val() || 1,
            unit_price: $('#preco_principal').val() || 0,
            discount: $('#desconto_principal').val() || 0,
            discount_type: 'fixed',
            total: $('#total_principal').val() || 0,
            notes: $('#obs_principal').val() || '',
            lote: usarLote ? ($('#lote_principal').val() || '') : '',
            data_fabricacao: usarLote ? ($('#data_fabricacao_principal').val() || '') : '',
            data_validade: usarLote ? ($('#data_validade_principal').val() || '') : '',
            ncm: selectedProduto?.fiscal?.ncm || selectedProduto?.ncm || '',
            cest: selectedProduto?.fiscal?.cest || selectedProduto?.cest || '',
            cfop: selectedProduto?.fiscal?.cfop || selectedProduto?.cfop || '',
            origem: selectedProduto?.fiscal?.origem || selectedProduto?.origem || '',
            cst_icms: selectedProduto?.fiscal?.cst_icms || selectedProduto?.cst_icms || '',
            aliquota_icms: selectedProduto?.fiscal?.aliquota_icms || selectedProduto?.aliquota_icms || 0,
            cst_pis: selectedProduto?.fiscal?.cst_pis || selectedProduto?.cst_pis || '',
            aliquota_pis: selectedProduto?.fiscal?.aliquota_pis || selectedProduto?.aliquota_pis || 0,
            cst_cofins: selectedProduto?.fiscal?.cst_cofins || selectedProduto?.cst_cofins || '',
            aliquota_cofins: selectedProduto?.fiscal?.aliquota_cofins || selectedProduto?.aliquota_cofins || 0,
            cst_ipi: selectedProduto?.fiscal?.cst_ipi || selectedProduto?.cst_ipi || '',
            aliquota_ipi: selectedProduto?.fiscal?.aliquota_ipi || selectedProduto?.aliquota_ipi || 0
        };
    }

    if (!item.item_name) {
        if (!isLoad) {
            Swal.fire({ icon: 'warning', title: 'Atenção', text: 'Selecione um item!' });
            $('#item_search_principal').focus();
        }
        return;
    }

    const index = itensTabela.length;
    itensTabela.push(item);

    let loteCols = '';
    if (usarLote) {
        loteCols = `
            <td>${item.lote || '-'}</td>
            <td>${item.data_fabricacao ? formatarData(item.data_fabricacao) : '-'}</td>
            <td>${item.data_validade ? formatarData(item.data_validade) : '-'}</td>
        `;
    }

    const $row = $(`
        <tr data-index="${index}">
            <td>${item.item_name}</td>
            ${loteCols}
            <td class="text-center">${parseFloat(item.quantity).toFixed(3)}</td>
            <td class="text-end">R$ ${parseFloat(item.unit_price).toFixed(2)}</td>
            <td class="text-end">R$ ${parseFloat(item.discount).toFixed(2)}</td>
            <td class="text-end"><strong>R$ ${parseFloat(item.total).toFixed(2)}</strong></td>
            <td>${item.notes || '-'}</td>
            <td class="text-center">
                <div class="btn-group btn-group-sm">
                    <button type="button" class="btn btn-outline-primary" onclick="editarItemDaTabela(${index})"><i class="bi bi-pencil"></i></button>
                    <button type="button" class="btn btn-outline-danger" onclick="removerItemDaTabela(${index})"><i class="bi bi-trash"></i></button>
                </div>
            </td>
            <input type="hidden" name="itens[${index}][item_id]" value="${item.item_id}">
            <input type="hidden" name="itens[${index}][item_name]" value="${item.item_name}">
            <input type="hidden" name="itens[${index}][item_code]" value="${item.item_code}">
            <input type="hidden" name="itens[${index}][unit]" value="${item.unit}">
            <input type="hidden" name="itens[${index}][quantity]" value="${item.quantity}">
            <input type="hidden" name="itens[${index}][unit_price]" value="${item.unit_price}">
            <input type="hidden" name="itens[${index}][discount]" value="${item.discount}">
            <input type="hidden" name="itens[${index}][total]" value="${item.total}">
            <input type="hidden" name="itens[${index}][notes]" value="${item.notes}">
            ${usarLote ? `<input type="hidden" name="itens[${index}][lote]" value="${item.lote || ''}">` : ''}
            ${usarLote ? `<input type="hidden" name="itens[${index}][data_fabricacao]" value="${item.data_fabricacao || ''}">` : ''}
            ${usarLote ? `<input type="hidden" name="itens[${index}][data_validade]" value="${item.data_validade || ''}">` : ''}
            <input type="hidden" name="itens[${index}][ncm]" value="${item.ncm}">
            <input type="hidden" name="itens[${index}][cest]" value="${item.cest}">
            <input type="hidden" name="itens[${index}][cfop]" value="${item.cfop}">
            <input type="hidden" name="itens[${index}][origem]" value="${item.origem}">
            <input type="hidden" name="itens[${index}][cst_icms]" value="${item.cst_icms}">
            <input type="hidden" name="itens[${index}][aliquota_icms]" value="${item.aliquota_icms}">
            <input type="hidden" name="itens[${index}][cst_pis]" value="${item.cst_pis}">
            <input type="hidden" name="itens[${index}][aliquota_pis]" value="${item.aliquota_pis}">
            <input type="hidden" name="itens[${index}][cst_cofins]" value="${item.cst_cofins}">
            <input type="hidden" name="itens[${index}][aliquota_cofins]" value="${item.aliquota_cofins}">
            <input type="hidden" name="itens[${index}][cst_ipi]" value="${item.cst_ipi}">
            <input type="hidden" name="itens[${index}][aliquota_ipi]" value="${item.aliquota_ipi}">
        </tr>
    `);

    $('#tbody-itens').append($row);

    // Sincronizar com itensCompra
    itensCompra = [...itensTabela];

    if (!isLoad) {
        limparCamposItem();
        atualizarTotalGeral();
    }

    // Sempre mostrar tabela e esconder alerta quando há itens
    $('#alert-sem-itens').hide();
    $('#tabela-itens').show();
}

function removerItemDaTabela(index) {
    itensTabela.splice(index, 1);
    itensCompra = [...itensTabela]; // Sincronizar
    $(`#tbody-itens tr[data-index="${index}"]`).remove();

    $('#tbody-itens tr').each(function(i) {
        $(this).attr('data-index', i);
        $(this).find('button').eq(0).attr('onclick', `editarItemDaTabela(${i})`);
        $(this).find('button').eq(1).attr('onclick', `removerItemDaTabela(${i})`);
        $(this).find('input[type="hidden"]').each(function() {
            const name = $(this).attr('name').replace(/\[\d+\]/, `[${i}]`);
            $(this).attr('name', name);
        });
    });

    atualizarTotalGeral();

    if (itensTabela.length === 0) {
        $('#alert-sem-itens').show();
        $('#tabela-itens').hide();
    }

    itensCompra = [...itensTabela]; // Sincronizar após remover
}

function formatarData(data) {
    if (!data) return '-';
    const d = new Date(data + 'T00:00:00');
    return d.toLocaleDateString('pt-BR');
}

async function editarItemDaTabela(index) {
    const item = itensTabela[index];
    if (!item) return;

    const usarLote = <?= $usarLoteCompra ? 'true' : 'false' ?>;
    let loteFields = '';
    if (usarLote) {
        loteFields = `
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label fw-bold">Lote</label>
                    <input type="text" id="swal-lote" class="form-control" value="${item.lote || ''}">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label fw-bold">Data Fabricação</label>
                    <input type="date" id="swal-data-fabricacao" class="form-control" value="${item.data_fabricacao || ''}">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label fw-bold">Data Validade</label>
                    <input type="date" id="swal-data-validade" class="form-control" value="${item.data_validade || ''}">
                </div>
            </div>
        `;
    }

    const { value: formValues } = await Swal.fire({
        title: '<i class="bi bi-pencil-square me-2"></i>Alterar Item',
        html: `
            <div class="text-start">
                <div class="mb-3">
                    <label class="form-label fw-bold">Produto</label>
                    <input type="text" class="form-control" value="${item.item_name}" readonly>
                </div>
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label fw-bold">Quantidade</label>
                        <input type="number" id="swal-quantity" class="form-control" value="${parseFloat(item.quantity).toFixed(3)}" min="0.001" step="0.001" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label fw-bold">Preço Unit. (R$)</label>
                        <input type="number" id="swal-price" class="form-control" value="${parseFloat(item.unit_price).toFixed(2)}" min="0" step="0.01" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label fw-bold">Desconto (R$)</label>
                        <input type="number" id="swal-discount" class="form-control" value="${parseFloat(item.discount).toFixed(2)}" min="0" step="0.01">
                    </div>
                </div>
                ${loteFields}
                <div class="mb-3">
                    <label class="form-label fw-bold">Total</label>
                    <input type="text" id="swal-total" class="form-control fw-bold text-end" value="R$ ${parseFloat(item.total).toFixed(2)}" readonly>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">Observações</label>
                    <textarea id="swal-notes" class="form-control" rows="2">${item.notes || ''}</textarea>
                </div>
            </div>
        `,
        width: usarLote ? '700px' : '600px',
        showCancelButton: true,
        confirmButtonText: '<i class="bi bi-check-circle me-2"></i>Salvar',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#198754',
        didOpen: () => {
            const calcTotal = () => {
                const qtd = parseFloat($('#swal-quantity').val()) || 0;
                const preco = parseFloat($('#swal-price').val()) || 0;
                const desc = parseFloat($('#swal-discount').val()) || 0;
                const total = (qtd * preco) - desc;
                $('#swal-total').val('R$ ' + total.toFixed(2).replace('.', ','));
            };
            $('#swal-quantity, #swal-price, #swal-discount').on('input', calcTotal);
            setTimeout(() => $('#swal-quantity').focus().select(), 100);
        },
        preConfirm: () => {
            const quantity = parseFloat($('#swal-quantity').val());
            const price = parseFloat($('#swal-price').val());
            const discount = parseFloat($('#swal-discount').val()) || 0;
            if (!quantity || quantity <= 0) {
                Swal.showValidationMessage('Quantidade inválida');
                return false;
            }
            const total = (quantity * price) - discount;
            const result = { quantity, unit_price: price, discount, total, notes: $('#swal-notes').val() };
            if (usarLote) {
                result.lote = $('#swal-lote').val() || '';
                result.data_fabricacao = $('#swal-data-fabricacao').val() || '';
                result.data_validade = $('#swal-data-validade').val() || '';
            }
            return result;
        }
    });

    if (formValues) {
        itensTabela[index] = { ...item, ...formValues };
        const $row = $(`#tbody-itens tr[data-index="${index}"]`);
        let colOffset = usarLote ? 3 : 0;
        if (usarLote) {
            $row.find('td:eq(1)').text(formValues.lote || '-');
            $row.find('td:eq(2)').text(formValues.data_fabricacao ? formatarData(formValues.data_fabricacao) : '-');
            $row.find('td:eq(3)').text(formValues.data_validade ? formatarData(formValues.data_validade) : '-');
            $row.find('input[name*="[lote]"]').val(formValues.lote || '');
            $row.find('input[name*="[data_fabricacao]"]').val(formValues.data_fabricacao || '');
            $row.find('input[name*="[data_validade]"]').val(formValues.data_validade || '');
        }
        $row.find(`td:eq(${colOffset + 1})`).text(parseFloat(formValues.quantity).toFixed(3));
        $row.find(`td:eq(${colOffset + 2})`).text('R$ ' + parseFloat(formValues.unit_price).toFixed(2));
        $row.find(`td:eq(${colOffset + 3})`).text('R$ ' + parseFloat(formValues.discount).toFixed(2));
        $row.find(`td:eq(${colOffset + 4})`).html('<strong>R$ ' + parseFloat(formValues.total).toFixed(2) + '</strong>');
        $row.find(`td:eq(${colOffset + 5})`).text(formValues.notes || '-');
        $row.find('input[name*="[quantity]"]').val(formValues.quantity);
        $row.find('input[name*="[unit_price]"]').val(formValues.unit_price);
        $row.find('input[name*="[discount]"]').val(formValues.discount);
        $row.find('input[name*="[total]"]').val(formValues.total);
        $row.find('input[name*="[notes]"]').val(formValues.notes);
        atualizarTotalGeral();
    }
}

function limparCamposItem() {
    $('#item_search_principal').val('');
    $('#produto_id_principal').val('');
    $('#qtd_principal').val('1');
    $('#preco_principal').val('0');
    $('#desconto_principal').val('0');
    $('#total_principal').val('0');
    $('#obs_principal').val('');
    selectedProduto = null;
}

function atualizarTotalGeral() {
    const total = itensTabela.reduce((sum, item) => sum + parseFloat(item.total || 0), 0);
    $('#total-geral').text('R$ ' + total.toFixed(2).replace('.', ','));
    calcularTotalGeral();
}

function calcularTotalGeral() {
    const totalItens = itensTabela.reduce((sum, item) => sum + parseFloat(item.total || 0), 0);
    const totalDespesas = despesasTabela.reduce((sum, desp) => sum + parseFloat(desp.valor || 0), 0);
    const valorFrete = parseFloat($('#freight_value').val()) || 0;
    const subtotal = totalItens + totalDespesas + valorFrete;

    const descontoTipo = $('#discount_type').val();
    const descontoValor = parseFloat($('#discount').val()) || 0;
    let desconto = descontoTipo === 'percent' ? (subtotal * descontoValor) / 100 : descontoValor;

    const total = subtotal - desconto;

    $('#shipping').val(valorFrete.toFixed(2));
    $('#subtotal').val(subtotal.toFixed(2));
    $('#subtotal_display').val(subtotal.toFixed(2).replace('.', ','));
    $('#total').val(total.toFixed(2));
    $('#total_display').val(total.toFixed(2).replace('.', ','));
}

// ============================================
// DESPESAS
// ============================================
function adicionarDespesa() {
    const tipo = $('#despesa_tipo').val();
    const descricao = $('#despesa_descricao').val().trim();
    const valor = parseFloat($('#despesa_valor').val()) || 0;

    if (!tipo || !descricao || valor <= 0) {
        Swal.fire({ icon: 'warning', title: 'Atenção', text: 'Preencha todos os campos da despesa!' });
        return;
    }

    const despesa = { index: despesaIndex, tipo, descricao, valor };
    despesasTabela.push(despesa);

    const tipoTexto = $('#despesa_tipo option:selected').text();
    const $row = $(`
        <tr data-index="${despesaIndex}">
            <td>${tipoTexto}</td>
            <td>${descricao}</td>
            <td class="text-end"><strong>R$ ${valor.toFixed(2).replace('.', ',')}</strong></td>
            <td class="text-center">
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerDespesa(${despesaIndex})">
                    <i class="bi bi-trash"></i>
                </button>
            </td>
            <input type="hidden" name="despesas[${despesaIndex}][tipo]" value="${tipo}">
            <input type="hidden" name="despesas[${despesaIndex}][descricao]" value="${descricao}">
            <input type="hidden" name="despesas[${despesaIndex}][valor]" value="${valor}">
        </tr>
    `);

    $('#tbody-despesas').append($row);
    $('#alert-sem-despesas').hide();
    $('#tabela-despesas').show();
    despesaIndex++;
    $('#despesa_tipo, #despesa_descricao, #despesa_valor').val('');
    atualizarTotalDespesas();
}

function removerDespesa(index) {
    despesasTabela = despesasTabela.filter(d => d.index !== index);
    $(`#tbody-despesas tr[data-index="${index}"]`).remove();
    atualizarTotalDespesas();
    if (despesasTabela.length === 0) {
        $('#alert-sem-despesas').show();
        $('#tabela-despesas').hide();
    }
}

function atualizarTotalDespesas() {
    const total = despesasTabela.reduce((sum, d) => sum + parseFloat(d.valor || 0), 0);
    $('#total-despesas').text('R$ ' + total.toFixed(2).replace('.', ','));
    calcularTotalGeral();
}

// ============================================
// PRAZOS DE PAGAMENTO
// ============================================
function mostrarPrazosMetodoPagamento(metodoId) {
    const totalFinal = parseFloat($('#total').val()) || 0;
    if (totalFinal <= 0) {
        Swal.fire({ icon: 'warning', text: 'Adicione itens antes de selecionar pagamento!' });
        $('#payment_method_id').val('');
        return;
    }

    $.ajax({
        url: appUrl('/metodos-pagamento/buscar-prazos'),
        method: 'GET',
        data: { metodo_id: metodoId },
        success: function(response) {
            if (response.success && response.data.prazos && response.data.prazos.length > 0) {
                exibirModalPrazos(response.data.prazos, totalFinal);
            } else {
                $('#installments').val(1);
            }
        }
    });
}

function exibirModalPrazos(prazos, totalFinal) {
    let htmlPrazos = '<div class="list-group">';
    prazos.forEach(prazo => {
        const dias = parseInt(prazo.dias);
        const parcelas = Math.ceil(dias / 30);
        const valorParcela = Math.floor((totalFinal / parcelas) * 100) / 100;
        const valorUltima = totalFinal - (valorParcela * (parcelas - 1));

        let desc = parcelas === 1 ?
            `1x de <strong>R$ ${valorUltima.toFixed(2).replace('.', ',')}</strong>` :
            `${parcelas}x de <strong>R$ ${valorParcela.toFixed(2).replace('.', ',')}</strong>`;

        htmlPrazos += `
            <button type="button" class="list-group-item list-group-item-action" onclick="selecionarPrazo(${parcelas}, ${dias})">
                <h6 class="mb-1">${parcelas}x - ${dias} Dias</h6>
                <p class="mb-0 text-muted small">${desc}</p>
            </button>
        `;
    });
    htmlPrazos += '</div>';

    Swal.fire({
        title: '<i class="bi bi-credit-card me-2"></i> Selecione o Prazo de Pagamento',
        html: htmlPrazos,
        width: '650px',
        showConfirmButton: false,
        showCancelButton: true,
        cancelButtonText: 'Cancelar'
    });
}

function selecionarPrazo(parcelas, dias) {
    const totalFinal = parseFloat($('#total').val()) || 0;
    const valorParcela = Math.floor((totalFinal / parcelas) * 100) / 100;
    const valorUltima = totalFinal - (valorParcela * (parcelas - 1));

    let desc = parcelas === 1 ?
        `<strong>${parcelas}x de R$ ${valorUltima.toFixed(2).replace('.', ',')}</strong> (${dias} dias)` :
        `<strong>${parcelas}x de R$ ${valorParcela.toFixed(2).replace('.', ',')}</strong> (${dias} dias)`;

    $('#installments').val(parcelas);
    $('#parcelamento-detalhes').html(desc);
    $('#parcelamento-info').removeClass('d-none').slideDown();
    Swal.close();
}

// ============================================
// CENTRO DE CUSTOS
// ============================================
function atualizarTotalCompraDisplay() {
    const totalCompra = parseFloat($('#total').val()) || 0;
    $('#total-compra-display').text('R$ ' + totalCompra.toFixed(2).replace('.', ','));
    atualizarTotalCentroCustos();
}

function adicionarCentroCusto() {
    const centroId = $('#centro_custo_select').val();
    const valor = parseFloat($('#centro_custo_valor').val()) || 0;
    const totalCompra = parseFloat($('#total').val()) || 0;

    if (!centroId) {
        Swal.fire({ icon: 'warning', title: 'Atenção', text: 'Selecione um centro de custo!' });
        return;
    }

    if (valor <= 0) {
        Swal.fire({ icon: 'warning', title: 'Atenção', text: 'Informe um valor maior que zero!' });
        return;
    }

    const centroOption = $('#centro_custo_select option:selected');
    const centroCode = centroOption.data('code');
    const centroName = centroOption.text().split(' - ')[1] || centroOption.text();

    // Verificar se já existe
    const existe = centrosCustosTabela.find(c => c.centro_id == centroId);
    if (existe) {
        Swal.fire({ icon: 'warning', title: 'Atenção', text: 'Este centro de custo já foi adicionado!' });
        return;
    }

    const centro = {
        index: centroCustoIndex,
        centro_id: centroId,
        centro_code: centroCode,
        centro_name: centroName,
        valor: valor
    };

    centrosCustosTabela.push(centro);

    const totalDistribuido = centrosCustosTabela.reduce((sum, c) => sum + parseFloat(c.valor || 0), 0);
    const percentual = totalCompra > 0 ? ((valor / totalCompra) * 100).toFixed(2) : 0;

    const $row = $(`
        <tr data-index="${centroCustoIndex}">
            <td>${centroCode}</td>
            <td>${centroName}</td>
            <td class="text-end"><strong>R$ ${valor.toFixed(2).replace('.', ',')}</strong></td>
            <td class="text-end">${percentual}%</td>
            <td class="text-center">
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerCentroCusto(${centroCustoIndex})">
                    <i class="bi bi-trash"></i>
                </button>
            </td>
            <td style="display: none;">
                <input type="hidden" name="centro_custos[${centroCustoIndex}][centro_id]" value="${centroId}">
                <input type="hidden" name="centro_custos[${centroCustoIndex}][valor]" value="${valor}">
            </td>
        </tr>
    `);

    $('#tbody-centro-custos').append($row);
    $('#alert-sem-centro-custos').hide();
    $('#tabela-centro-custos').show();
    centroCustoIndex++;

    $('#centro_custo_select').val('');
    $('#centro_custo_valor').val('');
    atualizarTotalCentroCustos();
}

function removerCentroCusto(index) {
    centrosCustosTabela = centrosCustosTabela.filter(c => c.index !== index);
    $(`#tbody-centro-custos tr[data-index="${index}"]`).remove();

    // Reindexar
    let newIndex = 0;
    $('#tbody-centro-custos tr').each(function() {
        $(this).attr('data-index', newIndex);
        const centro = centrosCustosTabela[newIndex];
        if (centro) {
            centro.index = newIndex;
            $(this).find('button').attr('onclick', `removerCentroCusto(${newIndex})`);
            $(this).find('input[type="hidden"]').each(function() {
                const name = $(this).attr('name');
                if (name) {
                    const newName = name.replace(/centro_custos\[\d+\]/, `centro_custos[${newIndex}]`);
                    $(this).attr('name', newName);
                }
            });
        }
        newIndex++;
    });

    atualizarTotalCentroCustos();

    if (centrosCustosTabela.length === 0) {
        $('#alert-sem-centro-custos').show();
        $('#tabela-centro-custos').hide();
    }
}

function atualizarTotalCentroCustos() {
    const totalCompra = parseFloat($('#total').val()) || 0;
    const totalDistribuido = centrosCustosTabela.reduce((sum, c) => sum + parseFloat(c.valor || 0), 0);
    const totalRestante = totalCompra - totalDistribuido;
    const totalPercentual = totalCompra > 0 ? ((totalDistribuido / totalCompra) * 100).toFixed(2) : 0;

    $('#total-distribuido-display').text('R$ ' + totalDistribuido.toFixed(2).replace('.', ','));
    $('#total-restante-display').text('R$ ' + totalRestante.toFixed(2).replace('.', ','));
    $('#total-centro-custos').text('R$ ' + totalDistribuido.toFixed(2).replace('.', ','));
    $('#total-percentual').text(totalPercentual + '%');

    // Atualizar percentuais individuais
    $('#tbody-centro-custos tr').each(function() {
        const valor = parseFloat($(this).find('input[name*="[valor]"]').val()) || 0;
        const percentual = totalCompra > 0 ? ((valor / totalCompra) * 100).toFixed(2) : 0;
        $(this).find('td:eq(3)').text(percentual + '%');
    });

    // Avisar se não está 100% distribuído
    if (Math.abs(totalRestante) > 0.01) {
        $('#total-restante-display').removeClass('text-success').addClass('text-warning');
    } else {
        $('#total-restante-display').removeClass('text-warning').addClass('text-success');
    }
}

// Carregar centros de custos existentes (se edição)
<?php if ($isEdit && !empty($compra['centros_custos'])): ?>
<?php foreach ($compra['centros_custos'] as $cc): ?>
centrosCustosTabela.push({
    index: centroCustoIndex,
    centro_id: <?= $cc['centro_id'] ?>,
    centro_code: '<?= htmlspecialchars($cc['code'] ?? '') ?>',
    centro_name: '<?= htmlspecialchars($cc['name'] ?? '') ?>',
    valor: <?= $cc['valor'] ?? 0 ?>
});
centroCustoIndex++;
<?php endforeach; ?>
// Renderizar tabela
centrosCustosTabela.forEach(function(cc) {
    const percentual = parseFloat($('#total').val()) > 0 ? ((cc.valor / parseFloat($('#total').val())) * 100).toFixed(2) : 0;
    const $row = $(`
        <tr data-index="${cc.index}">
            <td>${cc.centro_code}</td>
            <td>${cc.centro_name}</td>
            <td class="text-end"><strong>R$ ${parseFloat(cc.valor).toFixed(2).replace('.', ',')}</strong></td>
            <td class="text-end">${percentual}%</td>
            <td class="text-center">
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerCentroCusto(${cc.index})">
                    <i class="bi bi-trash"></i>
                </button>
            </td>
            <td style="display: none;">
                <input type="hidden" name="centro_custos[${cc.index}][centro_id]" value="${cc.centro_id}">
                <input type="hidden" name="centro_custos[${cc.index}][valor]" value="${cc.valor}">
            </td>
        </tr>
    `);
    $('#tbody-centro-custos').append($row);
});
$('#alert-sem-centro-custos').hide();
$('#tabela-centro-custos').show();
atualizarTotalCentroCustos();
<?php endif; ?>
</script>
