<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-building me-2"></i> Centro de Custos</h2>
        <p class="text-muted">Gerencie os centros de custos da empresa</p>
    </div>
    <div class="col-md-6 text-end">
        <button type="button" class="btn btn-outline-info me-2" onclick="abrirTutorialCentroCustos()"
            title="Tutorial do Módulo">
            <i class="bi bi-question-circle me-2"></i> Tutorial
        </button>
        <a href="<?= url('/centro-custos/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Novo Centro de Custo
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Nome</th>
                        <th>Centro Pai</th>
                        <th>Status</th>
                        <th width="150">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($centros)): ?>
                        <tr>
                            <td colspan="5" class="text-center text-muted py-4">
                                <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                Nenhum centro de custo cadastrado
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($centros as $centro): ?>
                            <tr>
                                <td><strong><?= htmlspecialchars($centro['code']) ?></strong></td>
                                <td><?= htmlspecialchars($centro['name']) ?></td>
                                <td>
                                    <?php if ($centro['parent_name']): ?>
                                        <small class="text-muted"><?= htmlspecialchars($centro['parent_name']) ?></small>
                                    <?php else: ?>
                                        <small class="text-muted">-</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($centro['is_active']): ?>
                                        <span class="badge bg-success">Ativo</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inativo</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?= url('/centro-custos/editar?id=' . $centro['id']) ?>" class="btn btn-sm btn-outline-primary" title="Editar">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <button class="btn btn-sm btn-outline-danger" onclick="excluirCentro(<?= $centro['id'] ?>, '<?= addslashes($centro['name']) ?>')" title="Excluir">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if (!empty($centros) && isset($totalPages) && $totalPages > 1): ?>
            <div class="d-flex justify-content-between align-items-center p-3 border-top">
                <div class="text-muted">
                    Mostrando <?= (($page ?? 1) - 1) * ($perPage ?? 50) + 1 ?> a <?= min(($page ?? 1) * ($perPage ?? 50), $total ?? 0) ?> de <?= $total ?? 0 ?> centros
                </div>
                <nav>
                    <ul class="pagination pagination-sm mb-0">
                        <li class="page-item <?= ($page ?? 1) <= 1 ? 'disabled' : '' ?>">
                            <a class="page-link" href="?page=<?= max(1, ($page ?? 1) - 1) ?>" aria-label="Anterior">
                                <span aria-hidden="true">&laquo;</span>
                            </a>
                        </li>
                        <?php for ($i = max(1, ($page ?? 1) - 2); $i <= min($totalPages, ($page ?? 1) + 2); $i++): ?>
                            <li class="page-item <?= ($i === ($page ?? 1)) ? 'active' : '' ?>">
                                <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                            </li>
                        <?php endfor; ?>
                        <li class="page-item <?= ($page ?? 1) >= $totalPages ? 'disabled' : '' ?>">
                            <a class="page-link" href="?page=<?= min($totalPages, ($page ?? 1) + 1) ?>" aria-label="Próximo">
                                <span aria-hidden="true">&raquo;</span>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
        <?php elseif (!empty($centros) && isset($total) && $total > 0): ?>
            <div class="text-center p-3 border-top">
                <small class="text-muted">Mostrando todos os <?= $total ?> centro(s)</small>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
function excluirCentro(id, nome) {
    Swal.fire({
        title: 'Excluir Centro de Custo?',
        text: `Deseja realmente excluir "${nome}"?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sim, excluir',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#dc3545'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: appUrl('/centro-custos/deletar'),
                type: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Toast.success(response.message);
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        Toast.error(response.message);
                    }
                },
                error: function() {
                    Toast.error('Erro ao excluir centro de custo');
                }
            });
        }
    });
}

// Função para abrir tutorial do módulo de Centro de Custos
function abrirTutorialCentroCustos() {
    Swal.fire({
        title: '<i class="bi bi-building text-primary"></i> Tutorial Completo: Centro de Custos',
        html: `
            <div class="text-start" style="max-height: 70vh; overflow-y: auto;">
                <div class="mb-4">
                    <h5 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Visão Geral</h5>
                    <p class="text-muted">O módulo de Centro de Custos permite criar uma estrutura hierárquica para rastrear e controlar os custos da empresa por departamento, projeto, unidade ou qualquer outra divisão organizacional.</p>
                </div>

                <div class="accordion" id="tutorialAccordionCentroCustos">
                    <!-- O QUE SÃO CENTROS DE CUSTOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#oQueSaoCentrosCustos">
                                <i class="bi bi-question-circle me-2"></i> <strong>1. O que são Centros de Custos?</strong>
                            </button>
                        </h2>
                        <div id="oQueSaoCentrosCustos" class="accordion-collapse collapse show" data-bs-parent="#tutorialAccordionCentroCustos">
                            <div class="accordion-body">
                                <p class="mb-3">Centros de Custos são divisões organizacionais que permitem rastrear e controlar os custos da empresa. Eles permitem:</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Rastrear Custos:</strong> Identificar onde os custos estão sendo gerados</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Controlar Despesas:</strong> Controlar despesas por departamento, projeto ou unidade</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Relatórios:</strong> Gerar relatórios de custos por centro</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Orçamento:</strong> Planejar e controlar orçamentos por centro</li>
                                </ul>
                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Você pode criar centros de custos como "Vendas", "Produção", "Administração" e depois rastrear todas as despesas de cada um.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ESTRUTURA HIERÁRQUICA -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#estruturaHierarquica">
                                <i class="bi bi-diagram-3 me-2"></i> <strong>2. Estrutura Hierárquica</strong>
                            </button>
                        </h2>
                        <div id="estruturaHierarquica" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionCentroCustos">
                            <div class="accordion-body">
                                <p class="mb-3">O Centro de Custos usa uma estrutura hierárquica com centros pai e filhos:</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-folder me-2"></i>Centros Raiz (Pai)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Centros Principais:</strong> Centros de nível superior que não têm centro pai
                                        <br><small class="text-muted">Exemplo: "Vendas", "Produção", "Administração"</small>
                                    </li>
                                    <li><strong>Função:</strong> Agrupar centros relacionados</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-folder2 me-2"></i>Centros Filhos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Subcentros:</strong> Centros detalhados dentro de um centro principal
                                        <br><small class="text-muted">Exemplo: "Vendas" pode ter "Vendas Online" e "Vendas Presenciais"</small>
                                    </li>
                                    <li><strong>Hierarquia:</strong> Podem ter múltiplos níveis (pai, filho, neto, etc.)</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-123 me-2"></i>Código</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Código:</strong> Identificador único do centro de custo
                                        <br><small class="text-muted">Pode ser numérico, alfanumérico ou seguir um padrão</small>
                                        <br><small class="text-info">Exemplos: "001", "VENDA", "PROD-01"</small>
                                    </li>
                                </ul>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo de Estrutura:</strong>
                                        <br>• VENDAS (código: VENDA)
                                        <br>&nbsp;&nbsp;  - Vendas Online (código: VENDA-ON)
                                        <br>&nbsp;&nbsp;  - Vendas Presenciais (código: VENDA-PRE)
                                        <br>• PRODUÇÃO (código: PROD)
                                        <br>&nbsp;&nbsp;  - Linha 1 (código: PROD-L1)
                                        <br>&nbsp;&nbsp;  - Linha 2 (código: PROD-L2)
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CAMPOS DO FORMULÁRIO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#camposFormulario">
                                <i class="bi bi-card-text me-2"></i> <strong>3. Campos do Formulário</strong>
                            </button>
                        </h2>
                        <div id="camposFormulario" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionCentroCustos">
                            <div class="accordion-body">
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Código *:</strong> Identificador único do centro de custo
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-muted">Pode ser numérico, alfanumérico ou seguir um padrão</small>
                                        <br><small class="text-info">Exemplos: "001", "VENDA", "PROD-01", "ADM-001"</small>
                                    </li>
                                    <li><strong>Nome *:</strong> Nome que identifica o centro de custo
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-muted">Exemplos: "Vendas", "Produção", "Administração", "Marketing"</small>
                                    </li>
                                    <li><strong>Centro de Custo Pai:</strong> Selecione o centro pai (se houver)
                                        <br><small class="text-muted">Opcional, deixe vazio para criar um centro raiz</small>
                                        <br><small class="text-info">Selecione um centro existente para criar um subcentro</small>
                                    </li>
                                    <li><strong>Status:</strong> Marque "Ativo" para manter o centro ativo
                                        <br><small class="text-muted">Centros inativos não aparecem em seleções</small>
                                        <br><small class="text-info">Use "Inativo" para desativar temporariamente sem excluir</small>
                                    </li>
                                    <li><strong>Observações:</strong> Campo de texto livre para informações adicionais
                                        <br><small class="text-muted">Opcional, use para documentar o centro de custo</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- COMO USAR -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#comoUsar">
                                <i class="bi bi-play-circle me-2"></i> <strong>4. Como Usar</strong>
                            </button>
                        </h2>
                        <div id="comoUsar" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionCentroCustos">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-plus-circle me-2"></i>Criando um Centro de Custo</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Clique em "Novo Centro de Custo"</li>
                                    <li>Digite o <strong>Código</strong> (ex: "001", "VENDA")</li>
                                    <li>Digite o <strong>Nome</strong> do centro (ex: "Vendas")</li>
                                    <li>Selecione o <strong>Centro Pai</strong> (opcional, deixe vazio para centro raiz)</li>
                                    <li>Marque "Ativo" (recomendado)</li>
                                    <li>Adicione <strong>Observações</strong> (opcional)</li>
                                    <li>Clique em "Salvar"</li>
                                </ol>

                                <h6 class="text-primary mb-3"><i class="bi bi-pencil me-2"></i>Editando um Centro de Custo</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Na lista de centros, clique no ícone de editar (lápis)</li>
                                    <li>Modifique os campos desejados</li>
                                    <li><strong>Nota:</strong> Cuidado ao alterar o centro pai, pois pode afetar a hierarquia</li>
                                    <li>Clique em "Salvar"</li>
                                </ol>

                                <h6 class="text-warning mb-3"><i class="bi bi-x-circle me-2"></i>Desativando um Centro de Custo</h6>
                                <p class="ms-3 mb-3">Para desativar um centro sem excluir:</p>
                                <ol class="ms-3 mb-3">
                                    <li>Edite o centro</li>
                                    <li>Desmarque "Ativo"</li>
                                    <li>Salve as alterações</li>
                                    <li>O centro não aparecerá mais em seleções, mas os dados permanecem</li>
                                </ol>

                                <h6 class="text-danger mb-3"><i class="bi bi-trash me-2"></i>Excluindo um Centro de Custo</h6>
                                <div class="alert alert-warning ms-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Atenção:</strong> Você não pode excluir um centro de custo que tenha:
                                        <br>• Centros filhos (subcentros)
                                        <br>• Movimentações financeiras associadas
                                        <br>• Compras associadas
                                        <br>Use a desativação quando possível.</small>
                                </div>

                                <h6 class="text-info mb-3"><i class="bi bi-diagram-3 me-2"></i>Criando Estrutura Hierárquica</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Primeiro, crie os centros raiz (sem centro pai)</li>
                                    <li>Depois, crie os subcentros selecionando o centro pai</li>
                                    <li>Use códigos que sigam uma lógica organizacional</li>
                                    <li>Mantenha a estrutura organizada e lógica</li>
                                </ol>
                            </div>
                        </div>
                    </div>

                    <!-- BOAS PRÁTICAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#boasPraticas">
                                <i class="bi bi-lightbulb me-2"></i> <strong>5. Boas Práticas</strong>
                            </button>
                        </h2>
                        <div id="boasPraticas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionCentroCustos">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-check-circle me-2"></i>Nomenclatura</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Use nomes claros e descritivos</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Reflita a estrutura organizacional da empresa</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Mantenha consistência na nomenclatura</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-123 me-2"></i>Códigos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Use códigos que facilitem a identificação</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Mantenha um padrão consistente</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Exemplo: "VENDA", "PROD", "ADM" ou "001", "002", "003"</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-diagram-3 me-2"></i>Hierarquia</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Não crie muitos níveis desnecessários</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Mantenha a estrutura organizada e lógica</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Reflita a estrutura real da empresa</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-shield-check me-2"></i>Manutenção</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Revise periodicamente a estrutura</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Desative centros não utilizados em vez de excluir</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Mantenha o plano organizado e atualizado</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- EXEMPLOS PRÁTICOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#exemplos">
                                <i class="bi bi-book me-2"></i> <strong>6. Exemplos Práticos</strong>
                            </button>
                        </h2>
                        <div id="exemplos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionCentroCustos">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-shop me-2"></i>Estrutura por Departamento</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>VENDAS</strong> (código: VENDA)
                                        <br><small class="text-muted ms-3">• Vendas Online (código: VENDA-ON)</small>
                                        <br><small class="text-muted ms-3">• Vendas Presenciais (código: VENDA-PRE)</small>
                                    </li>
                                    <li><strong>PRODUÇÃO</strong> (código: PROD)
                                        <br><small class="text-muted ms-3">• Linha 1 (código: PROD-L1)</small>
                                        <br><small class="text-muted ms-3">• Linha 2 (código: PROD-L2)</small>
                                    </li>
                                    <li><strong>ADMINISTRAÇÃO</strong> (código: ADM)
                                        <br><small class="text-muted ms-3">• Recursos Humanos (código: ADM-RH)</small>
                                        <br><small class="text-muted ms-3">• Financeiro (código: ADM-FIN)</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-briefcase me-2"></i>Estrutura por Projeto</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>PROJETO A</strong> (código: PROJ-A)
                                        <br><small class="text-muted ms-3">• Desenvolvimento (código: PROJ-A-DEV)</small>
                                        <br><small class="text-muted ms-3">• Marketing (código: PROJ-A-MKT)</small>
                                    </li>
                                    <li><strong>PROJETO B</strong> (código: PROJ-B)
                                        <br><small class="text-muted ms-3">• Desenvolvimento (código: PROJ-B-DEV)</small>
                                        <br><small class="text-muted ms-3">• Marketing (código: PROJ-B-MKT)</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i>Estrutura por Unidade/Filial</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>FILIAL SP</strong> (código: FIL-SP)
                                        <br><small class="text-muted ms-3">• Vendas SP (código: FIL-SP-VEN)</small>
                                        <br><small class="text-muted ms-3">• Produção SP (código: FIL-SP-PROD)</small>
                                    </li>
                                    <li><strong>FILIAL RJ</strong> (código: FIL-RJ)
                                        <br><small class="text-muted ms-3">• Vendas RJ (código: FIL-RJ-VEN)</small>
                                        <br><small class="text-muted ms-3">• Produção RJ (código: FIL-RJ-PROD)</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- USO EM MOVIMENTAÇÕES -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#usoMovimentacoes">
                                <i class="bi bi-arrow-left-right me-2"></i> <strong>7. Uso em Movimentações</strong>
                            </button>
                        </h2>
                        <div id="usoMovimentacoes" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionCentroCustos">
                            <div class="accordion-body">
                                <p class="mb-3">Os Centros de Custos são utilizados em várias movimentações do sistema:</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-cash-coin me-2"></i>Contas a Pagar</h6>
                                <p class="ms-3 mb-3">Ao criar uma conta a pagar, você pode associar a um centro de custo para rastrear onde a despesa está sendo gerada.</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-cart me-2"></i>Compras</h6>
                                <p class="ms-3 mb-3">Ao registrar uma compra, você pode associar a um centro de custo para controlar os custos por departamento/projeto.</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-graph-up me-2"></i>Relatórios</h6>
                                <p class="ms-3 mb-3">Os relatórios financeiros podem ser filtrados e segmentados por centro de custo, permitindo análise detalhada dos custos.</p>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Dica:</strong> Use centros de custos consistentemente em todas as movimentações para ter relatórios precisos e detalhados.</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="alert alert-success mt-4">
                    <i class="bi bi-check-circle me-2"></i>
                    <strong>Pronto para começar!</strong> Agora você conhece todos os recursos do módulo de Centro de Custos e pode criar uma estrutura organizacional para rastrear e controlar os custos da empresa.
                </div>
            </div>
        `,
        width: '90%',
        heightAuto: false,
        confirmButtonText: 'Entendi, obrigado!',
        confirmButtonColor: '#0d6efd',
        icon: null,
        customClass: {
            popup: 'tutorial-popup',
            container: 'tutorial-container'
        }
    });
}
</script>

<style>
/* Estilos para o Tutorial */
.tutorial-container {
    max-height: 90vh !important;
}

.tutorial-popup {
    max-width: 90vw !important;
    max-height: 90vh !important;
    width: 90% !important;
}

.tutorial-popup .swal2-html-container {
    padding: 0;
    max-height: calc(90vh - 150px);
    overflow-y: auto;
}

.tutorial-popup .accordion-button {
    font-size: 0.95rem;
    font-weight: 600;
    padding: 0.75rem 1rem;
    background-color: #f8f9fa;
    border: 1px solid #dee2e6;
}

.tutorial-popup .accordion-button:not(.collapsed) {
    background-color: #e7f3ff;
    color: #0d6efd;
    border-color: #0d6efd;
}

.tutorial-popup .accordion-button:focus {
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.tutorial-popup .accordion-body {
    padding: 1.25rem;
    background-color: #ffffff;
    border-left: 3px solid #0d6efd;
}

.tutorial-popup .accordion-item {
    border: 1px solid #dee2e6;
    border-radius: 8px;
    overflow: hidden;
    margin-bottom: 0.5rem;
}

.tutorial-popup .list-unstyled li {
    padding: 0.25rem 0;
    line-height: 1.6;
}

.tutorial-popup .alert {
    margin-top: 1rem;
    border-left: 4px solid;
}

.tutorial-popup .text-muted {
    font-size: 0.875rem;
}

.tutorial-popup .text-info {
    color: #0dcaf0 !important;
}

.tutorial-popup .text-success {
    color: #198754 !important;
}

.tutorial-popup .text-warning {
    color: #ffc107 !important;
}

.tutorial-popup .text-primary {
    color: #0d6efd !important;
}
</style>

<?php
$content = ob_get_clean();
include ROOT_PATH . '/views/layouts/app.php';
?>

