<div class="row">
    <div class="col-md-6 mb-3">
        <label class="form-label">Código *</label>
        <input type="text" class="form-control" name="code" value="<?= htmlspecialchars($centro['code'] ?? '') ?>" required>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label">Nome *</label>
        <input type="text" class="form-control" name="name" value="<?= htmlspecialchars($centro['name'] ?? '') ?>" required>
    </div>
</div>

<div class="row">
    <div class="col-md-6 mb-3">
        <label class="form-label">Centro de Custo Pai</label>
        <select class="form-select" name="parent_id">
            <option value="">Nenhum (Nível Superior)</option>
            <?php foreach ($centros as $c): ?>
                <option value="<?= $c['id'] ?>" <?= isset($centro) && $centro['parent_id'] == $c['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($c['code']) ?> - <?= htmlspecialchars($c['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>
        <small class="text-muted">Deixe vazio se este for um centro de custo principal</small>
    </div>

    <div class="col-md-6 mb-3">
        <label class="form-label">Status</label>
        <div class="form-check form-switch mt-2">
            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" <?= !isset($centro) || $centro['is_active'] ? 'checked' : '' ?>>
            <label class="form-check-label" for="is_active">
                <i class="bi bi-check-circle text-success"></i> Ativo
            </label>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12 mb-3">
        <label class="form-label">Observações</label>
        <textarea class="form-control" name="notes" rows="3"><?= htmlspecialchars($centro['notes'] ?? '') ?></textarea>
    </div>
</div>

