<?php
$isEdit = isset($categoria['id']);
?>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-tags me-2"></i> Dados da Categoria
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="name" class="form-label">Nome da Categoria *</label>
                        <input type="text" class="form-control" id="name" name="name"
                            value="<?= htmlspecialchars($categoria['name'] ?? '') ?>" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="type" class="form-label">Tipo *</label>
                        <select class="form-select" id="type" name="type" required>
                            <option value="">Selecione...</option>
                            <option value="produtos" <?= ($categoria['type'] ?? '') === 'produtos' ? 'selected' : '' ?>>Produtos</option>
                            <option value="servicos" <?= ($categoria['type'] ?? '') === 'servicos' ? 'selected' : '' ?>>Serviços</option>
                            <option value="ambos" <?= ($categoria['type'] ?? '') === 'ambos' ? 'selected' : '' ?>>Ambos</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="parent_id" class="form-label">Categoria Pai</label>
                        <select class="form-select" id="parent_id" name="parent_id">
                            <option value="">Nenhuma (categoria principal)</option>
                            <?php if (!empty($categorias)): ?>
                                <?php foreach ($categorias as $cat): ?>
                                    <?php if (!isset($categoria['id']) || $cat['id'] != $categoria['id']): ?>
                                        <option value="<?= $cat['id'] ?>"
                                            <?= ($categoria['parent_id'] ?? '') == $cat['id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($cat['name']) ?>
                                        </option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="sort_order" class="form-label">Ordem de Exibição</label>
                        <input type="number" class="form-control" id="sort_order" name="sort_order"
                            min="0" placeholder="0"
                            value="<?= $categoria['sort_order'] ?? '0' ?>">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="icon" class="form-label">Ícone</label>
                        <input type="text" class="form-control" id="icon" name="icon"
                            placeholder="bi bi-tag"
                            value="<?= htmlspecialchars($categoria['icon'] ?? '') ?>">
                        <small class="text-muted">Classe do Bootstrap Icons</small>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="color" class="form-label">Cor</label>
                        <input type="color" class="form-control form-control-color" id="color" name="color"
                            value="<?= $categoria['color'] ?? '#007bff' ?>">
                    </div>
                    <div class="col-md-12 mb-3">
                        <label for="description" class="form-label">Descrição</label>
                        <textarea class="form-control" id="description" name="description" rows="3"
                            placeholder="Descrição da categoria..."><?= htmlspecialchars($categoria['description'] ?? '') ?></textarea>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                                <?= ($categoria['is_active'] ?? 1) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="is_active">
                                <i class="bi bi-toggle-on me-1"></i> Categoria Ativa
                            </label>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="requires_serial" name="requires_serial" value="1"
                                <?= ($categoria['requires_serial'] ?? 0) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="requires_serial">
                                <i class="bi bi-hash me-1"></i> Exige Número de Série
                            </label>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="requires_warranty" name="requires_warranty" value="1"
                                <?= ($categoria['requires_warranty'] ?? 0) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="requires_warranty">
                                <i class="bi bi-shield-check me-1"></i> Exige Garantia
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="taxable" name="taxable" value="1"
                                <?= ($categoria['taxable'] ?? 1) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="taxable">
                                <i class="bi bi-percent me-1"></i> Sujeita a Impostos
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <!-- Informações -->
        <div class="card">
            <div class="card-header">
                <i class="bi bi-info-circle me-2"></i> Informações
            </div>
            <div class="card-body">
                <p class="small text-muted mb-2">
                    <i class="bi bi-asterisk text-danger"></i> Campos obrigatórios
                </p>
                <?php if ($isEdit): ?>
                <p class="small text-muted">
                    <strong>Criado em:</strong><br>
                    <?= date('d/m/Y H:i', strtotime($categoria['created_at'])) ?>
                </p>
                <p class="small text-muted">
                    <strong>Atualizado em:</strong><br>
                    <?= date('d/m/Y H:i', strtotime($categoria['updated_at'])) ?>
                </p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Dicas -->
        <div class="card">
            <div class="card-header">
                <i class="bi bi-lightbulb me-2"></i> Dicas
            </div>
            <div class="card-body">
                <div class="alert alert-light">
                    <i class="bi bi-info-circle me-2"></i>
                    <strong>Organize suas categorias:</strong> Use categorias pai e filho para criar uma hierarquia lógica.
                </div>
                <div class="alert alert-light">
                    <i class="bi bi-palette me-2"></i>
                    <strong>Personalize:</strong> Escolha ícones e cores para identificar rapidamente suas categorias.
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($isEdit): ?>
<input type="hidden" name="id" value="<?= $categoria['id'] ?>">
<?php endif; ?>