<?php
$activeMenu = 'categorias';
include ROOT_PATH . '/views/layouts/app.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?= url('/categorias') ?>">Categorias</a></li>
                        <li class="breadcrumb-item active">Nova Categoria</li>
                    </ol>
                </div>
                <h4 class="page-title">
                    <i class="bi bi-plus-circle me-2"></i> Nova Categoria
                </h4>
            </div>
        </div>
    </div>

    <form id="categoriaForm" method="POST" action="<?= url('/categorias/criar') ?>">
        <?php include ROOT_PATH . '/views/categorias/form.php'; ?>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-lg me-2"></i> Salvar Categoria
                        </button>
                        <a href="<?= url('/categorias') ?>" class="btn btn-secondary">
                            <i class="bi bi-arrow-left me-2"></i> Voltar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    $('#categoriaForm').on('submit', function(e) {
        e.preventDefault();

        const formData = $(this).serialize();

        $.ajax({
            url: appUrl('/categorias/criar'),
            type: 'POST',
            data: formData,
            beforeSend: function() {
                LoadingOverlay.show();
            },
            success: function(response) {
                LoadingOverlay.hide();

                if (response.success) {
                    Swal.fire({
                        title: 'Sucesso!',
                        text: response.message,
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        window.location.href = response.data.redirect;
                    });
                } else {
                    Swal.fire({
                        title: 'Erro!',
                        text: response.message,
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                }
            },
            error: function() {
                LoadingOverlay.hide();
                Swal.fire({
                    title: 'Erro!',
                    text: 'Erro ao salvar categoria',
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
});
</script>
