<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-star me-2"></i> Assinatura</h2>
        <p class="text-muted">Informações do seu plano de assinatura</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/assinatura/upgrade') ?>" class="btn btn-primary">
            <i class="bi bi-arrow-up-circle me-2"></i> Fazer Upgrade
        </a>
    </div>
</div>

<!-- Informações da Assinatura -->
<div class="row mb-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-info-circle me-2"></i> Informações do Plano</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Plano Atual</h6>
                        <p class="h4 text-primary"><?= htmlspecialchars($assinatura['plan'] ?? 'Básico') ?></p>
                    </div>
                    <div class="col-md-6">
                        <h6>Status</h6>
                        <p>
                            <span
                                class="badge bg-success fs-6"><?= htmlspecialchars($assinatura['status'] ?? 'Ativa') ?></span>
                        </p>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <h6>Vencimento</h6>
                        <p><?= date('d/m/Y', strtotime($assinatura['expires_at'] ?? '+30 days')) ?></p>
                    </div>
                    <div class="col-md-6">
                        <h6>Usuários</h6>
                        <p><?= $assinatura['users_limit'] ?? 5 ?> usuários</p>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-12">
                        <h6>Armazenamento</h6>
                        <p><?= $assinatura['storage_limit'] ?? '10GB' ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-lightning me-2"></i> Ações Rápidas</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="<?= url('/assinatura/upgrade') ?>" class="btn btn-primary">
                        <i class="bi bi-arrow-up-circle me-2"></i> Fazer Upgrade
                    </a>
                    <a href="<?= url('/assinatura/invoices') ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-receipt me-2"></i> Ver Faturas
                    </a>
                    <button class="btn btn-outline-info" onclick="contatarSuporte()">
                        <i class="bi bi-headset me-2"></i> Contatar Suporte
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recursos do Plano -->
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-list-check me-2"></i> Recursos Incluídos</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php if (!empty($assinatura['features'])): ?>
                        <?php foreach ($assinatura['features'] as $feature): ?>
                            <div class="col-md-6 mb-2">
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                                    <span><?= htmlspecialchars($feature) ?></span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="col-md-6 mb-2">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-check-circle-fill text-success me-2"></i>
                                <span>Gestão de Pessoas</span>
                            </div>
                        </div>
                        <div class="col-md-6 mb-2">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-check-circle-fill text-success me-2"></i>
                                <span>Controle de Estoque</span>
                            </div>
                        </div>
                        <div class="col-md-6 mb-2">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-check-circle-fill text-success me-2"></i>
                                <span>Relatórios Básicos</span>
                            </div>
                        </div>
                        <div class="col-md-6 mb-2">
                            <div class="d-flex align-items-center">
                                <i class="bi bi-check-circle-fill text-success me-2"></i>
                                <span>Suporte por Email</span>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function contatarSuporte() {
        Swal.fire({
            title: 'Contatar Suporte',
            html: `
            <p>Entre em contato conosco:</p>
            <ul class="text-start">
                <li><strong>Email:</strong> suporte@Systhema.com</li>
                <li><strong>Telefone:</strong> (11) 9999-9999</li>
                <li><strong>Horário:</strong> Segunda a Sexta, 8h às 18h</li>
            </ul>
        `,
            icon: 'info',
            confirmButtonText: 'OK'
        });
    }
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'assinatura';
include ROOT_PATH . '/views/layouts/app.php';
?>