<?php
ob_start();

// Separa arquivos por tipo
$arquivosNFe = array_filter($arquivos, fn($a) => $a['tipo_documento'] === 'NFe');
$arquivosNFCe = array_filter($arquivos, fn($a) => $a['tipo_documento'] === 'NFCe');
$arquivosNFSe = array_filter($arquivos, fn($a) => $a['tipo_documento'] === 'NFSe');
$arquivosMDFe = array_filter($arquivos, fn($a) => $a['tipo_documento'] === 'MDFe');

// Array de meses para uso em todos os formulários
$meses = ['01' => 'Janeiro', '02' => 'Fevereiro', '03' => 'Março', '04' => 'Abril',
          '05' => 'Maio', '06' => 'Junho', '07' => 'Julho', '08' => 'Agosto',
          '09' => 'Setembro', '10' => 'Outubro', '11' => 'Novembro', '12' => 'Dezembro'];
?>

<div class="row mb-4">
    <div class="col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Arquivos Fiscais</li>
            </ol>
        </nav>
        <h2><i class="bi bi-file-earmark-text me-2"></i> Arquivos Fiscais</h2>
    </div>
</div>

<!-- Navegação por Abas -->
<ul class="nav nav-tabs mb-3" role="tablist">
    <li class="nav-item">
        <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#nfe" type="button">
            <i class="bi bi-file-earmark-text me-1"></i> NF-e <span class="badge bg-primary ms-1"><?= count($arquivosNFe) ?></span>
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#nfce" type="button">
            <i class="bi bi-receipt me-1"></i> NFC-e <span class="badge bg-primary ms-1"><?= count($arquivosNFCe) ?></span>
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#nfse" type="button">
            <i class="bi bi-file-text me-1"></i> NFS-e <span class="badge bg-primary ms-1"><?= count($arquivosNFSe) ?></span>
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#mdfe" type="button">
            <i class="bi bi-truck me-1"></i> MDF-e <span class="badge bg-primary ms-1"><?= count($arquivosMDFe) ?></span>
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#sped-fiscal" type="button">
            <i class="bi bi-file-earmark-spreadsheet me-1"></i> SPED Fiscal
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#sped-contribuicoes" type="button">
            <i class="bi bi-file-earmark-bar-graph me-1"></i> SPED Contribuições
        </button>
    </li>
</ul>

<div class="tab-content">

    <!-- ABA: NF-e -->
    <div class="tab-pane fade show active" id="nfe">
        <?php renderAbaDocumento('NFe', $arquivosNFe, $empresas, $filtros); ?>
    </div>

    <!-- ABA: NFC-e -->
    <div class="tab-pane fade" id="nfce">
        <?php renderAbaDocumento('NFCe', $arquivosNFCe, $empresas, $filtros); ?>
    </div>

    <!-- ABA: NFS-e -->
    <div class="tab-pane fade" id="nfse">
        <?php renderAbaDocumento('NFSe', $arquivosNFSe, $empresas, $filtros); ?>
    </div>

    <!-- ABA: MDF-e -->
    <div class="tab-pane fade" id="mdfe">
        <?php renderAbaDocumento('MDFe', $arquivosMDFe, $empresas, $filtros); ?>
    </div>

    <!-- ABA: SPED Fiscal -->
    <div class="tab-pane fade" id="sped-fiscal">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-file-earmark-spreadsheet me-2"></i> SPED Fiscal
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h5>Gerar SPED Fiscal</h5>
                        <p class="text-muted">Arquivo para apuração de ICMS e IPI</p>

                        <form id="formGerarSpedFiscal" class="mt-4">
                            <div class="mb-3">
                                <label class="form-label">Empresa *</label>
                                <select class="form-select" name="empresa_id" required>
                                    <option value="">Selecione a empresa...</option>
                                    <?php foreach ($empresas as $emp): ?>
                                        <option value="<?= $emp['id'] ?>"><?= htmlspecialchars($emp['razao_social']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Mês *</label>
                                    <select class="form-select" name="mes" required>
                                        <option value="">Selecione...</option>
                                        <?php foreach ($meses as $num => $nome): ?>
                                            <option value="<?= $num ?>"><?= $nome ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Ano *</label>
                                    <select class="form-select" name="ano" required>
                                        <option value="">Selecione...</option>
                                        <?php for ($ano = date('Y'); $ano >= (date('Y') - 5); $ano--): ?>
                                            <option value="<?= $ano ?>"><?= $ano ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            </div>
                            <button type="button" class="btn btn-info btn-lg w-100" onclick="gerarSpedFiscalDireto()">
                                <i class="bi bi-gear me-2"></i> Gerar SPED Fiscal
                            </button>
                        </form>
                    </div>
                    <div class="col-md-6">
                        <div class="alert alert-info">
                            <h6><i class="bi bi-info-circle me-2"></i>Sobre o SPED Fiscal</h6>
                            <p class="small mb-2">O SPED Fiscal (EFD-ICMS/IPI) é uma obrigação acessória digital que substitui a escrituração física dos livros:</p>
                            <ul class="small mb-0">
                                <li>Registro de Entradas</li>
                                <li>Registro de Saídas</li>
                                <li>Registro de Inventário</li>
                                <li>Registro de Apuração do ICMS e IPI</li>
                            </ul>
                        </div>

                        <div class="alert alert-warning">
                            <small><strong>Atenção:</strong> O arquivo será gerado com base nas NF-e do período selecionado.</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ABA: SPED Contribuições -->
    <div class="tab-pane fade" id="sped-contribuicoes">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-file-earmark-bar-graph me-2"></i> SPED Contribuições
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h5>Gerar SPED Contribuições</h5>
                        <p class="text-muted">Arquivo para apuração de PIS e COFINS</p>

                        <form id="formGerarSpedContrib" class="mt-4">
                            <div class="mb-3">
                                <label class="form-label">Empresa *</label>
                                <select class="form-select" name="empresa_id" required>
                                    <option value="">Selecione a empresa...</option>
                                    <?php foreach ($empresas as $emp): ?>
                                        <option value="<?= $emp['id'] ?>"><?= htmlspecialchars($emp['razao_social']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Mês *</label>
                                    <select class="form-select" name="mes" required>
                                        <option value="">Selecione...</option>
                                        <?php foreach ($meses as $num => $nome): ?>
                                            <option value="<?= $num ?>"><?= $nome ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Ano *</label>
                                    <select class="form-select" name="ano" required>
                                        <option value="">Selecione...</option>
                                        <?php for ($ano = date('Y'); $ano >= (date('Y') - 5); $ano--): ?>
                                            <option value="<?= $ano ?>"><?= $ano ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            </div>
                            <button type="button" class="btn btn-warning btn-lg w-100" onclick="gerarSpedContribuicoesDireto()">
                                <i class="bi bi-gear me-2"></i> Gerar SPED Contribuições
                            </button>
                        </form>
                    </div>
                    <div class="col-md-6">
                        <div class="alert alert-info">
                            <h6><i class="bi bi-info-circle me-2"></i>Sobre o SPED Contribuições</h6>
                            <p class="small mb-2">O SPED Contribuições (EFD-Contribuições) é destinado à apuração das contribuições:</p>
                            <ul class="small mb-0">
                                <li>PIS/PASEP</li>
                                <li>COFINS</li>
                                <li>Contribuição Previdenciária sobre a Receita</li>
                            </ul>
                        </div>

                        <div class="alert alert-warning">
                            <small><strong>Atenção:</strong> O arquivo será gerado com base em todos os documentos fiscais do período.</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<?php
/**
 * Renderiza uma aba de documento
 */
function renderAbaDocumento($tipo, $arquivos, $empresas, $filtros) {
    $tipoNome = match($tipo) {
        'NFe' => 'NF-e',
        'NFCe' => 'NFC-e',
        'NFSe' => 'NFS-e',
        'MDFe' => 'MDF-e',
        default => $tipo
    };
    ?>

    <!-- Filtros -->
    <div class="card mb-3">
        <div class="card-header">
            <i class="bi bi-funnel me-2"></i> Filtros <?= $tipoNome ?>
        </div>
        <div class="card-body">
            <form method="GET" action="<?= url('/arquivos-fiscais') ?>">
                <input type="hidden" name="tipo_documento" value="<?= $tipo ?>">
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Empresa *</label>
                        <select class="form-select" name="empresa_id" required>
                            <option value="">Selecione...</option>
                            <?php foreach ($empresas as $emp): ?>
                                <option value="<?= $emp['id'] ?>" <?= ($filtros['empresa_id'] ?? '') == $emp['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($emp['razao_social']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Operação *</label>
                        <select class="form-select" name="tipo_operacao" required>
                            <option value="">Selecione...</option>
                            <option value="entrada" <?= ($filtros['tipo_operacao'] ?? '') == 'entrada' ? 'selected' : '' ?>>Entrada</option>
                            <option value="saida" <?= ($filtros['tipo_operacao'] ?? '') == 'saida' ? 'selected' : '' ?>>Saída</option>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Status *</label>
                        <select class="form-select" name="status" required>
                            <option value="">Selecione...</option>
                            <option value="emitida" <?= ($filtros['status'] ?? '') == 'emitida' ? 'selected' : '' ?>>Emitidas</option>
                            <option value="cancelada" <?= ($filtros['status'] ?? '') == 'cancelada' ? 'selected' : '' ?>>Canceladas</option>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Mês *</label>
                        <select class="form-select" name="mes" id="mes_filtro" required>
                            <option value="">Selecione...</option>
                            <?php
                            $mesesCurtos = ['01' => 'Janeiro', '02' => 'Fevereiro', '03' => 'Março', '04' => 'Abril', '05' => 'Maio', '06' => 'Junho',
                                      '07' => 'Julho', '08' => 'Agosto', '09' => 'Setembro', '10' => 'Outubro', '11' => 'Novembro', '12' => 'Dezembro'];
                            $mesAtual = $filtros['mes'] ?? '';
                            foreach ($mesesCurtos as $num => $nome):
                            ?>
                                <option value="<?= $num ?>" <?= $mesAtual == $num ? 'selected' : '' ?>><?= $nome ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Ano *</label>
                        <select class="form-select" name="ano" id="ano_filtro" required>
                            <option value="">Selecione...</option>
                            <?php
                            $anoAtual = date('Y');
                            $anoSelecionado = $filtros['ano'] ?? '';
                            for ($ano = $anoAtual; $ano >= ($anoAtual - 5); $ano--):
                            ?>
                                <option value="<?= $ano ?>" <?= $anoSelecionado == $ano ? 'selected' : '' ?>><?= $ano ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>

                    <div class="col-md-4 mb-3">
                        <label class="form-label">Chave de Acesso</label>
                        <input type="text" class="form-control" name="chave_acesso"
                               placeholder="Digite a chave" value="<?= htmlspecialchars($filtros['chave_acesso'] ?? '') ?>">
                    </div>

                    <div class="col-md-2 mb-3 d-flex align-items-end gap-2">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="bi bi-search me-1"></i> Filtrar
                        </button>
                    </div>

                    <div class="col-md-2 mb-3 d-flex align-items-end gap-2">
                        <button type="button" class="btn btn-success w-100" onclick="abrirModalExportar('<?= $tipo ?>')">
                            <i class="bi bi-file-earmark-zip me-1"></i> Exportar
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Lista de Arquivos -->
    <div class="card">
        <div class="card-header">
            <i class="bi bi-list me-2"></i> <?= $tipoNome ?> (<?= count($arquivos) ?>)
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Número Nota</th>
                            <th>Data Emissão</th>
                            <th>Operação</th>
                            <th>Destinatário</th>
                            <th>Valor</th>
                            <th>Chave de Acesso</th>
                            <th>Protocolo</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($arquivos)): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <i class="bi bi-inbox fs-1 text-muted"></i>
                                    <p class="text-muted mt-2 mb-0">Nenhum <?= $tipoNome ?> encontrado</p>
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($arquivos as $arq): ?>
                                <tr style="cursor: pointer;" onclick="acoesNota(<?= $arq['id'] ?>, '<?= addslashes($arq['numero_documento']) ?>', '<?= $arq['chave_acesso'] ?? '' ?>')">
                                    <td>
                                        <strong><?= $arq['numero_documento'] ?></strong>
                                        <?php if (($arq['status_nfe'] ?? '') === 'cancelada'): ?>
                                            <span class="badge bg-danger ms-2">Cancelada</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?= date('d/m/Y', strtotime($arq['data_emissao'])) ?></td>
                                    <td>
                                        <?php if ($arq['tipo_operacao'] == 'entrada'): ?>
                                            <i class="bi bi-arrow-down-circle text-success"></i> Entrada
                                        <?php else: ?>
                                            <i class="bi bi-arrow-up-circle text-danger"></i> Saída
                                        <?php endif; ?>
                                    </td>
                                    <td><small><?= htmlspecialchars(substr($arq['destinatario_nome'] ?? '', 0, 30)) ?></small></td>
                                    <td>R$ <?= number_format($arq['valor_total'], 2, ',', '.') ?></td>
                                    <td>
                                        <?php if ($arq['chave_acesso']): ?>
                                            <small class="font-monospace"><?= $arq['chave_acesso'] ?></small>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($arq['protocolo']): ?>
                                            <small class="font-monospace"><?= $arq['protocolo'] ?></small>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

<?php } ?>

<!-- Modal Exportar -->
<div class="modal fade" id="modalExportar">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="bi bi-file-earmark-zip me-2"></i> Exportar para Contador</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formExportar">
                    <input type="hidden" name="tipo_documento" id="exportar_tipo_documento">
                    <div class="mb-3">
                        <label class="form-label">Empresa *</label>
                        <select class="form-select" name="empresa_id" required>
                            <option value="">Selecione...</option>
                            <?php foreach ($empresas as $emp): ?>
                                <option value="<?= $emp['id'] ?>"><?= htmlspecialchars($emp['razao_social']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Mês *</label>
                            <select class="form-select" name="mes" required>
                                <option value="">Selecione...</option>
                                <?php
                                $meses = ['01' => 'Janeiro', '02' => 'Fevereiro', '03' => 'Março', '04' => 'Abril',
                                          '05' => 'Maio', '06' => 'Junho', '07' => 'Julho', '08' => 'Agosto',
                                          '09' => 'Setembro', '10' => 'Outubro', '11' => 'Novembro', '12' => 'Dezembro'];
                                foreach ($meses as $num => $nome):
                                ?>
                                    <option value="<?= $num ?>"><?= $nome ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Ano *</label>
                            <select class="form-select" name="ano" required>
                                <option value="">Selecione...</option>
                                <?php
                                $anoAtual = date('Y');
                                for ($ano = $anoAtual; $ano >= ($anoAtual - 5); $ano--):
                                ?>
                                    <option value="<?= $ano ?>" <?= $ano == $anoAtual ? 'selected' : '' ?>><?= $ano ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label d-block">Formato *</label>
                        <div class="btn-group w-100" role="group">
                            <input type="radio" class="btn-check" name="formato" id="formato_xml" value="xml" checked>
                            <label class="btn btn-outline-primary" for="formato_xml">
                                <i class="bi bi-file-earmark-code me-1"></i> XML
                            </label>

                            <input type="radio" class="btn-check" name="formato" id="formato_pdf" value="pdf">
                            <label class="btn btn-outline-primary" for="formato_pdf">
                                <i class="bi bi-file-earmark-pdf me-1"></i> PDF
                            </label>
                        </div>
                        <small class="text-muted">Escolha o formato dos arquivos para exportar</small>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="enviarEmailContador()">
                    <i class="bi bi-envelope me-1"></i> Enviar E-mail
                </button>
                <button type="button" class="btn btn-success" onclick="exportarContador()">
                    <i class="bi bi-download me-1"></i> Exportar ZIP
                </button>
            </div>
        </div>
    </div>
</div>

<script>
function abrirModalExportar(tipo) {
    document.getElementById('exportar_tipo_documento').value = tipo;
    new bootstrap.Modal(document.getElementById('modalExportar')).show();
}

function exportarContador() {
    const form = document.getElementById('formExportar');
    const formData = new FormData(form);
    const formato = formData.get('formato');
    const formatoTexto = formato === 'pdf' ? 'PDFs' : 'XMLs';

    Swal.fire({
        title: 'Gerando ZIP...',
        text: `Aguarde enquanto preparamos os arquivos ${formatoTexto}`,
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    fetch(appUrl('/arquivos-fiscais/exportar-contador'), {
        method: 'POST',
        body: formData
    }).then(response => {
        if (response.ok) {
            return response.blob().then(blob => {
                const url = window.URL.createObjectURL(blob);
                const a = document.createElement('a');
                a.href = url;
                a.download = `${formatoTexto}_Contador.zip`;
                document.body.appendChild(a);
                a.click();
                window.URL.revokeObjectURL(url);

                Swal.fire('Sucesso!', `ZIP de ${formatoTexto} gerado com sucesso`, 'success');
                bootstrap.Modal.getInstance(document.getElementById('modalExportar')).hide();
            });
        }
        throw new Error('Erro ao gerar ZIP');
    }).catch(error => {
        Swal.fire('Erro', error.message, 'error');
    });
}

function enviarEmailContador() {
    const form = document.getElementById('formExportar');
    const formData = new FormData(form);
    const formato = formData.get('formato');
    const formatoTexto = formato === 'pdf' ? 'PDFs' : 'XMLs';

    Swal.fire({
        title: 'Enviando E-mail...',
        text: `Aguarde enquanto enviamos os arquivos ${formatoTexto} para o contador`,
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    fetch(appUrl('/arquivos-fiscais/enviar-email-contador'), {
        method: 'POST',
        body: formData
    }).then(response => {
        return response.json().then(data => {
            if (data.success) {
                Swal.fire('Sucesso!', 'E-mail enviado com sucesso para o contador', 'success');
                bootstrap.Modal.getInstance(document.getElementById('modalExportar')).hide();
            } else {
                throw new Error(data.message || 'Erro ao enviar e-mail');
            }
        });
    }).catch(error => {
        Swal.fire('Erro', error.message, 'error');
    });
}

// Funções para gerar SPEDs direto das abas
function gerarSpedFiscalDireto() {
    const form = document.getElementById('formGerarSpedFiscal');
    const formData = new FormData(form);

    Swal.fire({
        title: 'Gerando SPED Fiscal...',
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    $.ajax({
        url: appUrl('/arquivos-fiscais/gerar-sped-fiscal'),
        type: 'POST',
        data: Object.fromEntries(formData),
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                Swal.fire('Sucesso!', response.message || 'SPED gerado', 'success');
            } else {
                Swal.fire('Erro', response.message, 'error');
            }
        },
        error: function() {
            Swal.fire('Erro', 'Erro ao gerar SPED Fiscal', 'error');
        }
    });
}

function gerarSpedContribuicoesDireto() {
    const form = document.getElementById('formGerarSpedContrib');
    const formData = new FormData(form);

    Swal.fire({
        title: 'Gerando SPED Contribuições...',
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    $.ajax({
        url: appUrl('/arquivos-fiscais/gerar-sped-contribuicoes'),
        type: 'POST',
        data: Object.fromEntries(formData),
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                Swal.fire('Sucesso!', response.message || 'SPED gerado', 'success');
            } else {
                Swal.fire('Erro', response.message, 'error');
            }
        },
        error: function() {
            Swal.fire('Erro', 'Erro ao gerar SPED Contribuições', 'error');
        }
    });
}

function downloadXml(id) {
    window.location.href = appUrl('/arquivos-fiscais/download-xml?id=' + id);
}

function downloadPdf(id) {
    window.location.href = appUrl('/arquivos-fiscais/download-pdf?id=' + id);
}

function deletarArquivo(id) {
    Swal.fire({
        title: 'Confirma exclusão?',
        text: 'Esta ação não pode ser desfeita',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sim, excluir',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#dc3545'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: appUrl('/arquivos-fiscais/deletar'),
                type: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire('Sucesso!', 'Arquivo excluído', 'success').then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire('Erro', response.message, 'error');
                    }
                },
                error: function() {
                    Swal.fire('Erro', 'Erro ao excluir arquivo', 'error');
                }
            });
        }
    });
}

function acoesNota(id, numeroNota, chaveAcesso) {
    Swal.fire({
        title: `NF-e ${numeroNota}`,
        html: chaveAcesso ? `<p class="text-muted small mb-0">Chave: ${chaveAcesso}</p>` : '',
        showCancelButton: true,
        showDenyButton: true,
        confirmButtonText: '<i class="bi bi-printer me-2"></i> Reimprimir NF-e',
        denyButtonText: '<i class="bi bi-file-earmark-code me-2"></i> Ver XML',
        cancelButtonText: 'Fechar',
        confirmButtonColor: '#0d6efd',
        denyButtonColor: '#6c757d',
        cancelButtonColor: '#dc3545',
        customClass: {
            confirmButton: 'btn btn-primary me-2',
            denyButton: 'btn btn-secondary me-2',
            cancelButton: 'btn btn-outline-secondary'
        },
        buttonsStyling: false,
        width: 600
    }).then((result) => {
        if (result.isConfirmed) {
            // Reimprimir NF-e
            reimprimirNFe(id);
        } else if (result.isDenied) {
            // Ver XML
            verXML(id);
        }
    });
}

function reimprimirNFe(id) {
    Swal.fire({
        title: 'Buscando DANFE...',
        text: 'Aguarde enquanto carregamos o PDF',
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    $.ajax({
        url: appUrl('/vendas/reimprimir-nfe?id=' + id),
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            Swal.close();

            if (response.success && response.data) {
                let pdfUrl = response.data.pdf_path || response.data.pdf_path_alternativo;

                if (pdfUrl) {
                    if (pdfUrl.startsWith('/')) {
                        pdfUrl = window.location.origin + pdfUrl;
                    }

                    const link = document.createElement('a');
                    link.href = pdfUrl;
                    link.target = '_blank';
                    link.rel = 'noopener noreferrer';
                    document.body.appendChild(link);
                    link.click();
                    document.body.removeChild(link);

                    Swal.fire({
                        icon: 'success',
                        title: 'DANFE Aberto',
                        text: 'O DANFE foi aberto em uma nova aba.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Caminho do PDF não encontrado'
                    });
                }
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: response.message || 'PDF não encontrado'
                });
            }
        },
        error: function() {
            Swal.close();
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Erro ao buscar DANFE'
            });
        }
    });
}

function verXML(id) {
    Swal.fire({
        title: 'Buscando XML...',
        text: 'Aguarde enquanto carregamos o arquivo',
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    $.ajax({
        url: appUrl('/vendas/visualizar-xml?id=' + id),
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            Swal.close();

            if (response.success && response.data) {
                let xmlUrl = response.data.xml_path;

                if (xmlUrl) {
                    if (xmlUrl.startsWith('/')) {
                        xmlUrl = window.location.origin + xmlUrl;
                    }

                    const link = document.createElement('a');
                    link.href = xmlUrl;
                    link.target = '_blank';
                    link.rel = 'noopener noreferrer';
                    document.body.appendChild(link);
                    link.click();
                    document.body.removeChild(link);

                    Swal.fire({
                        icon: 'success',
                        title: 'XML Aberto',
                        text: 'O arquivo XML foi aberto em uma nova aba.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Caminho do XML não encontrado'
                    });
                }
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: response.message || 'XML não encontrado'
                });
            }
        },
        error: function() {
            Swal.close();
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Erro ao buscar XML'
            });
        }
    });
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'arquivos-fiscais';
include ROOT_PATH . '/views/layouts/app.php';
?>
