<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Áreas Comerciais</li>
            </ol>
        </nav>
        <h2><i class="bi bi-map me-2"></i> Áreas Comerciais</h2>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-list-ul me-2"></i> Lista de Áreas</h5>
                <a href="<?= url('/areas/criar') ?>" class="btn btn-primary">
                    <i class="bi bi-plus-circle me-2"></i> Nova Área
                </a>
            </div>
            <div class="card-body">
                <!-- Tabela -->
                <div class="table-responsive">
                    <table class="table table-hover" id="tabelaAreas">
                        <thead class="table-light">
                            <tr>
                                <th>Nome</th>
                                <th>Descrição</th>
                                <th>Status</th>
                                <th width="120">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($areas)): ?>
                                <?php foreach ($areas as $area): ?>
                                    <tr>
                                        <td>
                                            <strong><?= htmlspecialchars($area['name']) ?></strong>
                                        </td>
                                        <td>
                                            <?= htmlspecialchars($area['description'] ?? '-') ?>
                                        </td>
                                        <td>
                                            <?php if ($area['is_active']): ?>
                                                <span class="badge bg-success">
                                                    <i class="bi bi-check-circle me-1"></i> Ativa
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">
                                                    <i class="bi bi-x-circle me-1"></i> Inativa
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="<?= url('/areas/editar?id=' . $area['id']) ?>"
                                                    class="btn btn-outline-primary" title="Editar">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <button type="button" class="btn btn-outline-danger"
                                                    onclick="deletarArea(<?= $area['id'] ?>)">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-4">
                                        <i class="bi bi-inbox me-2"></i> Nenhuma área cadastrada
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if (!empty($areas) && isset($totalPages) && $totalPages > 1): ?>
                    <div class="d-flex justify-content-between align-items-center p-3 border-top">
                        <div class="text-muted">
                            Mostrando <?= (($page ?? 1) - 1) * ($perPage ?? 50) + 1 ?> a <?= min(($page ?? 1) * ($perPage ?? 50), $total ?? 0) ?> de <?= $total ?? 0 ?> áreas
                        </div>
                        <nav>
                            <ul class="pagination pagination-sm mb-0">
                                <li class="page-item <?= ($page ?? 1) <= 1 ? 'disabled' : '' ?>">
                                    <a class="page-link" href="?page=<?= max(1, ($page ?? 1) - 1) ?>" aria-label="Anterior">
                                        <span aria-hidden="true">&laquo;</span>
                                    </a>
                                </li>
                                <?php for ($i = max(1, ($page ?? 1) - 2); $i <= min($totalPages, ($page ?? 1) + 2); $i++): ?>
                                    <li class="page-item <?= ($i === ($page ?? 1)) ? 'active' : '' ?>">
                                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                                    </li>
                                <?php endfor; ?>
                                <li class="page-item <?= ($page ?? 1) >= $totalPages ? 'disabled' : '' ?>">
                                    <a class="page-link" href="?page=<?= min($totalPages, ($page ?? 1) + 1) ?>" aria-label="Próximo">
                                        <span aria-hidden="true">&raquo;</span>
                                    </a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                <?php elseif (!empty($areas) && isset($total) && $total > 0): ?>
                    <div class="text-center p-3 border-top">
                        <small class="text-muted">Mostrando todas as <?= $total ?> área(s)</small>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
    function deletarArea(id) {
        Swal.fire({
            title: 'Deletar Área',
            text: 'Tem certeza que deseja deletar esta área?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sim, deletar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: appUrl('/areas/deletar'),
                    type: 'POST',
                    data: { id: id },
                    beforeSend: function () {
                        LoadingOverlay.show();
                    },
                    success: function (response) {
                        LoadingOverlay.hide();
                        if (response.success) {
                            Swal.fire({
                                title: 'Deletado!',
                                text: response.message,
                                icon: 'success',
                                confirmButtonText: 'OK'
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                title: 'Erro',
                                text: response.message,
                                icon: 'error'
                            });
                        }
                    },
                    error: function () {
                        LoadingOverlay.hide();
                        Swal.fire({
                            title: 'Erro',
                            text: 'Erro ao deletar área',
                            icon: 'error'
                        });
                    }
                });
            }
        });
    }
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'areas';
include ROOT_PATH . '/views/layouts/app.php';
?>