<?php
// Shared form fields for creating/editing areas
// Variables available: $area (array) with keys: id, name, description, is_active

$area = $area ?? ['id' => null, 'name' => '', 'description' => '', 'is_active' => 1];
?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="bi bi-info-circle me-2"></i> Informações da Área
                </h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="name" class="form-label">
                        <i class="bi bi-signpost-2 me-2"></i> Nome da Área
                        <span class="text-danger">*</span>
                    </label>
                    <input type="text" class="form-control" id="name" name="name"
                        placeholder="Ex: Norte, Sul, Leste, Oeste" required maxlength="255"
                        value="<?= htmlspecialchars($area['name'] ?? '') ?>">
                    <small class="form-text text-muted">
                        Digite um nome único para identificar esta área comercial.
                    </small>
                </div>

                <div class="mb-3">
                    <label for="description" class="form-label">
                        <i class="bi bi-text-paragraph me-2"></i> Descrição
                    </label>
                    <textarea class="form-control" id="description" name="description" rows="4"
                        placeholder="Descreva a área comercial (opcional)"><?= htmlspecialchars($area['description'] ?? '') ?></textarea>
                    <small class="form-text text-muted">
                        Adicione informações adicionais sobre esta área.
                    </small>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="vendedor_id" class="form-label">
                            <i class="bi bi-person-badge me-1"></i> Vendedor
                        </label>
                        <select class="form-select" id="vendedor_id" name="vendedor_id">
                            <option value="">Selecione um vendedor</option>
                            <?php if (!empty($vendedores)): ?>
                                <?php foreach ($vendedores as $vendedor): ?>
                                    <option value="<?= $vendedor['id'] ?>"
                                        <?= (isset($area['vendedor_id']) && $area['vendedor_id'] == $vendedor['id']) ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($vendedor['name'] ?? '') ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="vendedor_auxiliar_id" class="form-label">
                            <i class="bi bi-person-badge me-1"></i> Vendedor Auxiliar
                        </label>
                        <select class="form-select" id="vendedor_auxiliar_id" name="vendedor_auxiliar_id">
                            <option value="">Selecione um vendedor auxiliar</option>
                            <?php if (!empty($vendedores)): ?>
                                <?php foreach ($vendedores as $vendedor): ?>
                                    <option value="<?= $vendedor['id'] ?>"
                                        <?= (isset($area['vendedor_auxiliar_id']) && $area['vendedor_auxiliar_id'] == $vendedor['id']) ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($vendedor['name'] ?? '') ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>

                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                        <?= ($area['is_active'] ?? 1) ? 'checked' : '' ?>>
                    <label class="form-check-label" for="is_active">
                        <i class="bi bi-check-circle me-1"></i> Ativa
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>