<?php
ob_start();
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?= url('/areas') ?>">Áreas</a></li>
                        <li class="breadcrumb-item active">Nova Área</li>
                    </ol>
                </div>
                <h4 class="page-title">
                    <i class="bi bi-plus-circle me-2"></i> Nova Área Comercial
                </h4>
            </div>
        </div>
    </div>

    <form id="areaForm" method="POST" action="<?= url('/areas/criar') ?>">
        <?php include ROOT_PATH . '/views/areas/form.php'; ?>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-lg me-2"></i> Salvar Área
                        </button>
                        <a href="<?= url('/areas') ?>" class="btn btn-secondary">
                            <i class="bi bi-arrow-left me-2"></i> Voltar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        $('#areaForm').on('submit', function (e) {
            e.preventDefault();

            // Validar que vendedor principal e auxiliar não sejam o mesmo
            const vendedorId = $('#vendedor_id').val();
            const vendedorAuxiliarId = $('#vendedor_auxiliar_id').val();
            if (vendedorId && vendedorAuxiliarId && vendedorId === vendedorAuxiliarId) {
                Swal.fire({
                    title: 'Atenção!',
                    text: 'O vendedor principal e o vendedor auxiliar não podem ser a mesma pessoa',
                    icon: 'warning',
                    confirmButtonText: 'OK'
                });
                return false;
            }

            const formData = $(this).serialize();

            $.ajax({
                url: appUrl('/areas/criar'),
                type: 'POST',
                data: formData,
                beforeSend: function () {
                    LoadingOverlay.show();
                },
                success: function (response) {
                    LoadingOverlay.hide();

                    if (response.success) {
                        Swal.fire({
                            title: 'Sucesso!',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = appUrl(response.data.redirect);
                        });
                    } else {
                        Swal.fire({
                            title: 'Erro!',
                            text: response.message,
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                },
                error: function () {
                    LoadingOverlay.hide();
                    Swal.fire({
                        title: 'Erro!',
                        text: 'Erro ao salvar área',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                }
            });
        });
    });
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'areas';
include ROOT_PATH . '/views/layouts/app.php';
?>