<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-calendar3 me-2"></i> Agenda</h2>
        <p class="text-muted">Gerencie seus compromissos e eventos</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/agenda/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Novo Evento
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <input type="text" class="form-control" name="search" placeholder="Buscar por título, descrição, contato..." value="<?= htmlspecialchars($search ?? '') ?>">
            </div>
            <div class="col-md-3">
                <input type="date" class="form-control" name="date" value="<?= htmlspecialchars($date ?? '') ?>">
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-secondary w-100">
                    <i class="bi bi-search"></i> Buscar
                </button>
            </div>
            <div class="col-md-2">
                <a href="<?= url('/agenda') ?>" class="btn btn-outline-secondary w-100">
                    <i class="bi bi-arrow-clockwise"></i> Limpar
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Eventos</span>
        <span class="badge bg-primary"><?= count($eventos ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($eventos)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Título</th>
                            <th>Data/Hora</th>
                            <th>Local</th>
                            <th>Contato</th>
                            <th width="120" class="text-center">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($eventos as $evento): ?>
                            <tr>
                                <td><?= $evento['id'] ?></td>
                                <td>
                                    <strong><?= htmlspecialchars($evento['title']) ?></strong>
                                    <?php if (!empty($evento['description'])): ?>
                                        <br><small class="text-muted"><?= htmlspecialchars(substr($evento['description'], 0, 50)) ?>...</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <strong><?= date('d/m/Y', strtotime($evento['start_date'])) ?></strong>
                                    <br><small class="text-muted"><?= date('H:i', strtotime($evento['start_date'])) ?></small>
                                    <?php if ($evento['all_day']): ?>
                                        <br><small class="badge bg-info">Dia todo</small>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($evento['location'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($evento['contact_name'] ?? '-') ?></td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?= url('/agenda/editar?id=' . $evento['id']) ?>" class="btn btn-outline-primary" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button class="btn btn-outline-danger" onclick="deletarEvento(<?= $evento['id'] ?>)" title="Excluir">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-calendar3" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhum evento encontrado</p>
                <a href="<?= url('/agenda/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeiro Evento
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
async function deletarEvento(id) {
    const confirmed = await confirmDelete('Tem certeza que deseja excluir este evento?');
    if (confirmed) {
        $.ajax({
            url: appUrl('/agenda/deletar'),
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Toast.success(response.message);
                    setTimeout(() => location.reload(), 1500);
                } else {
                    Toast.error(response.message);
                }
            }
        });
    }
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'agenda';
include ROOT_PATH . '/views/layouts/app.php';
?>
