<?php
ob_start();
$isEdit = isset($agendamento['id']);
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-calendar-check me-2"></i> Agenda Técnica</h2>
        <p class="text-muted">Gerencie agendamentos técnicos e visitas</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/agenda-tecnica/criar') ?>" class="btn" style="background-color: #001122; border-color: #001122; color: white;">
            <i class="bi bi-plus-circle me-2"></i> Novo Agendamento
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-header text-white" style="background-color: #001122 !important; border-color: #001122 !important;">
        <i class="bi bi-funnel me-2"></i> Filtros
    </div>
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Buscar</label>
                <input type="text" class="form-control" name="search" placeholder="Título, descrição..." value="<?= htmlspecialchars($search ?? '') ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">Técnico</label>
                <select class="form-select" name="tecnico_id">
                    <option value="">Todos os técnicos</option>
                    <?php foreach ($tecnicos ?? [] as $tecnico): ?>
                        <option value="<?= $tecnico['id'] ?>" <?= ($tecnico_id ?? '') == $tecnico['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($tecnico['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Cliente</label>
                <select class="form-select" name="cliente_id">
                    <option value="">Todos os clientes</option>
                    <?php foreach ($clientes ?? [] as $cliente): ?>
                        <option value="<?= $cliente['id'] ?>" <?= ($cliente_id ?? '') == $cliente['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($cliente['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Data De</label>
                <input type="date" class="form-control" name="data_de" value="<?= htmlspecialchars($data_de ?? '') ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">Data Até</label>
                <input type="date" class="form-control" name="data_ate" value="<?= htmlspecialchars($data_ate ?? '') ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-secondary w-100">
                    <i class="bi bi-search"></i> Buscar
                </button>
            </div>
            <div class="col-md-3">
                <label class="form-label">&nbsp;</label>
                <a href="<?= url('/agenda-tecnica') ?>" class="btn btn-outline-secondary w-100">
                    <i class="bi bi-arrow-clockwise"></i> Limpar
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header text-white" style="background-color: #001122 !important; border-color: #001122 !important;">
        <div class="d-flex justify-content-between align-items-center">
            <span><i class="bi bi-list-ul me-2"></i> Lista de Agendamentos</span>
            <span class="badge bg-light text-dark"><?= count($agendamentos ?? []) ?> registro(s)</span>
        </div>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($agendamentos)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Título</th>
                            <th>Tipo</th>
                            <th>Técnico</th>
                            <th>Cliente</th>
                            <th>Data/Hora</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($agendamentos as $agendamento):
                            $tipoLabel = match($agendamento['tipo_atendimento'] ?? '') {
                                'visita_comercial' => 'Visita Comercial',
                                'implantacao' => 'Implantação',
                                'treinamento_avulso' => 'Treinamento Avulso',
                                default => '-'
                            };
                        ?>
                            <tr style="cursor: pointer;"
                                data-agendamento-id="<?= $agendamento['id'] ?>"
                                data-agendamento-titulo="<?= htmlspecialchars($agendamento['titulo'], ENT_QUOTES) ?>"
                                data-agendamento-tipo="<?= htmlspecialchars($tipoLabel, ENT_QUOTES) ?>"
                                data-agendamento-tecnico="<?= htmlspecialchars($agendamento['tecnico_nome'] ?? '', ENT_QUOTES) ?>"
                                data-agendamento-cliente="<?= htmlspecialchars($agendamento['cliente_nome'] ?? '', ENT_QUOTES) ?>"
                                data-agendamento-data="<?= date('d/m/Y', strtotime($agendamento['data_agendamento'])) ?>"
                                data-agendamento-hora="<?= date('H:i', strtotime($agendamento['hora_inicio'])) ?>"
                                data-agendamento-status="<?= htmlspecialchars($agendamento['status'], ENT_QUOTES) ?>"
                                onclick="abrirOpcoesAgendamento(event)">
                                <td><?= $agendamento['id'] ?></td>
                                <td>
                                    <strong><?= htmlspecialchars($agendamento['titulo']) ?></strong>
                                    <?php if (!empty($agendamento['descricao'])): ?>
                                        <br><small class="text-muted"><?= htmlspecialchars(substr($agendamento['descricao'], 0, 50)) ?>...</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (!empty($agendamento['tipo_atendimento'])): ?>
                                        <span class="badge bg-info"><?= $tipoLabel ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($agendamento['tecnico_nome'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($agendamento['cliente_nome'] ?? '-') ?></td>
                                <td>
                                    <strong><?= date('d/m/Y', strtotime($agendamento['data_agendamento'])) ?></strong>
                                    <br><small class="text-muted"><?= date('H:i', strtotime($agendamento['hora_inicio'])) ?>
                                    <?php if (!empty($agendamento['hora_fim'])): ?>
                                        - <?= date('H:i', strtotime($agendamento['hora_fim'])) ?>
                                    <?php endif; ?>
                                    </small>
                                </td>
                                <td>
                                    <?php
                                    $statusClass = match($agendamento['status']) {
                                        'agendado' => 'bg-primary',
                                        'em_andamento' => 'bg-warning',
                                        'concluido' => 'bg-success',
                                        'cancelado' => 'bg-danger',
                                        default => 'bg-secondary'
                                    };
                                    $statusLabel = match($agendamento['status']) {
                                        'agendado' => 'Agendado',
                                        'em_andamento' => 'Em Andamento',
                                        'concluido' => 'Concluído',
                                        'cancelado' => 'Cancelado',
                                        default => ucfirst($agendamento['status'])
                                    };
                                    ?>
                                    <span class="badge <?= $statusClass ?>"><?= $statusLabel ?></span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-calendar-check" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhum agendamento encontrado</p>
                <a href="<?= url('/agenda-tecnica/criar') ?>" class="btn" style="background-color: #001122; border-color: #001122; color: white; margin-top: 1rem;">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeiro Agendamento
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    /* Cards de opções (padrão semelhante ao módulo Vendas) */
    .opcoes-grupo {
        margin-bottom: 1.5rem;
        padding: 0 0.5rem;
    }

    .opcoes-grupo:last-child {
        margin-bottom: 0.5rem;
    }

    .opcoes-titulo {
        font-size: 0.85rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.08em;
        color: #64748b;
        margin-bottom: 0.6rem;
        display: flex;
        align-items: center;
        gap: 0.35rem;
    }

    .opcoes-titulo::before {
        content: '';
        width: 6px;
        height: 6px;
        border-radius: 50%;
        background: #cbd5f5;
    }

    .opcoes-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
        gap: 0.75rem;
    }

    .opcao-card {
        width: 130px;
        height: 130px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 0.75rem;
        border: 2px solid #e0e0e0;
        border-radius: 12px;
        background: white;
        cursor: pointer;
        transition: all 0.2s ease-in-out;
        padding: 1rem;
    }

    .opcao-card i {
        font-size: 2rem;
    }

    .opcao-card span {
        font-size: 0.9rem;
        font-weight: 600;
        text-align: center;
    }

    .opcao-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 18px rgba(0, 0, 0, 0.12);
    }

    .opcao-card-primary {
        border-color: #0d6efd;
        color: #0d6efd;
    }

    .opcao-card-primary:hover {
        background: #0d6efd;
        color: #fff;
    }

    .opcao-card-danger {
        border-color: #dc3545;
        color: #dc3545;
    }

    .opcao-card-danger:hover {
        background: #dc3545;
        color: #fff;
    }
</style>

<script>
function abrirOpcoesAgendamento(event) {
    // Buscar dados da linha da tabela
    const row = event.target.closest('tr');
    if (!row) return;

    const id = row.dataset.agendamentoId;
    const titulo = row.dataset.agendamentoTitulo;
    const tipo = row.dataset.agendamentoTipo || '-';
    const tecnico = row.dataset.agendamentoTecnico;
    const cliente = row.dataset.agendamentoCliente;
    const data = row.dataset.agendamentoData;
    const hora = row.dataset.agendamentoHora;
    const status = row.dataset.agendamentoStatus;

    const statusLabel = {
        'agendado': 'Agendado',
        'em_andamento': 'Em Andamento',
        'concluido': 'Concluído',
        'cancelado': 'Cancelado'
    }[status] || status;

    const headerHtml = `
        <div style="background: linear-gradient(135deg, #001122 0%, #003366 100%);
                    padding: 1.5rem;
                    margin: 0 0 1rem 0;
                    border-radius: 12px 12px 0 0;
                    color: white;
                    text-align: left;">
            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 0.75rem;">
                <div style="background: rgba(255,255,255,0.2);
                            padding: 0.75rem;
                            border-radius: 10px;
                            display: flex;
                            align-items: center;
                            justify-content: center;">
                    <i class="bi bi-calendar-check" style="font-size: 1.5rem;"></i>
                </div>
                <div style="flex: 1;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">Agendamento</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">${titulo}</div>
                    ${tipo !== '-' ? `<div style="font-size: 0.75rem; opacity: 0.8; margin-top: 0.25rem;">
                        <span style="background: rgba(255,255,255,0.2); padding: 0.25rem 0.5rem; border-radius: 4px;">${tipo}</span>
                    </div>` : ''}
                </div>
            </div>
            <div style="background: rgba(255,255,255,0.15);
                        padding: 0.75rem 1rem;
                        border-radius: 8px;
                        display: flex;
                        align-items: center;
                        gap: 0.75rem;">
                <i class="bi bi-calendar-event" style="font-size: 1.1rem; opacity: 0.9;"></i>
                <div style="flex: 1;">
                    <strong style="font-size: 0.95rem;">${data} às ${hora}</strong>
                    <div style="opacity: 0.9; font-size: 0.85rem; margin-top: 0.25rem;">
                        <i class="bi bi-person-circle" style="font-size: 0.85rem; margin-right: 0.25rem;"></i>
                        ${tecnico || 'Técnico não informado'}
                    </div>
                </div>
                ${cliente ? `
                    <div style="text-align: right; border-left: 1px solid rgba(255,255,255,0.2); padding-left: 0.75rem;">
                        <div style="opacity: 0.8; font-size: 0.75rem; margin-bottom: 0.25rem;">Cliente</div>
                        <div style="font-size: 0.9rem; font-weight: 600;">
                            <i class="bi bi-building" style="font-size: 0.85rem; margin-right: 0.25rem;"></i>
                            ${cliente}
                        </div>
                    </div>
                ` : ''}
            </div>
        </div>
    `;

    const opcoesHtml = `
        <div class="opcoes-grupo">
            <h6 class="opcoes-titulo">Ações</h6>
            <div class="opcoes-grid">
                <button type="button" class="opcao-card opcao-card-primary" onclick="window.location.href=appUrl('/agenda-tecnica/editar?id=${id}')">
                    <i class="bi bi-pencil"></i>
                    <span>Editar</span>
                </button>
                <button type="button" class="opcao-card opcao-card-danger" onclick="Swal.close(); deletarAgendamento(${id})">
                    <i class="bi bi-trash"></i>
                    <span>Excluir</span>
                </button>
            </div>
        </div>
    `;

    const html = headerHtml + opcoesHtml;

    Swal.fire({
        html: html,
        showConfirmButton: false,
        showCloseButton: true,
        width: '600px',
        padding: '0',
        customClass: {
            popup: 'swal2-no-padding',
            htmlContainer: 'swal2-html-container-custom'
        }
    });
}

async function deletarAgendamento(id) {
    const confirmed = await Swal.fire({
        title: 'Tem certeza?',
        text: 'Deseja realmente excluir este agendamento?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#001122',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sim, excluir',
        cancelButtonText: 'Cancelar'
    });

    if (confirmed.isConfirmed) {
        $.ajax({
            url: appUrl('/agenda-tecnica/deletar'),
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message || 'Agendamento excluído com sucesso',
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => location.reload());
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message || 'Erro ao excluir agendamento'
                    });
                }
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Erro ao excluir agendamento'
                });
            }
        });
    }
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'agenda-tecnica';
include ROOT_PATH . '/views/layouts/app.php';
?>

