<?php
ob_start();
$isEdit = isset($agendamento['id']);
?>

<div class="row mb-4">
    <div class="col-md-8">
        <h2><i class="bi bi-calendar-check me-2"></i> <?= $isEdit ? 'Editar' : 'Novo' ?> Agendamento Técnico</h2>
        <p class="text-muted">Cadastre ou edite um agendamento técnico</p>
    </div>
</div>

<form id="formAgendamento" method="POST"
    action="<?= url($isEdit ? '/agenda-tecnica/editar' : '/agenda-tecnica/criar') ?>">
    <?php if ($isEdit): ?>
        <input type="hidden" name="id" value="<?= $agendamento['id'] ?>">
    <?php endif; ?>

    <div class="card mb-4">
        <div class="card-header text-white"
            style="background-color: #001122 !important; border-color: #001122 !important;">
            <i class="bi bi-file-earmark-text me-2"></i> Dados do Agendamento
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="titulo" class="form-label">Título</label>
                    <input type="text" class="form-control" id="titulo" name="titulo"
                        value="<?= htmlspecialchars($agendamento['titulo'] ?? '') ?>">
                </div>
                <div class="col-md-4 mb-3">
                    <label for="tipo_atendimento" class="form-label">Tipo de Atendimento</label>
                    <select class="form-select" id="tipo_atendimento" name="tipo_atendimento">
                        <option value="">Selecione o tipo...</option>
                        <option value="visita_comercial" <?= ($agendamento['tipo_atendimento'] ?? '') === 'visita_comercial' ? 'selected' : '' ?>>Visita Comercial</option>
                        <option value="implantacao" <?= ($agendamento['tipo_atendimento'] ?? '') === 'implantacao' ? 'selected' : '' ?>>Implantação</option>
                        <option value="treinamento_avulso" <?= ($agendamento['tipo_atendimento'] ?? '') === 'treinamento_avulso' ? 'selected' : '' ?>>Treinamento Avulso</option>
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="status" class="form-label">Status *</label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="agendado" <?= ($agendamento['status'] ?? 'agendado') === 'agendado' ? 'selected' : '' ?>>Agendado</option>
                        <option value="em_andamento" <?= ($agendamento['status'] ?? '') === 'em_andamento' ? 'selected' : '' ?>>Em Andamento</option>
                        <option value="concluido" <?= ($agendamento['status'] ?? '') === 'concluido' ? 'selected' : '' ?>>
                            Concluído</option>
                        <option value="cancelado" <?= ($agendamento['status'] ?? '') === 'cancelado' ? 'selected' : '' ?>>
                            Cancelado</option>
                    </select>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="tecnico_id" class="form-label">Técnico *</label>
                    <select class="form-select" id="tecnico_id" name="tecnico_id" required>
                        <option value="">Selecione o técnico...</option>
                        <?php foreach ($tecnicos ?? [] as $tecnico): ?>
                            <option value="<?= $tecnico['id'] ?>" <?= ($agendamento['tecnico_id'] ?? '') == $tecnico['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($tecnico['name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="cliente_search" class="form-label">Cliente *</label>
                    <div class="position-relative">
                        <input type="text" class="form-control" id="cliente_search"
                            placeholder="Digite nome, razão social ou CNPJ/CPF do cliente..." autocomplete="off"
                            required>
                        <div id="cliente_dropdown" class="autocomplete-dropdown" style="display: none;"></div>
                        <button type="button" class="btn btn-sm btn-outline-secondary position-absolute"
                            style="right: 5px; top: 50%; transform: translateY(-50%); z-index: 10;"
                            onclick="abrirModalNovoCliente()" title="Cadastrar Novo Cliente">
                            <i class="bi bi-person-plus"></i>
                        </button>
                    </div>
                    <input type="hidden" id="cliente_id" name="cliente_id"
                        value="<?= $agendamento['cliente_id'] ?? '' ?>" required>
                    <input type="hidden" id="cliente_name" name="cliente_name"
                        value="<?= htmlspecialchars($agendamento['cliente_nome'] ?? '') ?>">
                    <div id="cliente_info" style="display: none;" class="mt-2">
                        <div class="alert alert-info mb-0">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1" id="cliente_info_content"></div>
                                <button type="button" class="btn btn-sm btn-outline-danger ms-2"
                                    onclick="limparCliente()">
                                    <i class="bi bi-x"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Campos condicionais para Visita Comercial -->
            <div id="campos-visita-comercial" style="display: none;">
                <hr class="my-4">
                <h6 class="mb-3" style="color: #001122;"><i class="bi bi-briefcase me-2"></i> Dados da Visita Comercial
                </h6>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="produto_visita_comercial" class="form-label">Produto</label>
                        <select class="form-select" id="produto_visita_comercial" name="produto_visita_comercial">
                            <option value="">Selecione o produto...</option>
                            <option value="sistema" <?= ($agendamento['produto_visita_comercial'] ?? '') === 'sistema' ? 'selected' : '' ?>>Sistema</option>
                            <option value="manutencao" <?= ($agendamento['produto_visita_comercial'] ?? '') === 'manutencao' ? 'selected' : '' ?>>Manutenção</option>
                            <option value="venda_equipamentos" <?= ($agendamento['produto_visita_comercial'] ?? '') === 'venda_equipamentos' ? 'selected' : '' ?>>Venda de Equipamentos</option>
                            <option value="e_commerce" <?= ($agendamento['produto_visita_comercial'] ?? '') === 'e_commerce' ? 'selected' : '' ?>>E-Commerce</option>
                            <option value="negociacao_valores" <?= ($agendamento['produto_visita_comercial'] ?? '') === 'negociacao_valores' ? 'selected' : '' ?>>Negociação de Valores em aberto</option>
                            <option value="levantamento_requisitos" <?= ($agendamento['produto_visita_comercial'] ?? '') === 'levantamento_requisitos' ? 'selected' : '' ?>>Levantamento de Requisitos</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="assunto_tratado_com" class="form-label">Assunto tratado com</label>
                        <input type="text" class="form-control" id="assunto_tratado_com" name="assunto_tratado_com"
                            value="<?= htmlspecialchars($agendamento['assunto_tratado_com'] ?? '') ?>"
                            placeholder="Nome da pessoa que nos recebeu...">
                    </div>
                </div>
            </div>

            <!-- Campos condicionais para Implantação -->
            <div id="campos-implantacao" style="display: none;">
                <hr class="my-4">
                <h6 class="mb-3" style="color: #001122;"><i class="bi bi-gear me-2"></i> Dados da Implantação</h6>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label class="form-label">Funcionário(s) Treinado(s) e Módulos</label>
                        <div class="d-flex gap-2 mb-2">
                            <input type="text" class="form-control" id="novo_funcionario"
                                placeholder="Nome do funcionário...">
                            <button type="button" class="btn btn-outline-success" id="btn-adicionar-funcionario">
                                <i class="bi bi-plus-circle me-1"></i> Adicionar Funcionário
                            </button>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered" id="tabela-funcionarios">
                                <thead>
                                    <tr>
                                        <th width="25%">Funcionário</th>
                                        <th width="60%">Módulos</th>
                                        <th width="15%" class="text-center">Ações</th>
                                    </tr>
                                </thead>
                                <tbody id="tbody-funcionarios">
                                    <!-- Funcionários e módulos serão adicionados aqui via JavaScript -->
                                </tbody>
                            </table>
                        </div>
                        <input type="hidden" id="funcionarios_modulos_json" name="funcionarios_modulos" value="">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 mb-3">
                    <label for="descricao" class="form-label">Descrição</label>
                    <textarea class="form-control" id="descricao" name="descricao" rows="3"
                        placeholder="Descrição do agendamento..."><?= htmlspecialchars($agendamento['descricao'] ?? '') ?></textarea>
                </div>
            </div>

            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="data_agendamento" class="form-label">Data *</label>
                    <input type="date" class="form-control" id="data_agendamento" name="data_agendamento"
                        value="<?= $agendamento['data_agendamento'] ?? date('Y-m-d') ?>" required>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="hora_inicio" class="form-label">Hora Início *</label>
                    <input type="time" class="form-control" id="hora_inicio" name="hora_inicio"
                        value="<?= $agendamento['hora_inicio'] ?? '08:00' ?>" required>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="hora_fim" class="form-label">Hora Fim</label>
                    <input type="time" class="form-control" id="hora_fim" name="hora_fim"
                        value="<?= $agendamento['hora_fim'] ?? '' ?>">
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 mb-3">
                    <label for="observacoes" class="form-label">Observações</label>
                    <textarea class="form-control" id="observacoes" name="observacoes" rows="3"
                        placeholder="Observações adicionais..."><?= htmlspecialchars($agendamento['observacoes'] ?? '') ?></textarea>
                </div>
            </div>
        </div>
    </div>

    <!-- Botões -->
    <div class="row">
        <div class="col-md-12 text-end">
            <a href="<?= url('/agenda-tecnica') ?>" class="btn btn-secondary">
                <i class="bi bi-x-circle me-2"></i> Cancelar
            </a>
            <button type="submit" class="btn" style="background-color: #001122; border-color: #001122; color: white;">
                <i class="bi bi-check-circle me-2"></i> <?= $isEdit ? 'Atualizar' : 'Salvar' ?> Agendamento
            </button>
        </div>
    </div>
</form>

<style>
    /* Estilos para autocomplete (igual ao módulo de vendas) */
    .autocomplete-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: var(--bs-body-bg, #fff);
        border: 1px solid var(--bs-border-color, #dee2e6);
        border-top: none;
        border-radius: 0 0 0.375rem 0.375rem;
        max-height: 300px;
        overflow-y: auto;
        z-index: 1000;
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }

    .autocomplete-item {
        padding: 0.875rem 1rem;
        cursor: pointer;
        border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
        transition: all 0.15s ease-in-out;
        line-height: 1.5;
    }

    .autocomplete-item:hover,
    .autocomplete-item.active {
        background-color: var(--bs-primary, #0d6efd);
        color: white;
        transform: translateX(3px);
    }

    .autocomplete-item:hover .text-muted {
        color: rgba(255, 255, 255, 0.8) !important;
    }

    .autocomplete-item:last-child {
        border-bottom: none;
    }

    .autocomplete-item .mb-1 {
        margin-bottom: 0.375rem;
    }

    .autocomplete-item strong {
        font-weight: 600;
    }

    .autocomplete-no-results {
        padding: 1rem;
        text-align: center;
        color: var(--bs-secondary, #6c757d);
    }

    /* Estilos modernos para switches no modal */
    .swal2-html-container .form-switch .form-check-input {
        width: 3em;
        height: 1.5em;
        cursor: pointer;
        background-color: #e9ecef;
        border: none;
        transition: all 0.3s;
    }

    .swal2-html-container .form-switch .form-check-input:checked {
        background-color: #001122;
    }

    .swal2-html-container .form-switch .form-check-input:focus {
        box-shadow: 0 0 0 0.25rem rgba(0, 17, 34, 0.25);
    }

    .swal2-html-container .form-switch:hover .form-check-input {
        transform: scale(1.05);
    }

    .swal2-html-container .form-check-label {
        font-size: 1rem;
        color: #495057;
        cursor: pointer;
        user-select: none;
    }

    .swal2-html-container .border.rounded {
        transition: all 0.2s;
    }

    .swal2-html-container .border.rounded:hover {
        background: #e9ecef !important;
        border-color: #001122 !important;
    }
</style>

<script>
    // Lista de módulos disponíveis
    const modulosDisponiveis = [
        'Vendas',
        'Compras',
        'Estoque',
        'Produtos',
        'Pessoas',
        'Contratos',
        'Contas a Receber',
        'Contas a Pagar',
        'Fluxo de Caixa',
        'Relatórios',
        'PDV',
        'Tickets',
        'Agenda',
        'Ordem de Serviço',
        'PMOC',
        'Impostos',
        'Tabelas de Preço',
        'Categorias',
        'Áreas Comerciais',
        'Métodos de Pagamento',
        'Plano de Contas',
        'Centro de Custos',
        'Gestor de Estoque',
        'Transferência de Estoque',
        'Importação',
        'Agenda Técnica'
    ];


    // Estrutura: { funcionario: "Maria", modulos: ["Vendas", "Compras"] }
    let funcionariosComModulos = [];
    <?php
    if (!empty($funcionarios_treinados ?? [])):
        // Agrupar funcionários e seus módulos
        $funcionariosAgrupados = [];
        foreach ($funcionarios_treinados as $item) {
            if (isset($item['funcionario_nome']) && isset($item['modulo_nome'])) {
                $funcionario = $item['funcionario_nome'];
                if (!isset($funcionariosAgrupados[$funcionario])) {
                    $funcionariosAgrupados[$funcionario] = [];
                }
                $funcionariosAgrupados[$funcionario][] = $item['modulo_nome'];
            }
        }
        // Converter para formato esperado pelo JavaScript
        $funcionariosFormatados = [];
        foreach ($funcionariosAgrupados as $funcionario => $modulos) {
            $funcionariosFormatados[] = [
                'funcionario' => $funcionario,
                'modulos' => $modulos
            ];
        }
        ?>
        funcionariosComModulos = <?= json_encode($funcionariosFormatados) ?>;
    <?php endif; ?>

    // Mostrar/ocultar campos condicionais por tipo de atendimento
    function toggleCamposPorTipo() {
        const tipoAtendimento = $('#tipo_atendimento').val();

        // Ocultar todos os campos condicionais primeiro
        $('#campos-implantacao').hide();
        $('#campos-visita-comercial').hide();

        // Mostrar campos conforme o tipo selecionado
        if (tipoAtendimento === 'implantacao') {
            $('#campos-implantacao').show();
        } else if (tipoAtendimento === 'visita_comercial') {
            $('#campos-visita-comercial').show();
        }
    }

    // ============================================
    // AUTOCOMPLETE DE CLIENTE (igual ao módulo de vendas)
    // ============================================
    let clientesData = [];
    let selectedCustomer = null;
    let autocompleteTimeout = null;

    function inicializarAutocompleteCliente() {
        const $search = $('#cliente_search');
        const $dropdown = $('#cliente_dropdown');

        // Carregar todos os clientes ao iniciar
        carregarTodosClientes();

        // Ao digitar
        $search.on('input', function () {
            const query = $(this).val().trim().toLowerCase();

            clearTimeout(autocompleteTimeout);

            if (query.length < 2) {
                $dropdown.hide();
                return;
            }

            autocompleteTimeout = setTimeout(() => {
                buscarClientes(query);
            }, 300);
        });

        // Ao clicar fora, fechar dropdown
        $(document).on('click', function (e) {
            if (!$(e.target).closest('#cliente_search, #cliente_dropdown, #cliente_search + button').length) {
                $dropdown.hide();
            }
        });

        // Ao focar no campo
        $search.on('focus', function () {
            if ($(this).val().length >= 2) {
                buscarClientes($(this).val().trim().toLowerCase());
            }
        });

        // Ao perder o foco (blur)
        $search.on('blur', function () {
            // Manter comportamento similar ao módulo de vendas
        });

        // Ao pressionar Enter, apenas prevenir submit
        $search.on('keydown', function (e) {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });

        // Carregar cliente existente se estiver editando
        <?php if ($isEdit && !empty($agendamento['cliente_id'])): ?>
            // Aguardar carregar clientes antes de selecionar
            setTimeout(() => {
                const clienteInicial = clientesData.find(c => c.id == <?= $agendamento['cliente_id'] ?>);
                if (clienteInicial) {
                    selecionarCliente(clienteInicial);
                }
            }, 500);
        <?php endif; ?>
    }

    function carregarTodosClientes() {
        $.ajax({
            url: appUrl('/agenda-tecnica/buscar-clientes'),
            method: 'GET',
            data: { q: '' },
            dataType: 'json',
            success: function (response) {
                if (response.success && response.data && response.data.clientes) {
                    clientesData = response.data.clientes;
                } else {
                    clientesData = [];
                }
            },
            error: function (xhr, status, error) {
                console.error('Erro ao carregar clientes:', error);
                clientesData = [];
            }
        });
    }

    function buscarClientes(query) {
        const $dropdown = $('#cliente_dropdown');

        // Filtrar clientes
        const results = clientesData.filter(cliente => {
            const name = (cliente.name || '').toLowerCase();
            const tradeName = (cliente.trade_name || '').toLowerCase();
            const document = (cliente.document || '').toLowerCase();
            const email = (cliente.email || '').toLowerCase();
            const phone = (cliente.phone || '').toLowerCase();
            const mobile = (cliente.mobile || '').toLowerCase();

            const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
            const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

            return name.includes(query) || tradeName.includes(query) ||
                document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
                email.includes(query) || phone.includes(query) || mobile.includes(query);
        });

        // Montar HTML
        let html = '';

        if (results.length > 0) {
            results.forEach(cliente => {
                const nomeFantasia = cliente.trade_name || '-';
                const razaoSocial = cliente.name || '-';
                const documento = cliente.document || 'Não informado';
                const codigo = String(cliente.id).padStart(4, '0');
                const telefone = cliente.phone || cliente.mobile || '-';
                const email = cliente.email || '-';

                html += `
                <div class="autocomplete-item" data-id="${cliente.id}">
                    <div class="mb-1">
                        <strong>Código: ${codigo}</strong>  |  <strong>CNPJ/CPF:</strong> ${documento}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                    </div>
                    <div class="text-muted small">
                        <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                    </div>
                </div>
            `;
            });
        } else {
            html = '<div class="autocomplete-no-results">Nenhum cliente encontrado</div>';
        }

        $dropdown.html(html).show();

        // Event listeners
        $dropdown.find('.autocomplete-item').on('click', function () {
            const clienteId = $(this).data('id');
            const cliente = clientesData.find(c => c.id == clienteId);
            if (cliente) {
                selecionarCliente(cliente);
            }
        });
    }

    function selecionarCliente(cliente) {
        selectedCustomer = cliente;

        const nomeFantasia = cliente.trade_name || '-';
        const razaoSocial = cliente.name || '-';
        const nomeExibir = nomeFantasia !== '-' ? nomeFantasia : razaoSocial;
        const codigo = String(cliente.id).padStart(4, '0');
        const documento = cliente.document || 'Não informado';
        const telefone = cliente.phone || cliente.mobile || '-';
        const email = cliente.email || '-';

        // Preencher campos hidden
        $('#cliente_id').val(cliente.id);
        $('#cliente_name').val(razaoSocial);

        // Atualizar campo de busca
        $('#cliente_search').val(nomeExibir);

        // Mostrar info do cliente no formato estruturado (igual ao módulo de vendas)
        let infoHtml = `
        <div style="line-height: 1.6;">
            <div class="mb-1">
                <strong>Código: ${codigo}</strong>  |  ${documento}
            </div>
            <div class="mb-1">
                <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
            </div>
            <div class="text-muted small">
                <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
            </div>
        </div>
    `;

        $('#cliente_info_content').html(infoHtml);
        $('#cliente_info').slideDown();

        // Fechar dropdown
        $('#cliente_dropdown').hide();
    }

    function limparCliente() {
        selectedCustomer = null;
        $('#cliente_id').val('');
        $('#cliente_name').val('');
        $('#cliente_search').val('');
        $('#cliente_info').slideUp();
    }

    // Modal para cadastrar novo cliente
    function abrirModalNovoCliente() {
        Swal.fire({
            title: 'Cadastrar Novo Cliente',
            html: `
                <form id="formNovoCliente">
                    <div class="mb-3">
                        <label class="form-label">Nome/Razão Social *</label>
                        <input type="text" class="form-control" id="novo_cliente_name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nome Fantasia</label>
                        <input type="text" class="form-control" id="novo_cliente_trade_name">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">CNPJ/CPF</label>
                        <input type="text" class="form-control" id="novo_cliente_document">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" class="form-control" id="novo_cliente_email">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Telefone</label>
                        <input type="text" class="form-control" id="novo_cliente_phone">
                    </div>
                </form>
            `,
            showCancelButton: true,
            confirmButtonText: 'Salvar',
            cancelButtonText: 'Cancelar',
            confirmButtonColor: '#001122',
            width: '600px',
            didOpen: () => {
                // Focar no primeiro campo
                $('#novo_cliente_name').focus();
            },
            preConfirm: () => {
                const nome = $('#novo_cliente_name').val().trim();
                if (!nome) {
                    Swal.showValidationMessage('Nome é obrigatório');
                    return false;
                }

                return {
                    name: nome,
                    trade_name: $('#novo_cliente_trade_name').val().trim(),
                    document: $('#novo_cliente_document').val().trim(),
                    email: $('#novo_cliente_email').val().trim(),
                    phone: $('#novo_cliente_phone').val().trim()
                };
            }
        }).then((result) => {
            if (result.isConfirmed && result.value) {
                // Salvar novo cliente
                $.ajax({
                    url: appUrl('/pessoas/criar'),
                    method: 'POST',
                    data: {
                        name: result.value.name,
                        trade_name: result.value.trade_name,
                        document: result.value.document,
                        email: result.value.email,
                        phone: result.value.phone,
                        tipo_cliente: 1,
                        tipo_fornecedor: 0,
                        tipo_transportadora: 0,
                        person_type: 'juridica',
                        is_active: 1
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success && response.data && response.data.id) {
                            // Recarregar lista de clientes
                            carregarTodosClientes();

                            // Selecionar o novo cliente
                            setTimeout(() => {
                                const novoCliente = {
                                    id: response.data.id,
                                    name: result.value.name,
                                    trade_name: result.value.trade_name,
                                    document: result.value.document,
                                    email: result.value.email,
                                    phone: result.value.phone,
                                    mobile: result.value.phone
                                };
                                clientesData.push(novoCliente);
                                selecionarCliente(novoCliente);
                            }, 500);

                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: 'Cliente cadastrado com sucesso',
                                timer: 1500,
                                showConfirmButton: false
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: response.message || 'Erro ao cadastrar cliente'
                            });
                        }
                    },
                    error: function (xhr) {
                        const response = xhr.responseJSON;
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response?.message || 'Erro ao cadastrar cliente'
                        });
                    }
                });
            }
        });
    }


    // Eventos
    $(document).ready(function () {
        // Verificar tipo ao carregar
        toggleCamposPorTipo();

        // Monitorar mudança no tipo de atendimento
        $('#tipo_atendimento').on('change', toggleCamposPorTipo);

        // Inicializar tabela de funcionários
        atualizarTabelaFuncionarios();

        // Funcionalidade de funcionários treinados
        $('#btn-adicionar-funcionario').on('click', adicionarFuncionario);
        $('#novo_funcionario').on('keypress', function (e) {
            if (e.which === 13) { // Enter
                e.preventDefault();
                adicionarFuncionario();
            }
        });

        // Inicializar tabela de funcionários
        atualizarTabelaFuncionarios();

        // Inicializar autocomplete de cliente
        inicializarAutocompleteCliente();
    });

    // Adicionar funcionário à tabela
    function adicionarFuncionario() {
        const nome = $('#novo_funcionario').val().trim();
        if (!nome) {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                text: 'Informe o nome do funcionário',
                timer: 2000,
                showConfirmButton: false
            });
            return;
        }

        // Verificar se já existe
        if (funcionariosComModulos.some(f => f.funcionario === nome)) {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                text: 'Este funcionário já foi adicionado',
                timer: 2000,
                showConfirmButton: false
            });
            return;
        }

        funcionariosComModulos.push({
            funcionario: nome,
            modulos: []
        });

        $('#novo_funcionario').val('');
        atualizarTabelaFuncionarios();
    }

    // Remover funcionário da tabela
    function removerFuncionario(index) {
        funcionariosComModulos.splice(index, 1);
        atualizarTabelaFuncionarios();
    }

    // Selecionar módulos para um funcionário específico
    function selecionarModulosFuncionario(index) {
        const funcionario = funcionariosComModulos[index];
        const modulosAtuais = funcionario.modulos || [];

        let htmlCheckboxes = '';
        modulosDisponiveis.forEach(modulo => {
            const checked = modulosAtuais.includes(modulo) ? 'checked' : '';
            htmlCheckboxes += `
            <div class="form-check form-switch mb-3 p-3 border rounded" style="background: #f8f9fa; transition: all 0.2s;">
                <input class="form-check-input" type="checkbox" role="switch" value="${modulo}"
                    id="modulo_${index}_${modulo.replace(/\s+/g, '_')}" ${checked}
                    style="width: 3em; height: 1.5em; cursor: pointer;">
                <label class="form-check-label ms-3" for="modulo_${index}_${modulo.replace(/\s+/g, '_')}"
                    style="cursor: pointer; font-weight: 500; font-size: 1rem;">
                    ${modulo}
                </label>
            </div>
        `;
        });

        Swal.fire({
            title: `Módulos - ${funcionario.funcionario}`,
            html: `
            <div id="modulos-container-${index}" style="max-height: 400px; overflow-y: auto; text-align: left; padding: 1rem;">
                ${htmlCheckboxes}
            </div>
        `,
            showCancelButton: true,
            confirmButtonText: 'Confirmar',
            cancelButtonText: 'Cancelar',
            confirmButtonColor: '#001122',
            width: '500px',
            preConfirm: () => {
                const checkboxes = document.querySelectorAll(`#modulos-container-${index} .form-check-input:checked`);
                const selecionados = [];
                checkboxes.forEach(checkbox => {
                    selecionados.push(checkbox.value);
                });
                funcionariosComModulos[index].modulos = selecionados;
                atualizarTabelaFuncionarios();
                return true;
            }
        });
    }

    // Atualizar tabela de funcionários
    function atualizarTabelaFuncionarios() {
        const tbody = $('#tbody-funcionarios');
        tbody.empty();

        if (funcionariosComModulos.length === 0) {
            tbody.append('<tr><td colspan="3" class="text-center text-muted">Nenhum funcionário adicionado</td></tr>');
        } else {
            funcionariosComModulos.forEach((item, index) => {
                const modulosHtml = item.modulos && item.modulos.length > 0
                    ? item.modulos.map(m => `<span class="badge bg-primary me-1">${m}</span>`).join('')
                    : '<span class="text-muted">Nenhum módulo selecionado</span>';

                tbody.append(`
                <tr>
                    <td><strong>${item.funcionario}</strong></td>
                    <td>${modulosHtml}</td>
                    <td class="text-center">
                        <button type="button" class="btn btn-sm btn-outline-primary me-1" onclick="selecionarModulosFuncionario(${index})" title="Selecionar Módulos">
                            <i class="bi bi-list-check"></i>
                        </button>
                        <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerFuncionario(${index})" title="Remover">
                            <i class="bi bi-trash"></i>
                        </button>
                    </td>
                </tr>
            `);
            });
        }

        // Salvar no formato: [{funcionario: "Maria", modulos: ["Vendas", "Compras"]}, ...]
        $('#funcionarios_modulos_json').val(JSON.stringify(funcionariosComModulos));
    }

    $('#formAgendamento').on('submit', function (e) {
        e.preventDefault();

        Swal.fire({
            title: 'Processando...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        const formData = new FormData(this);

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message || 'Agendamento salvo com sucesso',
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = appUrl(response.data?.redirect || response.redirect || '/agenda-tecnica');
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message || 'Erro ao salvar agendamento'
                    });
                }
            },
            error: function (xhr) {
                const response = xhr.responseJSON;
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: response?.message || 'Erro ao salvar agendamento'
                });
            }
        });
    });
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'agenda-tecnica';
include ROOT_PATH . '/views/layouts/app.php';
?>