<?php

declare(strict_types=1);

namespace App\Middleware;

use App\Core\Request;
use App\Core\Response;
use App\Core\Session;

/**
 * Middleware de Autenticação
 * Verifica se o usuário está autenticado
 */
class AuthMiddleware
{
    private Session $session;

    public function __construct()
    {
        $config = require \ROOT_PATH . '/config/app.php';
        $this->session = new Session($config['session']);
    }

    /**
     * Processa a requisição
     */
    public function handle(Request $request, Response $response): bool
    {
        // Log para debug
        error_log("[AuthMiddleware] Verificando autenticação - Session ID: " . session_id());
        error_log("[AuthMiddleware] user_id na sessão: " . ($this->session->get('user_id') ?? 'NULL'));
        error_log("[AuthMiddleware] isAuthenticated: " . ($this->session->isAuthenticated() ? 'SIM' : 'NÃO'));

        if (!$this->session->isAuthenticated()) {
            // Se for requisição AJAX, retorna erro JSON
            if ($request->isAjax() || $request->isJson()) {
                $response->unauthorized('Você precisa estar autenticado');
                return false;
            }

            // Redireciona para login
            $response->redirect(\App\Helpers\UrlHelper::url('/login'));
            return false;
        }

        return true;
    }
}

