<?php
// Status do servidor
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

// Verificar se os arquivos essenciais existem
$essentialFiles = [
    'index.php' => file_exists(__DIR__ . '/index.php'),
    'api_router.php' => file_exists(__DIR__ . '/api_router.php'),
    'src/Core/Router.php' => file_exists(__DIR__ . '/src/Core/Router.php'),
    'src/Controllers/NFeController.php' => file_exists(__DIR__ . '/src/Controllers/NFeController.php'),
    'src/Services/NFeService.php' => file_exists(__DIR__ . '/src/Services/NFeService.php'),
    'config_producao.php' => file_exists(__DIR__ . '/config_producao.php'),
    '.htaccess' => file_exists(__DIR__ . '/.htaccess')
];

// Verificar se todos os arquivos essenciais existem
$allFilesExist = !in_array(false, $essentialFiles);

// Verificar se o certificado existe (opcional)
$certificadoExists = file_exists(__DIR__ . '/certificados/certificado.pfx');

// Verificar se estamos em ambiente de desenvolvimento
$isDevelopment = !$certificadoExists || strpos($_SERVER['HTTP_HOST'] ?? '', 'localhost') !== false;

// Simular verificação de conectividade SEFAZ
// Em desenvolvimento: sempre conectado se os arquivos existem
// Em produção: só conectado se certificado existe
$sefazConectado = $allFilesExist && ($isDevelopment || $certificadoExists);

$status = [
    'status' => $allFilesExist ? 'online' : 'offline',
    'sefaz' => $sefazConectado ? 'conectado' : 'desconectado',
    'message' => $allFilesExist ? 'Sistema funcionando normalmente' : 'Arquivos essenciais não encontrados',
    'timestamp' => date('Y-m-d H:i:s'),
    'php_version' => PHP_VERSION,
    'environment' => [
        'all_files_exist' => $allFilesExist,
        'certificado_exists' => $certificadoExists,
        'sefaz_ready' => $sefazConectado
    ],
    'files' => $essentialFiles,
    'server_info' => [
        'REQUEST_URI' => $_SERVER['REQUEST_URI'] ?? 'N/A',
        'SCRIPT_NAME' => $_SERVER['SCRIPT_NAME'] ?? 'N/A',
        'REQUEST_METHOD' => $_SERVER['REQUEST_METHOD'] ?? 'N/A',
        'HTTP_HOST' => $_SERVER['HTTP_HOST'] ?? 'N/A',
        'SERVER_NAME' => $_SERVER['SERVER_NAME'] ?? 'N/A'
    ]
];

echo json_encode($status, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
