<?php

namespace App\Models;

use App\Core\Database;

class Produto
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getInstance();
    }

    public function criar($dados)
    {
        $sql = "INSERT INTO produtos (
            empresa_id, codigo, descricao, ncm, cfop, unidade_comercial,
            quantidade_comercial, valor_unitario, valor_total,
            valor_desconto, valor_frete, valor_seguro, valor_outros,
            created_at, updated_at
        ) VALUES (
            :empresa_id, :codigo, :descricao, :ncm, :cfop, :unidade_comercial,
            :quantidade_comercial, :valor_unitario, :valor_total,
            :valor_desconto, :valor_frete, :valor_seguro, :valor_outros,
            NOW(), NOW()
        )";

        $params = [
            ':empresa_id' => $dados['empresa_id'],
            ':codigo' => $dados['codigo'],
            ':descricao' => $dados['descricao'],
            ':ncm' => $dados['ncm'],
            ':cfop' => $dados['cfop'],
            ':unidade_comercial' => $dados['unidade_comercial'],
            ':quantidade_comercial' => $dados['quantidade_comercial'],
            ':valor_unitario' => $dados['valor_unitario'],
            ':valor_total' => $dados['valor_total'],
            ':valor_desconto' => $dados['valor_desconto'] ?? 0,
            ':valor_frete' => $dados['valor_frete'] ?? 0,
            ':valor_seguro' => $dados['valor_seguro'] ?? 0,
            ':valor_outros' => $dados['valor_outros'] ?? 0
        ];

        $this->db->query($sql, $params);
        return $this->db->getConnection()->lastInsertId();
    }

    public function buscar($id)
    {
        $sql = "SELECT p.*, e.nome as empresa_nome
                FROM produtos p
                LEFT JOIN empresas e ON p.empresa_id = e.id
                WHERE p.id = :id";
        $stmt = $this->db->query($sql, [':id' => $id]);
        return $stmt->fetch();
    }

    public function atualizar($id, $dados)
    {
        $sql = "UPDATE produtos SET
            empresa_id = :empresa_id, codigo = :codigo, descricao = :descricao,
            ncm = :ncm, cfop = :cfop, unidade_comercial = :unidade_comercial,
            quantidade_comercial = :quantidade_comercial, valor_unitario = :valor_unitario,
            valor_total = :valor_total, valor_desconto = :valor_desconto,
            valor_frete = :valor_frete, valor_seguro = :valor_seguro,
            valor_outros = :valor_outros, updated_at = NOW()
            WHERE id = :id";

        $params = [
            ':id' => $id,
            ':empresa_id' => $dados['empresa_id'],
            ':codigo' => $dados['codigo'],
            ':descricao' => $dados['descricao'],
            ':ncm' => $dados['ncm'],
            ':cfop' => $dados['cfop'],
            ':unidade_comercial' => $dados['unidade_comercial'],
            ':quantidade_comercial' => $dados['quantidade_comercial'],
            ':valor_unitario' => $dados['valor_unitario'],
            ':valor_total' => $dados['valor_total'],
            ':valor_desconto' => $dados['valor_desconto'] ?? 0,
            ':valor_frete' => $dados['valor_frete'] ?? 0,
            ':valor_seguro' => $dados['valor_seguro'] ?? 0,
            ':valor_outros' => $dados['valor_outros'] ?? 0
        ];

        return $this->db->query($sql, $params);
    }

    public function listar($empresa_id = null)
    {
        if ($empresa_id) {
            $sql = "SELECT p.*, e.nome as empresa_nome
                    FROM produtos p
                    LEFT JOIN empresas e ON p.empresa_id = e.id
                    WHERE p.empresa_id = :empresa_id
                    ORDER BY p.descricao";
            $stmt = $this->db->query($sql, [':empresa_id' => $empresa_id]);
        } else {
            $sql = "SELECT p.*, e.nome as empresa_nome
                    FROM produtos p
                    LEFT JOIN empresas e ON p.empresa_id = e.id
                    ORDER BY p.descricao";
            $stmt = $this->db->query($sql);
        }

        return $stmt->fetchAll();
    }

    public function buscarPorCodigo($codigo, $empresa_id)
    {
        $sql = "SELECT * FROM produtos WHERE codigo = :codigo AND empresa_id = :empresa_id";
        $stmt = $this->db->query($sql, [':codigo' => $codigo, ':empresa_id' => $empresa_id]);
        return $stmt->fetch();
    }
}
