<?php

namespace App\Models;

use App\Core\Database;

class Empresa
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getInstance();
    }

    public function criar($dados)
    {
        $sql = "INSERT INTO empresas (
            nome, cnpj, inscricao_estadual, inscricao_municipal, email,
            telefone, endereco, numero, bairro, cidade, estado, cep,
            serie_nfe, numero_nfe, ambiente_nfe, regime_tributario,
            path_certificado, senha_certificado, path_logo, created_at, updated_at
        ) VALUES (
            :nome, :cnpj, :inscricao_estadual, :inscricao_municipal, :email,
            :telefone, :endereco, :numero, :bairro, :cidade, :estado, :cep,
            :serie_nfe, :numero_nfe, :ambiente_nfe, :regime_tributario,
            :path_certificado, :senha_certificado, :path_logo, NOW(), NOW()
        )";

        $params = [
            ':nome' => $dados['nome'],
            ':cnpj' => $dados['cnpj'],
            ':inscricao_estadual' => $dados['inscricao_estadual'],
            ':inscricao_municipal' => $dados['inscricao_municipal'],
            ':email' => $dados['email'],
            ':telefone' => $dados['telefone'],
            ':endereco' => $dados['endereco'],
            ':numero' => $dados['numero'],
            ':bairro' => $dados['bairro'],
            ':cidade' => $dados['cidade'],
            ':estado' => $dados['estado'],
            ':cep' => $dados['cep'],
            ':serie_nfe' => $dados['serie_nfe'],
            ':numero_nfe' => $dados['numero_nfe'],
            ':ambiente_nfe' => $dados['ambiente_nfe'],
            ':regime_tributario' => $dados['regime_tributario'],
            ':path_certificado' => $dados['path_certificado'],
            ':senha_certificado' => $dados['senha_certificado'],
            ':path_logo' => $dados['path_logo'] ?? null
        ];

        $this->db->query($sql, $params);
        return $this->db->getConnection()->lastInsertId();
    }

    public function buscar($id)
    {
        $sql = "SELECT * FROM empresas WHERE id = :id";
        $stmt = $this->db->query($sql, [':id' => $id]);
        return $stmt->fetch();
    }

    public function atualizar($id, $dados)
    {
        $sql = "UPDATE empresas SET
            nome = :nome, cnpj = :cnpj, inscricao_estadual = :inscricao_estadual,
            inscricao_municipal = :inscricao_municipal, email = :email,
            telefone = :telefone, endereco = :endereco, numero = :numero,
            bairro = :bairro, cidade = :cidade, estado = :estado, cep = :cep,
            serie_nfe = :serie_nfe, numero_nfe = :numero_nfe, ambiente_nfe = :ambiente_nfe,
            regime_tributario = :regime_tributario, path_certificado = :path_certificado,
            senha_certificado = :senha_certificado, path_logo = :path_logo, updated_at = NOW()
            WHERE id = :id";

        $params = [
            ':id' => $id,
            ':nome' => $dados['nome'],
            ':cnpj' => $dados['cnpj'],
            ':inscricao_estadual' => $dados['inscricao_estadual'],
            ':inscricao_municipal' => $dados['inscricao_municipal'],
            ':email' => $dados['email'],
            ':telefone' => $dados['telefone'],
            ':endereco' => $dados['endereco'],
            ':numero' => $dados['numero'],
            ':bairro' => $dados['bairro'],
            ':cidade' => $dados['cidade'],
            ':estado' => $dados['estado'],
            ':cep' => $dados['cep'],
            ':serie_nfe' => $dados['serie_nfe'],
            ':numero_nfe' => $dados['numero_nfe'],
            ':ambiente_nfe' => $dados['ambiente_nfe'],
            ':regime_tributario' => $dados['regime_tributario'],
            ':path_certificado' => $dados['path_certificado'],
            ':senha_certificado' => $dados['senha_certificado'],
            ':path_logo' => $dados['path_logo'] ?? null
        ];

        return $this->db->query($sql, $params);
    }

    public function listar()
    {
        $sql = "SELECT * FROM empresas ORDER BY nome";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll();
    }

    public function buscarPorCnpj($cnpj)
    {
        $sql = "SELECT * FROM empresas WHERE cnpj = :cnpj";
        $stmt = $this->db->query($sql, [':cnpj' => $cnpj]);
        return $stmt->fetch();
    }
}
