<?php

namespace App\Models;

use App\Core\Database;

class Cliente
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getInstance();
    }

    public function criar($dados)
    {
        $sql = "INSERT INTO clientes (
            empresa_id, nome, cnpj, cpf, email, telefone, endereco,
            cidade, estado, cep, inscricao_estadual, created_at, updated_at
        ) VALUES (
            :empresa_id, :nome, :cnpj, :cpf, :email, :telefone, :endereco,
            :cidade, :estado, :cep, :inscricao_estadual, NOW(), NOW()
        )";

        $params = [
            ':empresa_id' => $dados['empresa_id'],
            ':nome' => $dados['nome'],
            ':cnpj' => $dados['cnpj'] ?? null,
            ':cpf' => $dados['cpf'] ?? null,
            ':email' => $dados['email'],
            ':telefone' => $dados['telefone'],
            ':endereco' => $dados['endereco'],
            ':cidade' => $dados['cidade'],
            ':estado' => $dados['estado'],
            ':cep' => $dados['cep'],
            ':inscricao_estadual' => $dados['inscricao_estadual'] ?? null
        ];

        $this->db->query($sql, $params);
        return $this->db->getConnection()->lastInsertId();
    }

    public function buscar($id)
    {
        $sql = "SELECT c.*, e.nome as empresa_nome
                FROM clientes c
                LEFT JOIN empresas e ON c.empresa_id = e.id
                WHERE c.id = :id";
        $stmt = $this->db->query($sql, [':id' => $id]);
        return $stmt->fetch();
    }

    public function atualizar($id, $dados)
    {
        $sql = "UPDATE clientes SET
            empresa_id = :empresa_id, nome = :nome, cnpj = :cnpj, cpf = :cpf,
            email = :email, telefone = :telefone, endereco = :endereco,
            cidade = :cidade, estado = :estado, cep = :cep,
            inscricao_estadual = :inscricao_estadual, updated_at = NOW()
            WHERE id = :id";

        $params = [
            ':id' => $id,
            ':empresa_id' => $dados['empresa_id'],
            ':nome' => $dados['nome'],
            ':cnpj' => $dados['cnpj'] ?? null,
            ':cpf' => $dados['cpf'] ?? null,
            ':email' => $dados['email'],
            ':telefone' => $dados['telefone'],
            ':endereco' => $dados['endereco'],
            ':cidade' => $dados['cidade'],
            ':estado' => $dados['estado'],
            ':cep' => $dados['cep'],
            ':inscricao_estadual' => $dados['inscricao_estadual'] ?? null
        ];

        return $this->db->query($sql, $params);
    }

    public function listar($empresa_id = null)
    {
        if ($empresa_id) {
            $sql = "SELECT c.*, e.nome as empresa_nome
                    FROM clientes c
                    LEFT JOIN empresas e ON c.empresa_id = e.id
                    WHERE c.empresa_id = :empresa_id
                    ORDER BY c.nome";
            $stmt = $this->db->query($sql, [':empresa_id' => $empresa_id]);
        } else {
            $sql = "SELECT c.*, e.nome as empresa_nome
                    FROM clientes c
                    LEFT JOIN empresas e ON c.empresa_id = e.id
                    ORDER BY c.nome";
            $stmt = $this->db->query($sql);
        }

        return $stmt->fetchAll();
    }

    public function buscarPorCnpj($cnpj)
    {
        $sql = "SELECT * FROM clientes WHERE cnpj = :cnpj";
        $stmt = $this->db->query($sql, [':cnpj' => $cnpj]);
        return $stmt->fetch();
    }

    public function buscarPorCpf($cpf)
    {
        $sql = "SELECT * FROM clientes WHERE cpf = :cpf";
        $stmt = $this->db->query($sql, [':cpf' => $cpf]);
        return $stmt->fetch();
    }
}