<?php

namespace App\Core;

class Cors
{
    private static $allowedOrigins = [
        'http://localhost:3000',
        'http://localhost:8080',
        'http://127.0.0.1:3000',
        'http://127.0.0.1:8080',
        'https://app.terceiros.com',
        'https://terceiros.com',
        // Adicione aqui os domínios de produção quando necessário
        // 'https://seudominio.com',
        // 'https://app.seudominio.com'
    ];

    private static $allowedMethods = [
        'GET',
        'POST',
        'PUT',
        'DELETE',
        'OPTIONS'
    ];

    private static $allowedHeaders = [
        'Content-Type',
        'Authorization',
        'X-Requested-With',
        'Accept',
        'Origin',
        'Access-Control-Request-Method',
        'Access-Control-Request-Headers'
    ];

    /**
     * Configura headers CORS para todas as requisições
     */
    public static function setHeaders()
    {
        $origin = $_SERVER['HTTP_ORIGIN'] ?? '';

        // Verificar se a origem é permitida
        if (in_array($origin, self::$allowedOrigins)) {
            header("Access-Control-Allow-Origin: {$origin}");
        } else {
            // Se não está na lista, usar * para permitir qualquer origem
            // (incluindo apps locais fazendo integração com API de produção)
            header('Access-Control-Allow-Origin: *');
        }

        header('Access-Control-Allow-Methods: ' . implode(', ', self::$allowedMethods));
        header('Access-Control-Allow-Headers: ' . implode(', ', self::$allowedHeaders));
        // header('Access-Control-Allow-Credentials: true'); // Comentado para permitir uso do *
        header('Access-Control-Max-Age: 86400'); // 24 horas
    }

    /**
     * Trata requisições OPTIONS (preflight)
     */
    public static function handlePreflight()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
            self::setHeaders();
            http_response_code(200);
            exit;
        }
    }

    /**
     * Verifica se está em ambiente de desenvolvimento
     */
    private static function isDevelopment()
    {
        return in_array($_SERVER['HTTP_HOST'] ?? '', [
            'localhost',
            '127.0.0.1',
            'localhost:8080',
            '127.0.0.1:8080',
            'localhost:3000',
            '127.0.0.1:3000'
        ]) || (isset($_SERVER['SERVER_NAME']) && strpos($_SERVER['SERVER_NAME'], 'localhost') !== false);
    }

    /**
     * Adiciona origem permitida dinamicamente
     */
    public static function addAllowedOrigin($origin)
    {
        if (!in_array($origin, self::$allowedOrigins)) {
            self::$allowedOrigins[] = $origin;
        }
    }

    /**
     * Remove origem permitida
     */
    public static function removeAllowedOrigin($origin)
    {
        $key = array_search($origin, self::$allowedOrigins);
        if ($key !== false) {
            unset(self::$allowedOrigins[$key]);
        }
    }
}
