<?php

namespace App\Core;

class BaseController
{
    /**
     * Envia resposta com CORS e status code
     */
    protected function sendResponse($statusCode, $data)
    {
        Cors::setHeaders();
        http_response_code($statusCode);
        header('Content-Type: application/json');
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        exit;
    }

    /**
     * Envia resposta de erro
     */
    protected function sendError($statusCode, $message, $details = null)
    {
        $response = ['error' => $message];
        if ($details) {
            $response['details'] = $details;
        }
        $this->sendResponse($statusCode, $response);
    }

    /**
     * Envia resposta de sucesso
     */
    protected function sendSuccess($data, $statusCode = 200)
    {
        $this->sendResponse($statusCode, $data);
    }
}
