<?php

namespace App\Controllers;

use App\Models\Produto;

class ProdutoController
{
    private $produto;

    public function __construct()
    {
        $this->produto = new Produto();
    }

    public function criar()
    {
        $dados = json_decode(file_get_contents('php://input'), true);

        if (!$dados) {
            http_response_code(400);
            return ['error' => 'Dados inválidos'];
        }

        try {
            $id = $this->produto->criar($dados);
            return ['success' => true, 'id' => $id, 'message' => 'Produto criado com sucesso'];
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }

    public function buscar($params)
    {
        $id = $params['id'] ?? null;

        if (!$id) {
            http_response_code(400);
            return ['error' => 'ID do produto é obrigatório'];
        }

        try {
            $produto = $this->produto->buscar($id);

            if (!$produto) {
                http_response_code(404);
                return ['error' => 'Produto não encontrado'];
            }

            return $produto;
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }

    public function atualizar($params)
    {
        $id = $params['id'] ?? null;
        $dados = json_decode(file_get_contents('php://input'), true);

        if (!$id || !$dados) {
            http_response_code(400);
            return ['error' => 'ID do produto e dados são obrigatórios'];
        }

        try {
            $this->produto->atualizar($id, $dados);
            return ['success' => true, 'message' => 'Produto atualizado com sucesso'];
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }

    public function listar()
    {
        $empresa_id = $_GET['empresa_id'] ?? null;

        try {
            $produtos = $this->produto->listar($empresa_id);
            return $produtos;
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }
}
