<?php

namespace App\Controllers;

use App\Models\Empresa;

class EmpresaController
{
    private $empresa;

    public function __construct()
    {
        $this->empresa = new Empresa();
    }

    public function criar()
    {
        $dados = json_decode(file_get_contents('php://input'), true);

        if (!$dados) {
            http_response_code(400);
            return ['error' => 'Dados inválidos'];
        }

        try {
            $id = $this->empresa->criar($dados);
            return ['success' => true, 'id' => $id, 'message' => 'Empresa criada com sucesso'];
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }

    public function buscar($params)
    {
        $id = $params['id'] ?? null;

        if (!$id) {
            http_response_code(400);
            return ['error' => 'ID da empresa é obrigatório'];
        }

        try {
            $empresa = $this->empresa->buscar($id);

            if (!$empresa) {
                http_response_code(404);
                return ['error' => 'Empresa não encontrada'];
            }

            return $empresa;
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }

    public function atualizar($params)
    {
        $id = $params['id'] ?? null;
        $dados = json_decode(file_get_contents('php://input'), true);

        if (!$id || !$dados) {
            http_response_code(400);
            return ['error' => 'ID da empresa e dados são obrigatórios'];
        }

        try {
            $this->empresa->atualizar($id, $dados);
            return ['success' => true, 'message' => 'Empresa atualizada com sucesso'];
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }

    public function listar()
    {
        try {
            $empresas = $this->empresa->listar();
            return $empresas;
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }
}
