<?php

namespace App\Controllers;

use App\Models\Cliente;

class ClienteController
{
    private $cliente;

    public function __construct()
    {
        $this->cliente = new Cliente();
    }

    public function criar()
    {
        $dados = json_decode(file_get_contents('php://input'), true);

        if (!$dados) {
            http_response_code(400);
            return ['error' => 'Dados inválidos'];
        }

        try {
            $id = $this->cliente->criar($dados);
            return ['success' => true, 'id' => $id, 'message' => 'Cliente criado com sucesso'];
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }

    public function buscar($params)
    {
        $id = $params['id'] ?? null;

        if (!$id) {
            http_response_code(400);
            return ['error' => 'ID do cliente é obrigatório'];
        }

        try {
            $cliente = $this->cliente->buscar($id);

            if (!$cliente) {
                http_response_code(404);
                return ['error' => 'Cliente não encontrado'];
            }

            return $cliente;
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }

    public function atualizar($params)
    {
        $id = $params['id'] ?? null;
        $dados = json_decode(file_get_contents('php://input'), true);

        if (!$id || !$dados) {
            http_response_code(400);
            return ['error' => 'ID do cliente e dados são obrigatórios'];
        }

        try {
            $this->cliente->atualizar($id, $dados);
            return ['success' => true, 'message' => 'Cliente atualizado com sucesso'];
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }

    public function listar()
    {
        $empresa_id = $_GET['empresa_id'] ?? null;

        try {
            $clientes = $this->cliente->listar($empresa_id);
            return $clientes;
        } catch (\Exception $e) {
            http_response_code(500);
            return ['error' => $e->getMessage()];
        }
    }
}
