<?php

/**
 * Index principal - Redireciona para página inicial ou API
 */

// Verificar se é uma requisição de API (tem /api/ na URL)
$requestUri = $_SERVER['REQUEST_URI'] ?? '';
$isApiRequest = strpos($requestUri, '/api/') !== false ||
                strpos($requestUri, '/status.php') !== false ||
                (isset($_SERVER['HTTP_ACCEPT']) && strpos($_SERVER['HTTP_ACCEPT'], 'application/json') !== false) ||
                (isset($_SERVER['CONTENT_TYPE']) && strpos($_SERVER['CONTENT_TYPE'], 'application/json') !== false);

if ($isApiRequest) {
    // Requisição de API - processar normalmente
    require_once __DIR__ . '/api_router.php';
} else {
    // Requisição para página inicial - mostrar HTML
    header('Content-Type: text/html; charset=utf-8');
    readfile(__DIR__ . '/index.html');
    exit;
}
