<?php
/**
 * Script para corrigir o erro de versão PHP do Composer
 * Execute este arquivo no servidor: https://mobbisapp.com.br/pontti_nfe/fix_composer_php_version.php
 */

echo "<h2>Corrigindo Versão PHP do Composer</h2>";
echo "<pre>";

$baseDir = __DIR__;

echo "Diretório: $baseDir\n\n";

// 1. Verificar versão PHP atual
echo "1. Versão PHP do servidor:\n";
echo "   PHP " . phpversion() . "\n\n";

// 2. Verificar composer.json
echo "2. Verificando composer.json:\n";
$composerJsonPath = $baseDir . '/composer.json';
if (file_exists($composerJsonPath)) {
    $composerJson = json_decode(file_get_contents($composerJsonPath), true);
    echo "   Requisito PHP: " . ($composerJson['require']['php'] ?? 'não especificado') . "\n\n";
} else {
    echo "   ✗ composer.json não encontrado!\n\n";
}

// 3. Deletar composer.lock
echo "3. Removendo composer.lock antigo:\n";
$composerLockPath = $baseDir . '/composer.lock';
if (file_exists($composerLockPath)) {
    if (unlink($composerLockPath)) {
        echo "   ✓ composer.lock removido\n\n";
    } else {
        echo "   ✗ Erro ao remover composer.lock\n\n";
    }
} else {
    echo "   ○ composer.lock não existe\n\n";
}

// 4. Instruções
echo "4. Próximos passos:\n";
echo "   Execute via SSH no servidor:\n";
echo "   cd /caminho/do/pontti_nfe\n";
echo "   composer install --ignore-platform-reqs --no-dev\n\n";

echo "5. Ou simplesmente ignore o aviso:\n";
echo "   O aviso do Composer NÃO impede o sistema de funcionar!\n";
echo "   É apenas um aviso, o autoload continua funcionando normalmente.\n\n";

echo "✓ Script executado com sucesso!\n";
echo "</pre>";

