# 📋 Exemplos de JSON para Emissão de NF-e

Esta pasta contém exemplos prontos de JSON para emissão de NF-e via API.

## 📂 Arquivos Disponíveis

### 1. `emissao_pessoa_fisica_cpf.json`
Exemplo de emissão de NF-e para **pessoa física** (CPF com 11 dígitos).

**Características:**
- Cliente é pessoa física (campo `cpf`)
- Não possui Inscrição Estadual
- `indIEDest` automático = `9` (Não Contribuinte)

**Como usar:**
```bash
curl -X POST http://localhost/pontti_nfe/api/nfe/emitir.php \
  -H "Content-Type: application/json" \
  -d @emissao_pessoa_fisica_cpf.json
```

---

### 2. `emissao_pessoa_juridica_cnpj.json`
Exemplo de emissão de NF-e para **pessoa jurídica** (CNPJ com 14 dígitos).

**Características:**
- Cliente é pessoa jurídica (campo `cnpj`)
- Possui Inscrição Estadual
- `indIEDest` automático = `1` (Contribuinte ICMS)

**Como usar:**
```bash
curl -X POST http://localhost/pontti_nfe/api/nfe/emitir.php \
  -H "Content-Type: application/json" \
  -d @emissao_pessoa_juridica_cnpj.json
```

---

### 3. `inutilizacao_nfe.json`
Exemplo de **inutilização de numeração** de NF-e (quebra de sequência).

**Características:**
- Inutiliza números que não foram usados
- Requer justificativa mínima de 15 caracteres
- Pode inutilizar um único número ou faixa

**Quando usar:**
- Emitiu nota 100, depois 102 (precisa inutilizar 101)
- Houve erro no sistema e pulou numeração
- Precisa justificar quebra de sequência

**Como usar:**
```bash
curl -X POST http://localhost/pontti_nfe/api/nfe/inutilizar.php \
  -H "Content-Type: application/json" \
  -d @inutilizacao_nfe.json
```

---

### 4. `carta_correcao_nfe.json`
Exemplo de **Carta de Correção Eletrônica (CC-e)** para corrigir erros em NF-e já autorizada.

**Características:**
- Corrige erros em NF-e autorizada
- Não pode alterar valores ou impostos
- Texto de correção entre 15 e 1000 caracteres
- **IMPORTANTE: Campo `numero_sequencial` é obrigatório**
  - 1ª correção = `1`
  - 2ª correção = `2`
  - 3ª correção = `3`
  - E assim sucessivamente...

**Quando usar:**
- Errou endereço do destinatário
- Errou descrição de produto
- Errou dados cadastrais (sem mudar CPF/CNPJ)
- Precisa adicionar informações complementares

**Como usar:**
```bash
curl -X POST http://localhost/pontti_nfe/api/nfe/carta-correcao.php \
  -H "Content-Type: application/json" \
  -d @carta_correcao_nfe.json
```

**⚠️ Erro 573 (Duplicidade):**
Se receber este erro, significa que já existe uma CC-e com esse `numero_sequencial`.
Incremente o número e tente novamente (ex: se usou 1, use 2).

**📄 Arquivo com comentários:** `carta_correcao_nfe_comentado.json` - Versão com explicações detalhadas.

---

### 5. `cancelamento_nfe.json`
Exemplo de **Cancelamento de NF-e** já autorizada.

**Características:**
- Cancela NF-e autorizada dentro de 24 horas
- Justificativa mínima de 15 caracteres
- Gera XML e PDF do cancelamento automaticamente

**Quando usar:**
- Cliente solicitou cancelamento
- Erro no pedido ou duplicação
- Necessidade de anular a operação

**Requisitos:**
- NF-e deve estar autorizada
- Prazo: até 24h após autorização
- Justificativa válida (mínimo 15 caracteres)

**Como usar:**
```bash
curl -X POST http://localhost/pontti_nfe/api/nfe/cancelar.php \
  -H "Content-Type: application/json" \
  -d @cancelamento_nfe.json
```

**📄 Arquivo com comentários:** `cancelamento_nfe_comentado.json` - Versão com explicações detalhadas.

**📁 Arquivos Gerados:**
- **XML:** `arquivos/{CNPJ}/cancelamento/xml/{ANO}_{MES}/Cancel_{CHAVE}.xml`
- **PDF:** `arquivos/{CNPJ}/cancelamento/pdf/{ANO}_{MES}/Cancel_{CHAVE}.pdf`

---

## 🔍 Diferenças entre CPF e CNPJ

| Campo | Pessoa Física (CPF) | Pessoa Jurídica (CNPJ) |
|-------|---------------------|------------------------|
| Documento | `cpf` (11 dígitos) | `cnpj` (14 dígitos) |
| Inscrição Estadual | **Não informar** | Obrigatório se contribuinte |
| indIEDest | `9` (Não Contribuinte) | `1` (Contribuinte) ou `2` (Isento) |

---

## ⚠️ Observações Importantes

1. **CPF ou CNPJ é obrigatório**: O sistema detecta automaticamente qual usar baseado na quantidade de dígitos:
   - **11 dígitos** = CPF (Pessoa Física)
   - **14 dígitos** = CNPJ (Pessoa Jurídica)

2. **Inscrição Estadual**: Somente para pessoa jurídica contribuinte de ICMS

3. **Validação automática**: O sistema valida e formata automaticamente os documentos

4. **Máscaras**: Pode enviar com ou sem máscara (pontos, traços, barras) - o sistema remove automaticamente

---

## 🧪 Testando os Exemplos

### Usando cURL (Linux/Mac/Windows PowerShell)
```bash
# Pessoa Física
curl -X POST http://localhost/pontti_nfe/api/nfe/emitir.php \
  -H "Content-Type: application/json" \
  -d @emissao_pessoa_fisica_cpf.json

# Pessoa Jurídica
curl -X POST http://localhost/pontti_nfe/api/nfe/emitir.php \
  -H "Content-Type: application/json" \
  -d @emissao_pessoa_juridica_cnpj.json
```

### Usando Postman
1. Método: `POST`
2. URL: `http://localhost/pontti_nfe/api/nfe/emitir.php`
3. Headers: `Content-Type: application/json`
4. Body: Copiar o conteúdo de um dos arquivos JSON

### Usando Insomnia
1. Criar nova requisição
2. Método: `POST`
3. URL: `http://localhost/pontti_nfe/api/nfe/emitir.php`
4. Body: JSON
5. Colar o conteúdo de um dos arquivos

---

## ✅ Resposta Esperada

### Sucesso (200 OK)
```json
{
  "success": true,
  "chave_acesso": "26250910214971090001565500100000001123456789",
  "protocolo": "126250000123456",
  "cStat": "100",
  "xml_path": "/pontti_nfe/arquivos/21497109000156/nfe/xml/2025_10/assinados/...",
  "pdf_path": "/pontti_nfe/arquivos/21497109000156/nfe/pdf/2025_10/emitidos/...",
  "message": "NFe emitida com sucesso"
}
```

### Erro (400/500)
```json
{
  "success": false,
  "error": "Descrição do erro"
}
```

---

**Desenvolvido por [Systhema Tecnologia](https://pontti.com.br)**

