# 📚 Documentação - API de Emissão de NF-e

Bem-vindo à documentação completa da API de emissão de NF-e da Systhema Tecnologia.

---

## 🎯 Início Rápido

Se você é desenvolvedor de terceiros integrando com nossa API, comece por aqui:

### 👉 [GUIA DE INTEGRAÇÃO](GUIA_INTEGRACAO.md)

**Este é o documento principal!** Contém tudo que você precisa para integrar:
- Endpoints disponíveis
- Estrutura de dados (request/response)
- Exemplos de código (PHP, JavaScript, Python, C#)
- Regras de negócio automáticas
- Tratamento de erros
- Boas práticas

---

## 📖 Índice da Documentação

### 1. 📘 [Guia de Integração](GUIA_INTEGRACAO.md)
**Documento principal para desenvolvedores terceiros**
- ✅ Visão geral da API
- ✅ Endpoints e estrutura de dados
- ✅ Exemplos de código completos
- ✅ Códigos de resposta e erros
- ✅ Boas práticas de integração

**Recomendado para:** Desenvolvedores que vão integrar sistemas externos com a API

---

### 2. 📝 [Changelog](CHANGELOG.md)
**Histórico de alterações e novas funcionalidades**
- Versão 1.1.1: Correção erro 696 SEFAZ
- Versão 1.1.0: Suporte a CPF (Pessoa Física)
- Versão 1.0.0: Lançamento inicial

**Recomendado para:** Acompanhar atualizações e novas funcionalidades

---

### 3. ⚠️ [Erros Comuns SEFAZ](ERROS_COMUNS_SEFAZ.md)
**Guia de troubleshooting com soluções automáticas**
- Erro 696: Consumidor final (✅ resolvido automaticamente)
- Erro de validação CPF/CNPJ (✅ resolvido automaticamente)
- Erro 204: Duplicidade de NF-e
- Outros erros comuns e soluções

**Recomendado para:** Resolver problemas rapidamente

---

### 4. 📊 [Resumo de Atualizações](RESUMO_ATUALIZACOES.md)
**Detalhes técnicos das últimas atualizações**
- Problemas resolvidos
- Alterações no código
- Novos arquivos criados
- Testes recomendados

**Recomendado para:** Entender detalhes técnicos das mudanças

---

## 🚀 Para Começar

### 1️⃣ Leia o Guia de Integração
Comece pelo [GUIA_INTEGRACAO.md](GUIA_INTEGRACAO.md) - é o documento mais completo.

### 2️⃣ Teste os Exemplos
Use os arquivos de exemplo em `/exemplos_json/`:
- `emissao_pessoa_fisica_cpf.json`
- `emissao_pessoa_juridica_cnpj.json`

### 3️⃣ Implemente no Seu Sistema
Escolha um dos exemplos de código (PHP, JavaScript, Python, C#) e adapte.

### 4️⃣ Consulte Erros Comuns
Se tiver problemas, consulte [ERROS_COMUNS_SEFAZ.md](ERROS_COMUNS_SEFAZ.md)

---

## 🔍 Procurando Algo Específico?

### Como emitir NF-e para pessoa física?
👉 [Guia de Integração - Regras Automáticas](GUIA_INTEGRACAO.md#-regras-de-negócio-automáticas)

### Como tratar erros da SEFAZ?
👉 [Erros Comuns SEFAZ](ERROS_COMUNS_SEFAZ.md)

### Quais campos são obrigatórios?
👉 [Guia de Integração - Estrutura de Dados](GUIA_INTEGRACAO.md#-estrutura-de-dados)

### Como implementar em PHP/Python/JavaScript?
👉 [Guia de Integração - Exemplos](GUIA_INTEGRACAO.md#-exemplos-de-integração)

### O que mudou na última versão?
👉 [Changelog](CHANGELOG.md)

---

## 📊 Arquitetura da API

```
┌─────────────────────────────────────────┐
│   Sistema Externo (Seu Sistema)        │
└─────────────────┬───────────────────────┘
                  │ HTTP POST (JSON)
                  ▼
┌─────────────────────────────────────────┐
│   API NF-e (pontti_nfe)                 │
│                                         │
│   ┌─────────────────────────────────┐  │
│   │  Detecção Automática            │  │
│   │  - CPF vs CNPJ                  │  │
│   │  - Consumidor Final             │  │
│   │  - indIEDest                    │  │
│   └─────────────────────────────────┘  │
│                                         │
│   ┌─────────────────────────────────┐  │
│   │  Geração XML                    │  │
│   │  - Validação                    │  │
│   │  - Assinatura Digital           │  │
│   └─────────────────────────────────┘  │
└─────────────────┬───────────────────────┘
                  │ SOAP
                  ▼
┌─────────────────────────────────────────┐
│   SEFAZ (Receita Federal)               │
│   - Validação                           │
│   - Autorização                         │
│   - Retorno de Protocolo                │
└─────────────────────────────────────────┘
```

---

## 🤖 Funcionalidades Automáticas

A API possui **inteligência automática** que facilita a integração:

### ✅ Detecção de Tipo de Cliente
- **11 dígitos** → CPF (Pessoa Física)
- **14 dígitos** → CNPJ (Pessoa Jurídica)

### ✅ Configuração de Consumidor Final
- **CPF** → `indFinal=1` + `indIEDest=9`
- **CNPJ sem IE** → `indFinal=1` + `indIEDest=9`
- **CNPJ com IE** → `indFinal=0` + `indIEDest=1`

### ✅ Geração Automática de Campos
- Número da nota (se não informado)
- Série (padrão: 001)
- Data de emissão/saída
- Dados de pagamento
- CSTs padrão

---

## 📋 Checklist de Integração

Use este checklist para garantir uma integração completa:

- [ ] Li o [Guia de Integração](GUIA_INTEGRACAO.md) completo
- [ ] Testei o endpoint `/status.php`
- [ ] Implementei emissão de NF-e para pessoa jurídica (CNPJ)
- [ ] Implementei emissão de NF-e para pessoa física (CPF)
- [ ] Implementei tratamento de erros (cStat, success)
- [ ] Implementei retry com backoff exponencial
- [ ] Configurei timeout de pelo menos 60 segundos
- [ ] Implementei armazenamento de chave_acesso e protocolo
- [ ] Testei cancelamento de NF-e
- [ ] Implementei logs de requisição/resposta
- [ ] Validei dados antes de enviar
- [ ] Testei cenários de erro
- [ ] Documentei a integração no meu sistema


---

## 🆘 Precisa de Ajuda?

### Documentação
1. Leia o [Guia de Integração](GUIA_INTEGRACAO.md)
2. Consulte [Erros Comuns](ERROS_COMUNS_SEFAZ.md)
3. Verifique o [Changelog](CHANGELOG.md)

### Suporte Técnico
- 📧 Email: contato@pontti.com.br
- 📞 Telefone: (81) 2011-3434
- 🌐 Website: [pontti.com.br](https://pontti.com.br)

### Horário de Atendimento
- Segunda a Sexta: 8h às 18h

---

## 📊 Estatísticas da API

- ✅ **Uptime:** 99.9%
- ✅ **Tempo médio de resposta:** < 3 segundos
- ✅ **Taxa de sucesso:** > 95%
- ✅ **Ambiente:** Produção (SEFAZ Real)

---

## 🔗 Links Úteis

### Documentação SEFAZ
- [Portal da NF-e](https://www.nfe.fazenda.gov.br/)
- [Códigos de Erro](https://www.nfe.fazenda.gov.br/portal/listaConteudo.aspx?tipoConteudo=tW+YMyk/50s=)
- [Manual de Integração](https://www.nfe.fazenda.gov.br/portal/listaConteudo.aspx?tipoConteudo=/fwLvLUSmU8=)

### Tabelas de Referência
- [Tabela NCM](https://www.gov.br/receitafederal/pt-br/assuntos/comercio-exterior/classificacao-fiscal-de-mercadorias)
- [Tabela CFOP](http://www.sped.fazenda.gov.br/spedtabelas/AppConsulta/publico/aspx/ConsultaCFOP.aspx)
- [Códigos de Município (IBGE)](https://www.ibge.gov.br/explica/codigos-dos-municipios.php)

### Bibliotecas Utilizadas
- [NFePHP](https://github.com/nfephp-org/sped-nfe) - Biblioteca PHP para NF-e

---

## 📜 Licença

**Licença:** Apache 2.0
**Copyright:** © 2025 Systhema Tecnologia

---

## 🔄 Versão Atual

**Versão da API:** 1.1.1
**Data:** 08/10/2025