# 🛒 NFC-e - Implementação Completa

Sistema de emissão de NFC-e (Nota Fiscal de Consumidor Eletrônica - Modelo 65) integrado ao sistema de NF-e existente.

---

## ✅ O que foi implementado

### 📁 Arquivos Criados

#### Serviço Principal
- ✅ `src/Services/NFCeService.php` - Serviço completo de NFC-e com:
  - Emissão de NFC-e
  - Cancelamento
  - Geração de DANFCE (cupom 80mm)
  - Suporte a múltiplas formas de pagamento
  - Cliente opcional (consumidor não identificado)
  - QR Code automático
  - Modo síncrono para envio SEFAZ

#### Endpoints da API
- ✅ `api/nfce/emitir.php` - Emissão de NFC-e
- ✅ `api/nfce/cancelar.php` - Cancelamento de NFC-e
- ✅ `api/nfce/consultar.php` - Consulta por chave de acesso

#### Exemplos JSON
- ✅ `exemplos_json/nfce_emissao_completa.json` - Emissão com cliente identificado
- ✅ `exemplos_json/nfce_emissao_sem_cliente.json` - Consumidor não identificado
- ✅ `exemplos_json/nfce_emissao_multiplas_formas_pagamento.json` - Múltiplas formas de pagamento
- ✅ `exemplos_json/nfce_cancelamento.json` - Cancelamento
- ✅ `exemplos_json/nfce_consulta.json` - Consulta

#### Documentação
- ✅ `docs/NFCE_GUIA_INTEGRACAO.md` - Guia completo de integração
- ✅ `docs/NFCE_README.md` - Este arquivo

---

## 🚀 Como Usar

### 1. Obter CSC na SEFAZ

Antes de emitir NFC-e, você precisa obter o **CSC (Código de Segurança do Contribuinte)** no portal da SEFAZ do seu estado:

1. Acesse o portal da SEFAZ
2. Vá em "NFC-e" → "Gerenciar CSC"
3. Gere um novo CSC
4. Anote o **Token CSC** (36 caracteres) e o **ID** (geralmente "000001")

### 2. Configurar CSC na Empresa

No JSON de emissão, inclua o CSC:

```json
{
  "empresa": {
    "cnpj": "21497109000156",
    "csc": "12345678-1234-1234-1234-123456789012",
    "csc_id": "000001"
  }
}
```

### 3. Emitir NFC-e

```bash
POST http://seu-dominio.com.br/pontti_nfe/api/nfce/emitir.php
Content-Type: application/json

{
  "empresa": { ... },
  "itens": [ ... ],
  "pagamentos": [
    {
      "forma": "01",
      "valor": 100.00
    }
  ]
}
```

---

## 🎯 Funcionalidades

### ✅ Suportado

| Funcionalidade | Status | Descrição |
|----------------|--------|-----------|
| **Emissão** | ✅ Completo | Emissão de NFC-e modelo 65 |
| **Cancelamento** | ✅ Completo | Até 30 minutos após autorização |
| **Consulta** | ✅ Completo | Consulta por chave de acesso |
| **Cliente opcional** | ✅ Completo | Consumidor não identificado |
| **CPF/CNPJ** | ✅ Completo | Identificar cliente opcionalmente |
| **Múltiplos pagamentos** | ✅ Completo | Várias formas na mesma venda |
| **Troco** | ✅ Completo | Cálculo automático de troco |
| **DANFCE (PDF)** | ✅ Completo | Cupom 80mm em PDF |
| **QR Code** | ✅ Automático | Gerado automaticamente |
| **Modo síncrono** | ✅ Completo | Envio síncrono para SEFAZ |

### ⏳ Futuras Implementações

| Funcionalidade | Status | Observação |
|----------------|--------|------------|
| **Contingência Offline** | ⏳ Pendente | Para uso sem internet |
| **Impressão térmica direta** | ⏳ Pendente | Integração com impressora |
| **SAT-CF-e** | ⏳ Pendente | Para São Paulo |

---

## 📊 Diferenças NF-e vs NFC-e

| Característica | NF-e | NFC-e |
|----------------|------|-------|
| **Modelo** | 55 | 65 |
| **Endpoint** | `/api/nfe/emitir.php` | `/api/nfce/emitir.php` |
| **CSC** | Não requerido | **Obrigatório** |
| **Cliente** | Obrigatório | Opcional |
| **Pagamento** | Opcional | **Obrigatório** |
| **DANFE** | A4 (retrato) | Cupom 80mm |
| **QR Code** | Não | Sim |

---

## 💡 Exemplos Práticos

### Venda Simples (Dinheiro)

```json
{
  "empresa": { "csc": "...", "csc_id": "000001", ... },
  "itens": [
    { "codigo": "001", "descricao": "Produto", "valor_total": 50.00, ... }
  ],
  "pagamentos": [
    { "forma": "01", "valor": 50.00 }
  ]
}
```

### Venda Mista (Dinheiro + Cartão)

```json
{
  "pagamentos": [
    { "forma": "01", "valor": 30.00 },
    { "forma": "03", "valor": 20.00 }
  ]
}
```

### Venda com Troco

```json
{
  "pagamentos": [
    { "forma": "01", "valor": 100.00, "troco": 20.00 }
  ]
}
```

### Sem Identificar Cliente

```json
{
  "empresa": { ... },
  "itens": [ ... ],
  "pagamentos": [ ... ]
  // Não incluir campo "cliente"
}
```

---

## 🔧 Estrutura de Pastas

Arquivos XML e PDF são organizados automaticamente:

```
arquivos/{CNPJ}/nfce/
├── xml/
│   └── {ANO_MES}/
│       └── assinados/
│           └── {CHAVE_ACESSO}.xml
├── pdf/
│   └── {ANO_MES}/
│       └── emitidos/
│           └── NFCe_{CHAVE_ACESSO}.pdf
└── eventos/
    └── cancelamentos/
```

---

## ⚠️ Requisitos Importantes

### Obrigatórios para NFC-e:

1. ✅ **CSC** - Obtido na SEFAZ
2. ✅ **CSC ID** - Geralmente "000001"
3. ✅ **Certificado A1** - .pfx válido
4. ✅ **Forma de pagamento** - Pelo menos uma
5. ✅ **Regime tributário** - Simples Nacional (recomendado)

### Opcional:

- ❌ Cliente (CPF/CNPJ)
- ❌ Endereço do cliente
- ❌ Informações complementares

---

## 📞 Suporte

- **Email**: contato@pontti.com.br
- **Telefone**: (81) 2011-3434
- **Documentação**: [NFCE_GUIA_INTEGRACAO.md](NFCE_GUIA_INTEGRACAO.md)

---

## 🎯 Próximos Passos

1. **Testar em Homologação**
   - Configurar `tpAmb = 2` no código
   - Fazer emissões de teste
   - Validar cancelamentos

2. **Implementar em Produção**
   - Configurar `tpAmb = 1`
   - Obter CSC de produção
   - Iniciar vendas reais

3. **Integrar com Sistema PDV**
   - Conectar endpoints na aplicação
   - Configurar impressora térmica
   - Treinar equipe

---

**Desenvolvido por [Systhema Tecnologia](https://pontti.com.br)**

**Versão:** 1.0.0
**Data:** 21/10/2025

