# 🛒 Guia de Integração - NFC-e (Nota Fiscal de Consumidor Eletrônica)

API para emissão de NFC-e (Modelo 65) - Cupom Fiscal Eletrônico

---

## 📋 Índice

1. [Introdução](#introdução)
2. [Diferenças entre NF-e e NFC-e](#diferenças-entre-nf-e-e-nfc-e)
3. [Requisitos](#requisitos)
4. [Endpoints](#endpoints)
5. [Emissão de NFC-e](#emissão-de-nfc-e)
6. [Cancelamento](#cancelamento)
7. [Consulta](#consulta)
8. [Formas de Pagamento](#formas-de-pagamento)
9. [Exemplos de Uso](#exemplos-de-uso)
10. [Erros Comuns](#erros-comuns)

---

## 🎯 Introdução

A **NFC-e (Nota Fiscal de Consumidor Eletrônica)** é o documento fiscal eletrônico modelo 65, utilizado para registrar vendas ao consumidor final. Substitui o Cupom Fiscal (ECF) e a Nota Fiscal de Venda a Consumidor modelo 2.

### ✅ Principais características:

- **Modelo:** 65
- **Uso:** Venda presencial ao consumidor final
- **DANFE:** Formato cupom (80mm)
- **QR Code:** Obrigatório para consulta
- **Destinatário:** Opcional (pode ser não identificado)
- **Ambiente:** PDV, varejo, comércio

---

## 🔄 Diferenças entre NF-e e NFC-e

| Característica | NF-e (Modelo 55) | NFC-e (Modelo 65) |
|----------------|------------------|-------------------|
| **Operação** | B2B (empresa-empresa) | B2C (empresa-consumidor) |
| **Destinatário** | Obrigatório | Opcional |
| **DANFE** | A4 (retrato) | Cupom (80mm) |
| **QR Code** | Não | Sim (obrigatório) |
| **Pagamento** | Opcional | Obrigatório |
| **CSC** | Não requerido | Obrigatório |
| **Impressão** | Não obrigatória | Obrigatória no PDV |

---

## 📦 Requisitos

### Obrigatórios para NFC-e:

1. **Certificado Digital A1** (.pfx)
2. **CSC (Código de Segurança do Contribuinte)**
   - Obtido no portal da SEFAZ
   - Token único de 36 caracteres
   - Identificador (CSC ID) - geralmente "000001"
3. **Regime Tributário:** Simples Nacional (CRT 1) é o mais comum
4. **Impressora Térmica:** 80mm (opcional, para impressão local)

---

## 🌐 Endpoints

### Base URL
```
http://seu-dominio.com.br/pontti_nfe
```

### Disponíveis:

| Método | Endpoint | Descrição |
|--------|----------|-----------|
| POST | `/api/nfce/emitir.php` | Emitir NFC-e |
| POST | `/api/nfce/cancelar.php` | Cancelar NFC-e |
| POST | `/api/nfce/consultar.php` | Consultar NFC-e |

---

## 📤 Emissão de NFC-e

### Endpoint
```http
POST /api/nfce/emitir.php
Content-Type: application/json
```

### Request Body Completo

```json
{
  "empresa": {
    "nome": "PRINT JET DIGITAL",
    "nome_fantasia": "Print Jet",
    "cnpj": "21497109000156",
    "inscricao_estadual": "093218028",
    "regime_tributario": 1,
    "estado": "PE",
    "cidade": "Recife",
    "endereco": "Rua Frei Cassimiro",
    "numero": "644",
    "bairro": "Santo Amaro",
    "cep": "50100260",
    "email": "atendimento@printjetdigital.com.br",
    "telefone": "(81) 99999-9999",
    "csc": "12345678-1234-1234-1234-123456789012",
    "csc_id": "000001"
  },
  "cliente": {
    "cpf": "05138670409",
    "nome": "João da Silva"
  },
  "nfce": {
    "numero": "1",
    "serie": "001",
    "data_emissao": "2025-10-21"
  },
  "itens": [
    {
      "codigo": "PROD001",
      "descricao": "Produto Teste 1",
      "ncm": "84713000",
      "cfop": "5102",
      "unidade_comercial": "UN",
      "quantidade_comercial": 2,
      "valor_unitario": 50.00,
      "valor_total": 100.00,
      "cst_icms": "102",
      "origem": "0"
    }
  ],
  "pagamentos": [
    {
      "forma": "01",
      "valor": 100.00
    }
  ],
  "informacoes_complementares": "Venda realizada no PDV 01"
}
```

### Response - Sucesso (200 OK)

```json
{
  "success": true,
  "numero": "1",
  "serie": "001",
  "chave_acesso": "26251021497109000156650010000000011234567890",
  "protocolo": "126250000123456",
  "cStat": "100",
  "xml_path": "/pontti_nfe/arquivos/21497109000156/nfce/xml/2025_10/assinados/26251021497109000156650010000000011234567890.xml",
  "pdf_path": "/pontti_nfe/arquivos/21497109000156/nfce/pdf/2025_10/emitidos/NFCe_26251021497109000156650010000000011234567890.pdf",
  "data_emissao": "2025-10-21",
  "valor_total": 100.00,
  "message": "NFC-e emitida com sucesso"
}
```

### Response - Erro (400)

```json
{
  "success": false,
  "chave_acesso": "26251021497109000156650010000000011234567890",
  "cStat": "532",
  "numero": "1",
  "serie": "001",
  "error": "NFe rejeitada [532]: Total do ICMS difere do somatório dos itens"
}
```

---

## 📝 Campos Obrigatórios

### Empresa

| Campo | Tipo | Descrição | Obrigatório |
|-------|------|-----------|-------------|
| `nome` | string | Razão social | ✅ Sim |
| `cnpj` | string | CNPJ (com ou sem máscara) | ✅ Sim |
| `inscricao_estadual` | string | Inscrição Estadual | ✅ Sim |
| `regime_tributario` | int | 1=Simples Nacional, 3=Regime Normal | ✅ Sim |
| `estado` | string | UF (sigla) | ✅ Sim |
| `cidade` | string | Nome do município | ✅ Sim |
| `endereco` | string | Logradouro | ✅ Sim |
| `numero` | string | Número | ✅ Sim |
| `bairro` | string | Bairro | ✅ Sim |
| `cep` | string | CEP | ✅ Sim |
| **`csc`** | **string** | **Código de Segurança (36 chars)** | ✅ **Sim** |
| **`csc_id`** | **string** | **ID do CSC (geralmente "000001")** | ✅ **Sim** |

### Cliente (OPCIONAL)

| Campo | Tipo | Descrição | Obrigatório |
|-------|------|-----------|-------------|
| `cpf` ou `cnpj` | string | CPF ou CNPJ do cliente | ❌ Não* |
| `nome` | string | Nome do cliente | ❌ Não* |

> **Nota:** Se não informar cliente, a NFC-e será emitida para "Consumidor não identificado"

### NFC-e

| Campo | Tipo | Descrição | Obrigatório |
|-------|------|-----------|-------------|
| `numero` | int/string | Número sequencial | ❌ Não (gera automaticamente) |
| `serie` | int/string | Série da NFC-e | ❌ Não (padrão: "001") |
| `data_emissao` | string | Data de emissão (Y-m-d) | ❌ Não (padrão: hoje) |

### Itens

| Campo | Tipo | Descrição | Obrigatório |
|-------|------|-----------|-------------|
| `codigo` | string | Código do produto | ✅ Sim |
| `descricao` | string | Descrição do produto | ✅ Sim |
| `ncm` | string | Código NCM (8 dígitos) | ✅ Sim |
| `cfop` | string | CFOP da operação | ✅ Sim |
| `unidade_comercial` | string | Unidade (UN, KG, etc) | ✅ Sim |
| `quantidade_comercial` | float | Quantidade | ✅ Sim |
| `valor_unitario` | float | Valor unitário | ✅ Sim |
| `valor_total` | float | Valor total do item | ✅ Sim |
| `cst_icms` | string | CST ou CSOSN | ✅ Sim |
| `origem` | string | Origem (0-8) | ✅ Sim |

### Pagamentos (OBRIGATÓRIO)

| Campo | Tipo | Descrição | Obrigatório |
|-------|------|-----------|-------------|
| `forma` | string | Código da forma de pagamento | ✅ Sim |
| `valor` | float | Valor pago | ✅ Sim |
| `troco` | float | Valor do troco (se houver) | ❌ Não |

---

## 💳 Formas de Pagamento

| Código | Descrição |
|--------|-----------|
| `01` | Dinheiro |
| `02` | Cheque |
| `03` | Cartão de Crédito |
| `04` | Cartão de Débito |
| `05` | Crédito Loja |
| `10` | Vale Alimentação |
| `11` | Vale Refeição |
| `12` | Vale Presente |
| `13` | Vale Combustível |
| `15` | Boleto Bancário |
| `16` | Depósito Bancário |
| `17` | PIX |
| `18` | Transferência bancária |
| `19` | Programa de fidelidade |
| `90` | Sem pagamento |
| `99` | Outros |

### Exemplo: Múltiplas Formas de Pagamento

```json
{
  "pagamentos": [
    {
      "forma": "01",
      "valor": 50.00
    },
    {
      "forma": "03",
      "valor": 50.00
    }
  ]
}
```

### Exemplo: Com Troco

```json
{
  "pagamentos": [
    {
      "forma": "01",
      "valor": 150.00,
      "troco": 50.00
    }
  ]
}
```

---

## ❌ Cancelamento de NFC-e

### Endpoint
```http
POST /api/nfce/cancelar.php
Content-Type: application/json
```

### Request Body

```json
{
  "chave_acesso": "26251021497109000156650010000000011234567890",
  "justificativa": "Cancelamento por erro na emissão da nota fiscal",
  "protocolo_autorizacao": "126250000123456",
  "empresa": {
    "nome": "PRINT JET DIGITAL",
    "cnpj": "21497109000156",
    "inscricao_estadual": "093218028",
    "estado": "PE"
  }
}
```

### Response - Sucesso (200 OK)

```json
{
  "success": true,
  "chave_acesso": "26251021497109000156650010000000011234567890",
  "message": "NFC-e cancelada com sucesso"
}
```

### Regras de Cancelamento:

- ✅ Prazo: Até **30 minutos** após a autorização
- ✅ Justificativa: Mínimo **15 caracteres**
- ❌ Após 30 minutos: Precisa fazer **Inutilização**

---

## 🔍 Consulta de NFC-e

### Endpoint
```http
POST /api/nfce/consultar.php
Content-Type: application/json
```

### Request Body

```json
{
  "chave_acesso": "26251021497109000156650010000000011234567890",
  "empresa": {
    "nome": "PRINT JET DIGITAL",
    "cnpj": "21497109000156",
    "estado": "PE"
  }
}
```

### Response - Autorizada (200 OK)

```json
{
  "success": true,
  "chave_acesso": "26251021497109000156650010000000011234567890",
  "cStat": "100",
  "xMotivo": "Autorizado o uso da NF-e",
  "protocolo": "126250000123456",
  "data_autorizacao": "2025-10-21T14:30:00-03:00",
  "situacao": "Autorizada"
}
```

---

## 🔧 Exemplos de Uso

### PHP (cURL)

```php
<?php
$url = 'http://seu-dominio.com.br/pontti_nfe/api/nfce/emitir.php';

$dados = [
    'empresa' => [
        'nome' => 'PRINT JET DIGITAL',
        'cnpj' => '21497109000156',
        'csc' => '12345678-1234-1234-1234-123456789012',
        'csc_id' => '000001',
        // ... outros campos
    ],
    'itens' => [
        [
            'codigo' => 'PROD001',
            'descricao' => 'Produto Teste',
            'valor_total' => 100.00,
            // ... outros campos
        ]
    ],
    'pagamentos' => [
        [
            'forma' => '01',
            'valor' => 100.00
        ]
    ]
];

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($dados));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$response = curl_exec($ch);
$resultado = json_decode($response, true);

curl_close($ch);

if ($resultado['success']) {
    echo "NFC-e emitida com sucesso!\n";
    echo "Chave: " . $resultado['chave_acesso'] . "\n";
    echo "PDF: " . $resultado['pdf_path'] . "\n";
} else {
    echo "Erro: " . $resultado['error'] . "\n";
}
```

---

## ⚠️ Erros Comuns

### CSC não configurado

**Erro:** `CSC (Código de Segurança do Contribuinte) é obrigatório para NFC-e`

**Solução:** Obtenha o CSC no portal da SEFAZ e configure no JSON:
```json
{
  "empresa": {
    "csc": "12345678-1234-1234-1234-123456789012",
    "csc_id": "000001"
  }
}
```

### Pagamento não informado

**Erro:** `É necessário informar pelo menos uma forma de pagamento`

**Solução:** Adicione o campo `pagamentos`:
```json
{
  "pagamentos": [
    {
      "forma": "01",
      "valor": 100.00
    }
  ]
}
```

### Total do pagamento diferente do total da NFC-e

**Erro:** `Total dos pagamentos (150.00) difere do total da NFC-e (100.00)`

**Solução:** Certifique-se que a soma dos pagamentos é igual ao total dos itens

---

## 📞 Suporte

- **Email**: contato@pontti.com.br
- **Telefone**: (81) 2011-3434

---

## 📚 Links Úteis

- [Documentação NF-e](README.md)
- [Exemplos JSON](../exemplos_json/)
- [Erros Comuns SEFAZ](ERROS_COMUNS_SEFAZ.md)

---

**Desenvolvido por [Systhema Tecnologia](https://pontti.com.br)**

