# 🚚 Guia de Integração - MDF-e (Manifesto Eletrônico de Documentos Fiscais)

API para emissão de MDF-e (Modelo 58) - Manifesto de transporte de cargas

---

## 📋 Índice

1. [Introdução](#introdução)
2. [O que é MDF-e](#o-que-é-mdf-e)
3. [Requisitos](#requisitos)
4. [Endpoints](#endpoints)
5. [Emissão de MDF-e](#emissão-de-mdf-e)
6. [Encerramento](#encerramento)
7. [Cancelamento](#cancelamento)
8. [Inclusão de Condutor](#inclusão-de-condutor)
9. [Consulta](#consulta)
10. [Exemplos de Uso](#exemplos-de-uso)

---

## 🎯 Introdução

O **MDF-e (Manifesto Eletrônico de Documentos Fiscais)** é o documento fiscal eletrônico modelo 58, utilizado para **vincular documentos fiscais (NF-es) transportados em um mesmo veículo** durante operações de transporte interestaduais ou intermunicipais.

### ✅ Principais características:

- **Modelo:** 58
- **Uso:** Transporte de cargas
- **Agrupa:** Múltiplas NF-es de uma mesma viagem
- **Obrigatório:** Transporte intermunicipal e interestadual
- **DAMDFE:** Documento auxiliar impresso
- **Modal:** Rodoviário, Aéreo, Aquaviário, Ferroviário

---

## 📚 O que é MDF-e?

O MDF-e serve para **agrupar documentos fiscais** que estão sendo transportados juntos. É obrigatório quando:

- ✅ Transporte **interestadual** de cargas
- ✅ Transporte **intermunicipal** dentro do mesmo estado (algumas UFs)
- ✅ Transportadora realizando serviço
- ✅ Empresa transportando carga própria

### 🚛 Tipos de Emitente:

| Código | Descrição |
|--------|-----------|
| 1 | Prestador de serviço de transporte |
| 2 | **Transportador de Carga Própria** (mais comum) |
| 3 | Prestador de serviço que emitirá CT-e Globalizado |

### 🔖 Tipos de Transportador:

| Código | Descrição |
|--------|-----------|
| 1 | **ETC** (Empresa de Transporte de Cargas) |
| 2 | **TAC** (Transportador Autônomo de Cargas) |
| 3 | **CTC** (Cooperativa de Transporte de Cargas) |

---

## 📦 Requisitos

### Obrigatórios para MDF-e:

1. **Certificado Digital A1** (.pfx)
2. **Veículo de tração** (placa, tara, capacidade)
3. **Pelo menos 1 condutor** (motorista)
4. **UF de início e fim** da viagem
5. **Municípios de carregamento/descarregamento**
6. **Chaves das NF-es** que estão sendo transportadas
7. **Totalizadores** (peso, valor da carga)

---

## 🌐 Endpoints

### Base URL
```
http://seu-dominio.com.br/pontti_nfe
```

### Disponíveis:

| Método | Endpoint | Descrição |
|--------|----------|-----------|
| POST | `/api/mdfe/emitir.php` | Emitir MDF-e |
| POST | `/api/mdfe/encerrar.php` | Encerrar MDF-e |
| POST | `/api/mdfe/cancelar.php` | Cancelar MDF-e |
| POST | `/api/mdfe/incluir-condutor.php` | Incluir motorista |
| POST | `/api/mdfe/consultar.php` | Consultar MDF-e |

---

## 📤 Emissão de MDF-e

### Endpoint
```http
POST /api/mdfe/emitir.php
Content-Type: application/json
```

### Request Body Completo

```json
{
  "emitente": {
    "nome": "PRINT JET DIGITAL",
    "nome_fantasia": "Print Jet",
    "cnpj": "21497109000156",
    "inscricao_estadual": "093218028",
    "estado": "PE",
    "cidade": "Recife",
    "endereco": "Rua Frei Cassimiro",
    "numero": "644",
    "bairro": "Santo Amaro",
    "cep": "50100260",
    "telefone": "(81) 99999-9999",
    "email": "atendimento@printjetdigital.com.br"
  },
  "mdfe": {
    "numero": "1",
    "serie": "001",
    "data_emissao": "2025-10-21"
  },
  "tipo_emitente": 2,
  "tipo_transportador": 1,
  "modal": 1,
  "uf_inicio": "PE",
  "uf_fim": "SP",
  "veiculo": {
    "codigo_interno": "VEI001",
    "placa": "ABC1234",
    "renavam": "12345678901",
    "tara": 8000,
    "capacidade_kg": 25000,
    "capacidade_m3": 80,
    "tipo_rodado": "03",
    "tipo_carroceria": "02",
    "uf": "PE"
  },
  "condutores": [
    {
      "nome": "João da Silva",
      "cpf": "05138670409"
    }
  ],
  "municipios_carregamento": [
    {
      "codigo_municipio": 2611606,
      "nome": "Recife",
      "nfes": [
        {
          "chave_acesso": "26251021497109000156550050000000011000010014"
        }
      ]
    }
  ],
  "municipios_descarregamento": [
    {
      "codigo_municipio": 3550308,
      "nome": "São Paulo",
      "nfes": [
        {
          "chave_acesso": "26251021497109000156550050000000011000010014"
        }
      ]
    }
  ],
  "totalizadores": {
    "quantidade_nfe": 1,
    "quantidade_cte": 0,
    "quantidade_mdfe": 0,
    "valor_carga": 10000.00,
    "codigo_unidade": "01",
    "peso_carga": 5000.0000
  },
  "informacoes_complementares": "Manifesto de transporte"
}
```

### Response - Sucesso (200 OK)

```json
{
  "success": true,
  "numero": "1",
  "serie": "001",
  "chave_acesso": "26251021497109000156580010000000011234567890",
  "protocolo": "126250000123456",
  "cStat": "100",
  "xml_path": "/pontti_nfe/arquivos/.../mdfe/xml/.../26251021...xml",
  "pdf_path": "/pontti_nfe/arquivos/.../mdfe/pdf/.../MDFe_26251021...pdf",
  "data_emissao": "2025-10-21",
  "message": "MDF-e emitido com sucesso"
}
```

---

## 📝 Campos Obrigatórios

### Emitente

| Campo | Tipo | Descrição |
|-------|------|-----------|
| `nome` | string | Razão social |
| `cnpj` | string | CNPJ |
| `inscricao_estadual` | string | IE |
| `estado` | string | UF |
| `cidade` | string | Município |
| `endereco` | string | Logradouro |
| `numero` | string | Número |
| `bairro` | string | Bairro |
| `cep` | string | CEP |

### Veículo de Tração

| Campo | Tipo | Descrição |
|-------|------|-----------|
| `placa` | string | Placa (7 caracteres) |
| `tara` | int | Peso vazio em KG |
| `capacidade_kg` | int | Capacidade em KG |
| `uf` | string | UF de emplacamento |

### Condutor (Motorista)

| Campo | Tipo | Descrição |
|-------|------|-----------|
| `nome` | string | Nome completo |
| `cpf` | string | CPF (11 dígitos) |

### Municípios

| Campo | Tipo | Descrição |
|-------|------|-----------|
| `codigo_municipio` | int | Código IBGE (7 dígitos) |
| `nome` | string | Nome do município |
| `nfes` | array | Array de chaves NF-es |

### Totalizadores

| Campo | Tipo | Descrição |
|-------|------|-----------|
| `quantidade_nfe` | int | Qtd de NF-es |
| `valor_carga` | float | Valor total da carga |
| `codigo_unidade` | string | 01=KG, 02=TON |
| `peso_carga` | float | Peso total (4 decimais) |

---

## 🏁 Encerramento de MDF-e

### Endpoint
```http
POST /api/mdfe/encerrar.php
```

### Request Body

```json
{
  "chave_acesso": "26251021497109000156580010000000011234567890",
  "protocolo": "126250000123456",
  "uf_encerramento": "SP",
  "codigo_municipio_encerramento": 3550308,
  "emitente": {
    "nome": "PRINT JET DIGITAL",
    "cnpj": "21497109000156",
    "estado": "PE"
  }
}
```

### Response - Sucesso

```json
{
  "success": true,
  "chave_acesso": "26251021497109000156580010000000011234567890",
  "protocolo_encerramento": "126250000123457",
  "data_encerramento": "2025-10-21T18:30:00-03:00",
  "message": "MDF-e encerrado com sucesso"
}
```

### ⚠️ Quando encerrar:

- ✅ Ao **finalizar a viagem**
- ✅ Ao **descarregar todas as NF-es**
- ✅ Informar o **município onde terminou** o transporte

---

## ❌ Cancelamento de MDF-e

### Endpoint
```http
POST /api/mdfe/cancelar.php
```

### Request Body

```json
{
  "chave_acesso": "26251021497109000156580010000000011234567890",
  "justificativa": "Cancelamento por erro na emissão do manifesto",
  "protocolo": "126250000123456",
  "emitente": {
    "nome": "PRINT JET DIGITAL",
    "cnpj": "21497109000156",
    "estado": "PE"
  }
}
```

### Response - Sucesso

```json
{
  "success": true,
  "chave_acesso": "26251021497109000156580010000000011234567890",
  "protocolo_cancelamento": "126250000123458",
  "message": "MDF-e cancelado com sucesso"
}
```

### ⚠️ Regras:

- ✅ Prazo: **Até 24 horas** após autorização
- ✅ Justificativa: Mínimo **15 caracteres**
- ❌ Não pode ter iniciado o transporte

---

## 👤 Inclusão de Condutor

Durante a viagem, você pode adicionar um novo motorista.

### Endpoint
```http
POST /api/mdfe/incluir-condutor.php
```

### Request Body

```json
{
  "chave_acesso": "26251021497109000156580010000000011234567890",
  "condutor": {
    "nome": "Pedro Oliveira",
    "cpf": "98765432100"
  },
  "emitente": {
    "nome": "PRINT JET DIGITAL",
    "cnpj": "21497109000156",
    "estado": "PE"
  }
}
```

### Response - Sucesso

```json
{
  "success": true,
  "chave_acesso": "26251021497109000156580010000000011234567890",
  "protocolo_evento": "126250000123459",
  "message": "Condutor incluído com sucesso"
}
```

---

## 🔍 Consulta de MDF-e

### Endpoint
```http
POST /api/mdfe/consultar.php
```

### Request Body

```json
{
  "chave_acesso": "26251021497109000156580010000000011234567890",
  "emitente": {
    "nome": "PRINT JET DIGITAL",
    "cnpj": "21497109000156",
    "estado": "PE"
  }
}
```

### Response - Autorizado

```json
{
  "success": true,
  "chave_acesso": "26251021497109000156580010000000011234567890",
  "cStat": "100",
  "xMotivo": "Autorizado o uso do MDF-e",
  "protocolo": "126250000123456",
  "data_autorizacao": "2025-10-21T14:30:00-03:00",
  "situacao": "Autorizado"
}
```

---

## 🚛 Tipos de Rodado

| Código | Descrição |
|--------|-----------|
| 01 | Truck |
| 02 | Toco |
| 03 | **Cavalo Mecânico** (mais comum) |
| 04 | VAN |
| 05 | Utilitário |
| 06 | Outros |

---

## 📦 Tipos de Carroceria

| Código | Descrição |
|--------|-----------|
| 00 | Não aplicável |
| 01 | Aberta |
| 02 | **Fechada/Baú** (mais comum) |
| 03 | Granelera |
| 04 | Porta Container |
| 05 | Sider |

---

## 🔧 Exemplos de Uso

### PHP (cURL)

```php
<?php
$url = 'http://seu-dominio.com.br/pontti_nfe/api/mdfe/emitir.php';

$dados = [
    'emitente' => [
        'nome' => 'MINHA EMPRESA',
        'cnpj' => '00000000000000',
        // ... outros campos
    ],
    'veiculo' => [
        'placa' => 'ABC1234',
        'tara' => 8000,
        'capacidade_kg' => 25000,
        'uf' => 'PE'
    ],
    'condutores' => [
        ['nome' => 'João Silva', 'cpf' => '00000000000']
    ],
    'uf_inicio' => 'PE',
    'uf_fim' => 'SP',
    'municipios_carregamento' => [...],
    'municipios_descarregamento' => [...],
    'totalizadores' => [...]
];

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($dados));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$response = curl_exec($ch);
$resultado = json_decode($response, true);

if ($resultado['success']) {
    echo "MDF-e emitido! Chave: " . $resultado['chave_acesso'];
} else {
    echo "Erro: " . $resultado['error'];
}
```

---

## ⚠️ Erros Comuns

### Erro: "É necessário informar pelo menos 1 condutor"

**Solução:** Adicione o array de condutores:
```json
{
  "condutores": [
    {
      "nome": "Nome do Motorista",
      "cpf": "00000000000"
    }
  ]
}
```

### Erro: "UF de início e fim são obrigatórias"

**Solução:** Informe as UFs:
```json
{
  "uf_inicio": "PE",
  "uf_fim": "SP"
}
```

---

## 📞 Suporte

- **Email**: contato@pontti.com.br
- **Telefone**: (81) 2011-3434

---

**Desenvolvido por [Systhema Tecnologia](https://pontti.com.br)**

