# 📋 Documentação dos Endpoints de MDF-e

Sistema completo de emissão e gerenciamento de MDF-e (Manifesto Eletrônico de Documentos Fiscais) integrado com SEFAZ.

---

## 🚚 1. Emitir MDF-e

Emite um novo MDF-e e envia para autorização na SEFAZ.

**Endpoint:** `POST /api/mdfe/emitir.php`

### Request:

```json
{
    "emitente": {
        "nome": "PRINT JET DIGITAL",
        "nome_fantasia": "Print Jet",
        "cnpj": "21497109000156",
        "inscricao_estadual": "093218028",
        "estado": "PE",
        "cidade": "Recife",
        "endereco": "Rua Frei Cassimiro",
        "numero": "644",
        "bairro": "Santo Amaro",
        "cep": "50100260",
        "telefone": "(81) 99999-9999",
        "email": "atendimento@printjetdigital.com.br"
    },
    "mdfe": {
        "numero": "1",
        "serie": "001"
    },
    "tipo_emitente": 2,
    "modal": 1,
    "uf_inicio": "PE",
    "uf_fim": "SP",
    "veiculo": {
        "codigo_interno": "VEI001",
        "placa": "ABC1234",
        "renavam": "12345678901",
        "tara": 8000,
        "capacidade_kg": 25000,
        "capacidade_m3": 80,
        "tipo_rodado": "02",
        "tipo_carroceria": "00",
        "uf": "PE"
    },
    "condutores": [
        {
            "nome": "João da Silva",
            "cpf": "05138670409"
        }
    ],
    "municipios_carregamento": [
        {
            "codigo_municipio": 2611606,
            "nome": "Recife",
            "nfes": [
                {
                    "chave_acesso": "35251012345678000195550010000000011234567890"
                }
            ]
        }
    ],
    "municipios_descarregamento": [
        {
            "codigo_municipio": 3550308,
            "nome": "São Paulo",
            "nfes": [
                {
                    "chave_acesso": "35251012345678000195550010000000011234567890"
                }
            ]
        }
    ],
    "totalizadores": {
        "quantidade_nfe": 1,
        "quantidade_cte": 0,
        "quantidade_mdfe": 0,
        "valor_carga": 5000.00,
        "codigo_unidade": "01",
        "peso_carga": 2500.0000
    },
    "informacoes_complementares": "Transporte de mercadorias"
}
```

### Response (Sucesso):

```json
{
    "success": true,
    "numero": "1",
    "serie": "001",
    "chave_acesso": "26251021497109000156580010000000011735126513",
    "protocolo": "926250000006524",
    "cStat": "100",
    "xml_path": "/pontti_nfe/arquivos/21497109000156/mdfe/xml/2025_10/assinados/26251021497109000156580010000000011735126513.xml",
    "pdf_path": null,
    "data_emissao": "2025-10-21 15:54:11",
    "message": "MDF-e emitido com sucesso"
}
```

---

## 🏁 2. Encerrar MDF-e

Encerra um MDF-e em um determinado município.

**Endpoint:** `POST /api/mdfe/encerrar.php`

### Request:

```json
{
    "chave_acesso": "26251021497109000156580010000000011735126513",
    "protocolo": "926250000006524",
    "cnpj": "21497109000156",
    "uf_encerramento": "SP",
    "municipio_encerramento": {
        "codigo": "3550308",
        "nome": "São Paulo"
    }
}
```

### Response (Sucesso):

```json
{
    "success": true,
    "chave_acesso": "26251021497109000156580010000000011735126513",
    "protocolo_encerramento": "926250000006525",
    "cStat": "135",
    "xMotivo": "Evento registrado e vinculado ao MDF-e",
    "message": "MDF-e encerrado com sucesso"
}
```

---

## ❌ 3. Cancelar MDF-e

Cancela um MDF-e autorizado (prazo: até 24 horas após autorização).

**Endpoint:** `POST /api/mdfe/cancelar.php`

### Request:

```json
{
    "chave_acesso": "26251021497109000156580010000000051808712025",
    "protocolo": "926250000006530",
    "cnpj": "21497109000156",
    "justificativa": "Erro no preenchimento dos dados do MDF-e, necessário cancelamento"
}
```

### Response (Sucesso):

```json
{
    "success": true,
    "chave_acesso": "26251021497109000156580010000000051808712025",
    "protocolo_cancelamento": "926250000006531",
    "cStat": "135",
    "xMotivo": "Evento registrado e vinculado ao MDF-e",
    "message": "MDF-e cancelado com sucesso"
}
```

**⚠️ Observações:**
- Justificativa mínima: 15 caracteres
- Cancelamento só pode ser feito antes do encerramento
- Prazo: até 24 horas após autorização

---

## 👤 4. Incluir Condutor

Inclui um condutor adicional em um MDF-e já autorizado.

**Endpoint:** `POST /api/mdfe/incluir_condutor.php`

### Request:

```json
{
    "chave_acesso": "26251021497109000156580010000000051808712025",
    "cnpj": "21497109000156",
    "condutor": {
        "nome": "Maria Santos Silva",
        "cpf": "12345678909"
    }
}
```

### Response (Sucesso):

```json
{
    "success": true,
    "chave_acesso": "26251021497109000156580010000000051808712025",
    "protocolo_evento": "926250000006532",
    "cStat": "135",
    "xMotivo": "Evento registrado e vinculado ao MDF-e",
    "condutor": {
        "nome": "Maria Santos Silva",
        "cpf": "12345678909"
    },
    "message": "Condutor incluído com sucesso"
}
```

---

## 📊 Códigos de Status Comuns

| cStat | Descrição |
|-------|-----------|
| 100 | Autorizado uso da MDF-e |
| 135 | Evento registrado e vinculado ao MDF-e |
| 136 | Evento registrado, mas não vinculado à MDF-e |
| 539 | Duplicidade de MDF-e |
| 604 | Chave de acesso do documento fiscal inválida |
| 611 | Existe MDF-e não encerrado para esta placa |
| 630 | Rejeição: Falha no Schema XML |
| 631 | Duplicidade de evento |

---

## 🔧 Parâmetros Importantes

### Tipo de Emitente (`tipo_emitente`)
- `1` - Prestador de serviço de transporte
- `2` - Transportador de Carga Própria
- `3` - Prestador de serviço de transporte que emitirá CT-e Globalizado

### Modal (`modal`)
- `1` - Rodoviário
- `2` - Aéreo
- `3` - Aquaviário
- `4` - Ferroviário

### Tipo de Rodado (`tipo_rodado`)
- `01` - Truck
- `02` - Toco
- `03` - Cavalo Mecânico
- `04` - VAN
- `05` - Utilitário
- `06` - Outros

### Tipo de Carroceria (`tipo_carroceria`)
- `00` - Não aplicável
- `01` - Aberta
- `02` - Fechada/Baú
- `03` - Granelera
- `04` - Porta Container
- `05` - Sider

---

## 📝 Observações Importantes

1. **Certificado Digital:** O sistema usa o certificado A1 em formato PFX
2. **Ambiente:** Atualmente configurado para **Homologação** (`tpAmb = 2`)
3. **PDF:** Geração de PDF temporariamente desabilitada devido a limitação da biblioteca
4. **Percurso:** Sistema adiciona automaticamente UFs intermediárias (BA e MG) entre PE e SP
5. **Sequencial:** O número do MDF-e deve ser sequencial por série
6. **Chaves NF-e:** Devem ser chaves válidas de NF-es que estão sendo transportadas

---

## 🚀 Ambiente de Produção

Para migrar para produção, alterar em `MDFeService.php`:

```php
private $tpAmb = 1; // 1=Produção, 2=Homologação
```

---

## 📚 Exemplos Completos

Todos os exemplos de JSON estão disponíveis em:
- `exemplos_json/mdfe_emissao_completa.json`
- `exemplos_json/mdfe_encerramento.json`
- `exemplos_json/mdfe_cancelamento.json`
- `exemplos_json/mdfe_incluir_condutor.json`

---

**Desenvolvido com integração real à SEFAZ usando NFePHP** 🚀

