# ⚠️ Guia de Erros Comuns da SEFAZ e Soluções Automáticas

Este guia documenta os erros mais comuns da SEFAZ e como o sistema **resolve automaticamente**.

---

## ✅ Erros Resolvidos Automaticamente pelo Sistema

### 1. ❌ Erro 696 - Operação com não contribuinte sem consumidor final

**Mensagem da SEFAZ:**
```
Rejeição: Operação com não contribuinte deve indicar operação com consumidor final
```

#### 🔍 Causa
Quando o cliente é **não contribuinte de ICMS** (pessoa física ou PJ sem IE), a nota **DEVE** ter:
- `indFinal = 1` (Consumidor Final)
- `indIEDest = 9` (Não Contribuinte)

#### ✅ Solução Automática
O sistema detecta automaticamente e configura corretamente:

| Situação | Sistema configura automaticamente |
|----------|-----------------------------------|
| Cliente com **CPF** | `indFinal=1` + `indIEDest=9` |
| Cliente com **CNPJ sem IE** | `indFinal=1` + `indIEDest=9` |
| Cliente com **CNPJ com IE** | `indFinal=0` + `indIEDest=1` |

**Você não precisa fazer nada!** O sistema resolve sozinho.

---

### 2. ❌ Erro de Validação do CNPJ com 11 dígitos

**Mensagem da SEFAZ:**
```
Element '{http://www.portalfiscal.inf.br/nfe}CNPJ': [facet 'pattern']
The value '05138670409' is not accepted by the pattern '[0-9]{14}'
```

#### 🔍 Causa
CPF tem 11 dígitos, mas o sistema estava tentando usar o campo `<CNPJ>` que aceita apenas 14 dígitos.

#### ✅ Solução Automática
O sistema detecta automaticamente o tamanho do documento:
- **11 dígitos** → Usa campo `<CPF>` no XML
- **14 dígitos** → Usa campo `<CNPJ>` no XML

**Você não precisa fazer nada!** Apenas informe CPF ou CNPJ no JSON.

---

## 📋 Tabela Resumo - Configurações Automáticas

| Tipo Cliente | Documento | IE informada? | indFinal | indIEDest | Tags XML |
|--------------|-----------|---------------|----------|-----------|----------|
| Pessoa Física | CPF (11) | Não tem | `1` | `9` | `<CPF>` |
| PJ não contribuinte | CNPJ (14) | ❌ Vazia | `1` | `9` | `<CNPJ>` (sem `<IE>`) |
| PJ contribuinte | CNPJ (14) | ✅ Preenchida | `0` | `1` | `<CNPJ>` + `<IE>` |

---

## 🧪 Exemplos de JSON Válidos

### ✅ Exemplo 1: Pessoa Física (CPF)
```json
{
  "cliente": {
    "nome": "João da Silva",
    "cpf": "05138670409",
    "endereco": "Rua das Flores, 123",
    "cidade": "Recife",
    "estado": "PE",
    "cep": "51020-200"
  }
}
```
**Resultado:** `indFinal=1`, `indIEDest=9`, campo `<CPF>` no XML ✅

---

### ✅ Exemplo 2: PJ não contribuinte (sem IE)
```json
{
  "cliente": {
    "nome": "Empresa XYZ LTDA",
    "cnpj": "20755929000138",
    "inscricao_estadual": "",  // ← VAZIO = não contribuinte
    "endereco": "Rua ABC, 100",
    "cidade": "Recife",
    "estado": "PE",
    "cep": "50000-000"
  }
}
```
**Resultado:** `indFinal=1`, `indIEDest=9`, campo `<CNPJ>` (sem `<IE>`) no XML ✅

---

### ✅ Exemplo 3: PJ contribuinte (com IE)
```json
{
  "cliente": {
    "nome": "Systhema Tecnologia LTDA",
    "cnpj": "20755929000138",
    "inscricao_estadual": "063257424",  // ← PREENCHIDO = contribuinte
    "endereco": "Rua 75, 85",
    "cidade": "Paulista",
    "estado": "PE",
    "cep": "53441-040"
  }
}
```
**Resultado:** `indFinal=0`, `indIEDest=1`, campos `<CNPJ>` + `<IE>` no XML ✅

---

## 🚨 Outros Erros Comuns (Requerem Atenção Manual)

### Erro 204 - Duplicidade de NF-e
**Causa:** Tentou emitir uma nota com número/série já usados.
**Solução:** Use outro número ou deixe o sistema gerar automaticamente.

### Erro 539 - CNPJ diverge do certificado
**Causa:** O CNPJ da empresa não confere com o certificado digital.
**Solução:** Verifique se está usando o certificado correto.

### Erro 280 - Certificado vencido
**Causa:** Certificado digital A1 está expirado.
**Solução:** Renove o certificado junto à Autoridade Certificadora.

### Erro 215 - Falha no schema XML
**Causa:** Algum campo obrigatório está faltando ou com formato incorreto.
**Solução:** Verifique os dados enviados no JSON.

---

## 🔍 Como Identificar Erros nos Logs

Os logs do sistema ficam em: `pontti_nfe/logs/nfe_debug.log`

Exemplo de log com erro:
```
[2025-10-08 14:30:00] 🚀 EMISSÃO 100% REAL E OFICIAL
[2025-10-08 14:30:01] ✅ Cliente é CONSUMIDOR FINAL (indFinal=1, indIEDest=9)
[2025-10-08 14:30:02] ✅ Documento do cliente: CPF 05138670409
[2025-10-08 14:30:03] ❌ Erro SEFAZ: [696] Operação com não contribuinte...
```

---

## 💡 Dicas para Evitar Erros

1. **Sempre informe CPF ou CNPJ** - Sistema detecta automaticamente qual usar
2. **Deixe IE vazio para não contribuintes** - Sistema marca como consumidor final
3. **Preencha IE para empresas contribuintes** - Sistema marca como operação B2B
4. **Deixe o sistema gerar o número automaticamente** - Evita duplicidade
5. **Verifique se o certificado está válido** - Renove antes do vencimento

---

## 📞 Suporte

Se encontrar algum erro não documentado aqui:
- Verifique os logs em: `pontti_nfe/logs/nfe_debug.log`
- Consulte o código do erro na [documentação da SEFAZ](https://www.nfe.fazenda.gov.br/portal/listaConteudo.aspx?tipoConteudo=tW+YMyk/50s=)
- Entre em contato: **contato@pontti.com.br** | **(81) 2011-3434**

---

**Desenvolvido por [Systhema Tecnologia](https://pontti.com.br)**

