# 📝 Changelog

Histórico de alterações do sistema de emissão de NF-e.

---

## [1.4.0] - 2025-10-10

### ✨ Melhoria: Cancelamento de NF-e com XML e PDF

#### 🎯 Adicionado
- **Geração automática de XML do cancelamento** (procEventoNFe)
- **Geração automática de PDF do cancelamento** usando Daevento
- Salvamento organizado de arquivos por CNPJ e data
- Estrutura de pastas: `arquivos/{CNPJ}/cancelamento/xml/{ANO}_{MES}` e `pdf/{ANO}_{MES}`
- Retorno dos caminhos `xml_path` e `pdf_path` na resposta JSON
- Logs detalhados do processo de cancelamento e geração de PDF

#### 📝 Documentação
- Expandida seção de cancelamento no Guia de Integração
- Adicionados campos opcionais para geração de PDF
- Documentada estrutura de arquivos gerados
- Exemplo JSON pronto: `exemplos_json/cancelamento_nfe.json`
- Exemplo JSON comentado: `exemplos_json/cancelamento_nfe_comentado.json`
- Atualizado README.md da pasta exemplos_json

#### 🔧 Arquivos Modificados

**Arquivos novos:**
1. `exemplos_json/cancelamento_nfe.json` - Exemplo pronto para uso
2. `exemplos_json/cancelamento_nfe_comentado.json` - Versão com explicações

**Arquivos modificados:**
1. `src/Services/NFeService.php` - Métodos adicionados:
   - `montarXMLProtocoladoCancelamento()` - Monta XML protocolado
   - `salvarXMLCancelamento()` - Salva XML do cancelamento
   - `gerarPDFCancelamento()` - Gera PDF do cancelamento
2. `docs/GUIA_INTEGRACAO.md` - Seção de cancelamento expandida
3. `exemplos_json/README.md` - Adicionado exemplo de cancelamento

#### 📂 Estrutura de Arquivos Gerados

```
arquivos/{CNPJ}/cancelamento/
├── xml/{ANO}_{MES}/
│   └── Cancel_{CHAVE_ACESSO}.xml
└── pdf/{ANO}_{MES}/
    └── Cancel_{CHAVE_ACESSO}.pdf
```

---

## [1.3.0] - 2025-10-09

### ✨ Nova Funcionalidade: Carta de Correção Eletrônica (CC-e)

#### 🎯 Adicionado
- **Endpoint de CC-e**: `POST /api/nfe/carta-correcao.php`
- Correção de erros em NF-e já autorizada (dados cadastrais, endereços, descrições)
- Suporte a múltiplas correções na mesma NF-e (número sequencial)
- **Geração automática de XML da CC-e**
- **Geração automática de PDF da CC-e**
- Validação automática de campos obrigatórios
- Validação de tamanho (15-1000 caracteres)
- Logs detalhados do processo

#### 📝 Documentação
- Adicionada seção completa sobre CC-e no Guia de Integração
- Exemplos de request/response
- Código SEFAZ 135 (Evento registrado)
- Códigos SEFAZ 478 e 591 (erros comuns)
- Exemplo JSON pronto: `exemplos_json/carta_correcao_nfe.json`
- Lista do que pode e não pode ser corrigido

#### 🔧 Arquivos Criados/Modificados

**Novos arquivos:**
1. `api/nfe/carta-correcao.php` - Endpoint direto para CC-e
2. `exemplos_json/carta_correcao_nfe.json` - Exemplo pronto para uso

**Arquivos modificados:**
1. `src/Core/Router.php` - Adicionada rota `/api/nfe/carta-correcao`
2. `src/Controllers/NFeController.php` - Método `cartaCorrecao()`
3. `src/Services/NFeService.php` - Método `cartaCorrecao()`
4. `docs/GUIA_INTEGRACAO.md` - Documentação completa do endpoint

---

## [1.2.0] - 2025-10-09

### ✨ Nova Funcionalidade: Inutilização de Numeração de NF-e

#### 🎯 Adicionado
- **Endpoint de inutilização**: `POST /api/nfe/inutilizar.php`
- Inutilização de numeração de NF-e não utilizada (quebra de sequência)
- Suporte a inutilização de número único ou faixa de números
- Validação automática de campos obrigatórios
- Logs detalhados do processo de inutilização

#### 📝 Documentação
- Adicionada seção completa sobre inutilização no Guia de Integração
- Exemplos de request/response
- Código SEFAZ 102 (Inutilização homologada)
- Código SEFAZ 563 (Duplicidade de inutilização)
- Exemplo JSON pronto: `exemplos_json/inutilizacao_nfe.json`

#### 🔧 Arquivos Criados/Modificados

**Novos arquivos:**
1. `api/nfe/inutilizar.php` - Endpoint direto para inutilização
2. `exemplos_json/inutilizacao_nfe.json` - Exemplo pronto para uso

**Arquivos modificados:**
1. `src/Core/Router.php` - Adicionada rota `/api/nfe/inutilizar`
2. `src/Controllers/NFeController.php` - Método `inutilizar()`
3. `src/Services/NFeService.php` - Método `inutilizarNFe()`
4. `docs/GUIA_INTEGRACAO.md` - Documentação completa do endpoint

#### 💡 Como Usar

**Cenário:** Você emitiu nota 100, depois nota 102 (pulou a 101)

**Solução:** Inutilizar o número 101:
```json
{
  "empresa": {
    "nome": "PRINT JET DIGITAL",
    "cnpj": "21497109000156",
    "inscricao_estadual": "093218028",
    "estado": "PE"
  },
  "serie": "001",
  "numero_inicial": "101",
  "numero_final": "101",
  "justificativa": "Erro no sistema ao gerar numeração"
}
```

**Resposta de sucesso:**
```json
{
  "success": true,
  "protocolo_inutilizacao": "126250000123458",
  "cStat": "102",
  "message": "Numeração inutilizada com sucesso"
}
```

---

## [1.1.1] - 2025-10-08

### 🐛 Correção Crítica: Erro 696 SEFAZ - Consumidor Final

#### ❌ Problema Corrigido
- **Erro 696 da SEFAZ**: "Rejeição: Operação com não contribuinte deve indicar operação com consumidor final"
- Sistema não marcava automaticamente a nota como "consumidor final" quando cliente era pessoa física ou não tinha IE

#### ✅ Solução Implementada
- **Detecção automática de consumidor final** baseada em:
  - Cliente com **CPF** (11 dígitos) → Automaticamente marca como consumidor final
  - Cliente com **CNPJ mas sem Inscrição Estadual** → Automaticamente marca como consumidor final
  - Cliente com **CNPJ e com IE** → Marca como operação normal (B2B)

#### 🔧 Configurações Automáticas

| Situação | indFinal | indIEDest | Tag XML |
|----------|----------|-----------|---------|
| Pessoa Física (CPF) | `1` | `9` | `<CPF>` (sem `<IE>`) |
| PJ sem IE | `1` | `9` | `<CNPJ>` (sem `<IE>`) |
| PJ com IE | `0` | `1` | `<CNPJ>` + `<IE>` |

#### 📝 Arquivos Modificados
- **`src/Services/NFeService.php`** (linhas 230-308)
  - Adicionada detecção de consumidor final ANTES da criação da tag IDE
  - Configuração dinâmica de `indFinal` baseado no tipo de cliente
  - Configuração dinâmica de `indIEDest` (9 = não contribuinte, 1 = contribuinte)
  - Campo `<IE>` só é adicionado quando preenchido

- **`README.md`**
  - Adicionada seção "🤖 Regras Automáticas do Sistema"
  - Tabela explicativa com os 3 cenários possíveis
  - Exemplos práticos para cada situação

#### 💡 Impacto
- Sistema agora **100% compatível** com regras da SEFAZ para consumidor final
- Não requer configuração manual de `indFinal` ou `indIEDest`
- Elimina erro 696 completamente

---

## [1.1.0] - 2025-10-08

### ✨ Nova Funcionalidade: Suporte a CPF (Pessoa Física)

#### 🎯 Adicionado
- Suporte completo para emissão de NF-e para **pessoa física** (CPF)
- Detecção automática de CPF vs CNPJ baseada na quantidade de dígitos (11 = CPF, 14 = CNPJ)
- Validação automática para garantir que CPF ou CNPJ seja informado
- Configuração automática de `indIEDest`:
  - `9` (Não Contribuinte) para pessoa física (CPF)
  - `1` (Contribuinte ICMS) para pessoa jurídica (CNPJ)
- Logs detalhados informando se o cliente é pessoa física ou jurídica

#### 📝 Documentação
- Atualizado README.md com exemplos de emissão para pessoa física
- Adicionado campo `cpf` na documentação de campos obrigatórios
- Criados exemplos JSON prontos:
  - `exemplos_json/emissao_pessoa_fisica_cpf.json`
  - `exemplos_json/emissao_pessoa_juridica_cnpj.json`
- Criado README dentro da pasta `exemplos_json/` com instruções de uso

#### 🔧 Alterações Técnicas

**Arquivos modificados:**

1. **`src/Services/NFeService.php`** (linhas 275-294)
   - Adicionada detecção automática de CPF vs CNPJ
   - Implementada lógica para usar campo `<CPF>` ou `<CNPJ>` no XML conforme o tipo
   - Adicionados logs informativos sobre o tipo de cliente

2. **`src/Controllers/NFeController.php`** (linhas 169-174)
   - Adicionada validação para garantir que CPF ou CNPJ seja informado
   - Mensagem de erro clara caso nenhum dos dois seja fornecido

3. **`README.md`**
   - Atualizada seção de características
   - Atualizada documentação de campos obrigatórios
   - Adicionado exemplo completo de emissão para pessoa física

#### 🐛 Correção de Bug
- **Problema:** Sistema tentava usar campo `<CNPJ>` mesmo quando o documento tinha 11 dígitos (CPF)
- **Erro retornado:** `Element '{http://www.portalfiscal.inf.br/nfe}CNPJ': [facet 'pattern'] The value '05138670409' is not accepted by the pattern '[0-9]{14}'`
- **Solução:** Detecção automática do tipo de documento e uso do campo XML correto

#### 💡 Como Usar

**Pessoa Física (CPF):**
```json
{
  "cliente": {
    "nome": "João da Silva",
    "cpf": "05138670409",
    "endereco": "Rua das Flores, 123",
    "cidade": "Recife",
    "bairro": "Boa Viagem",
    "estado": "PE",
    "cep": "51020-200"
  }
}
```

**Pessoa Jurídica (CNPJ):**
```json
{
  "cliente": {
    "nome": "Systhema Tecnologia LTDA",
    "cnpj": "20755929000138",
    "inscricao_estadual": "063257424",
    "endereco": "Rua setenta e cinco, 85",
    "cidade": "Paulista",
    "bairro": "Maranguape1",
    "estado": "PE",
    "cep": "53441-040"
  }
}
```

#### ✅ Compatibilidade
- Totalmente compatível com versões anteriores
- Sistemas que já usam `cnpj` continuam funcionando normalmente
- Novo campo `cpf` disponível opcionalmente

---

## [1.0.0] - 2025-10-15

### 🎉 Lançamento Inicial

- ✅ Emissão de NF-e em produção
- ✅ Cancelamento de NF-e
- ✅ Geração de DANFE com protocolo
- ✅ API REST completa
- ✅ Suporte a múltiplas empresas
- ✅ Assinatura digital com certificado A1

---

**Desenvolvido por [Systhema Tecnologia](https://pontti.com.br)**

