<?php
/**
 * DEBUG DO ENDPOINT DE EMISSÃO NFCe
 * Acesse no navegador: https://mobbisapp.com.br/pontti_nfe/debug_endpoint.php
 *
 * Este script simula exatamente o que o endpoint faz e mostra TODOS os erros
 */

// Ativar TODOS os erros
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Debug Endpoint NFCe</title>
    <style>
        body {
            font-family: Arial;
            background: #1a1a1a;
            color: #fff;
            padding: 20px;
        }
        .step {
            background: #2d2d2d;
            padding: 20px;
            margin: 15px 0;
            border-radius: 8px;
            border-left: 4px solid #667eea;
        }
        .ok { color: #00ff88; }
        .erro { color: #ff4757; }
        pre {
            background: #1a1a1a;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            border: 1px solid #444;
            font-size: 12px;
        }
        h1 { color: #667eea; }
        h2 { color: #00ff88; margin-top: 0; }
    </style>
</head>
<body>
    <h1>🔍 DEBUG - Endpoint api/nfce/emitir.php</h1>

    <?php
    $temErro = false;
    $mensagensErro = [];

    // ====================================
    // PASSO 1: Verificar autoload
    // ====================================
    echo '<div class="step">';
    echo '<h2>PASSO 1: Verificar Autoload</h2>';

    $autoloadPath = __DIR__ . '/vendor/autoload.php';

    if (!file_exists($autoloadPath)) {
        echo '<p class="erro">❌ vendor/autoload.php NÃO ENCONTRADO!</p>';
        echo '<p>Caminho esperado: ' . $autoloadPath . '</p>';
        echo '<p><strong>SOLUÇÃO:</strong> Execute <code>composer install --ignore-platform-reqs</code></p>';
        $temErro = true;
        $mensagensErro[] = 'vendor/autoload.php não encontrado';
    } else {
        echo '<p class="ok">✅ vendor/autoload.php encontrado</p>';

        try {
            require_once $autoloadPath;
            echo '<p class="ok">✅ Autoload carregado com sucesso</p>';
        } catch (Exception $e) {
            echo '<p class="erro">❌ ERRO ao carregar autoload:</p>';
            echo '<pre>' . htmlspecialchars($e->getMessage()) . '</pre>';
            $temErro = true;
            $mensagensErro[] = 'Erro ao carregar autoload: ' . $e->getMessage();
        }
    }

    echo '</div>';

    // ====================================
    // PASSO 2: Verificar classe NFCeService
    // ====================================
    echo '<div class="step">';
    echo '<h2>PASSO 2: Verificar Classe NFCeService</h2>';

    if (class_exists('App\\Services\\NFCeService')) {
        echo '<p class="ok">✅ Classe App\Services\NFCeService existe</p>';

        try {
            $service = new \App\Services\NFCeService();
            echo '<p class="ok">✅ Instância criada com sucesso</p>';
        } catch (Exception $e) {
            echo '<p class="erro">❌ ERRO ao instanciar NFCeService:</p>';
            echo '<pre>' . htmlspecialchars($e->getMessage()) . '</pre>';
            $temErro = true;
            $mensagensErro[] = 'Erro ao instanciar NFCeService: ' . $e->getMessage();
        }
    } else {
        echo '<p class="erro">❌ Classe App\Services\NFCeService NÃO ENCONTRADA!</p>';
        $temErro = true;
        $mensagensErro[] = 'Classe NFCeService não encontrada';
    }

    echo '</div>';

    // ====================================
    // PASSO 3: Verificar classes NFePHP
    // ====================================
    echo '<div class="step">';
    echo '<h2>PASSO 3: Verificar Biblioteca NFePHP</h2>';

    $classesNFePHP = [
        'NFePHP\\NFe\\Tools',
        'NFePHP\\NFe\\Make',
        'NFePHP\\NFe\\Common\\Standardize',
        'NFePHP\\Common\\Certificate',
        'NFePHP\\DA\\NFe\\Danfce'
    ];

    $todasOk = true;
    foreach ($classesNFePHP as $classe) {
        if (class_exists($classe)) {
            echo '<p class="ok">✅ ' . htmlspecialchars($classe) . '</p>';
        } else {
            echo '<p class="erro">❌ ' . htmlspecialchars($classe) . ' NÃO ENCONTRADA</p>';
            $todasOk = false;
            $temErro = true;
            $mensagensErro[] = "Classe $classe não encontrada";
        }
    }

    if ($todasOk) {
        echo '<p class="ok">✅ Todas as classes NFePHP estão OK</p>';
    }

    echo '</div>';

    // ====================================
    // PASSO 4: Verificar extensões PHP
    // ====================================
    echo '<div class="step">';
    echo '<h2>PASSO 4: Verificar Extensões PHP</h2>';

    $extensoes = ['curl', 'openssl', 'soap', 'xml', 'dom', 'zip', 'gd', 'mbstring'];
    $extensoesOk = true;

    foreach ($extensoes as $ext) {
        if (extension_loaded($ext)) {
            echo '<p class="ok">✅ ' . $ext . '</p>';
        } else {
            echo '<p class="erro">❌ ' . $ext . ' NÃO INSTALADA</p>';
            $extensoesOk = false;
            $temErro = true;
            $mensagensErro[] = "Extensão PHP '$ext' não instalada";
        }
    }

    if ($extensoesOk) {
        echo '<p class="ok">✅ Todas as extensões necessárias estão instaladas</p>';
    }

    echo '</div>';

    // ====================================
    // PASSO 5: Verificar diretórios
    // ====================================
    echo '<div class="step">';
    echo '<h2>PASSO 5: Verificar Diretórios</h2>';

    $diretorios = [
        __DIR__ . '/arquivos',
        __DIR__ . '/logs',
        __DIR__ . '/certificados'
    ];

    foreach ($diretorios as $dir) {
        $existe = is_dir($dir);
        $gravavel = $existe && is_writable($dir);

        if (!$existe) {
            echo '<p class="erro">❌ ' . basename($dir) . ' NÃO EXISTE</p>';
            if (mkdir($dir, 0755, true)) {
                echo '<p class="ok">✅ Diretório criado: ' . basename($dir) . '</p>';
            } else {
                echo '<p class="erro">❌ Não foi possível criar: ' . basename($dir) . '</p>';
                $temErro = true;
                $mensagensErro[] = "Diretório '" . basename($dir) . "' não existe e não pode ser criado";
            }
        } elseif (!$gravavel) {
            echo '<p class="erro">⚠️ ' . basename($dir) . ' NÃO É GRAVÁVEL</p>';
            echo '<p>Execute: <code>chmod 755 ' . $dir . '</code></p>';
            $mensagensErro[] = "Diretório '" . basename($dir) . "' não é gravável";
        } else {
            echo '<p class="ok">✅ ' . basename($dir) . ' OK</p>';
        }
    }

    echo '</div>';

    // ====================================
    // PASSO 6: Testar endpoint diretamente
    // ====================================
    echo '<div class="step">';
    echo '<h2>PASSO 6: Simular Requisição ao Endpoint</h2>';

    if (!$temErro) {
        echo '<p class="ok">✅ Todas as verificações passaram!</p>';
        echo '<p>O endpoint deveria estar funcionando.</p>';
        echo '<p><strong>Teste agora pelo Postman:</strong></p>';
        echo '<pre>';
        echo 'POST https://mobbisapp.com.br/pontti_nfe/api/nfce/emitir.php' . "\n";
        echo 'Content-Type: application/json' . "\n\n";
        echo '{
  "ambiente": 2,
  "empresa": {
    "nome": "Empresa Teste",
    "cnpj": "00000000000000",
    "inscricao_estadual": "0000000000",
    "estado": "PE",
    "cidade": "Recife",
    "endereco": "Rua Teste",
    "numero": "123",
    "bairro": "Centro",
    "cep": "50000000",
    "csc": "SEU_CSC_AQUI",
    "csc_id": "000001"
  },
  "numero": "1",
  "serie": "001",
  "itens": [
    {
      "codigo": "001",
      "descricao": "Produto Teste",
      "ncm": "84714900",
      "cfop": "5102",
      "unidade_comercial": "UN",
      "quantidade_comercial": 1,
      "valor_unitario": 10.00,
      "valor_total": 10.00
    }
  ],
  "pagamentos": [
    {
      "forma": "01",
      "valor": 10.00
    }
  ]
}';
        echo '</pre>';
    } else {
        echo '<p class="erro">❌ EXISTEM ERROS QUE PRECISAM SER CORRIGIDOS:</p>';
        echo '<ol>';
        foreach ($mensagensErro as $msg) {
            echo '<li>' . htmlspecialchars($msg) . '</li>';
        }
        echo '</ol>';
    }

    echo '</div>';

    // ====================================
    // PASSO 7: Verificar logs
    // ====================================
    echo '<div class="step">';
    echo '<h2>PASSO 7: Últimos Logs de Erro</h2>';

    $logFile = __DIR__ . '/logs/nfce_debug.log';

    if (file_exists($logFile)) {
        $conteudo = file_get_contents($logFile);
        $linhas = explode("\n", $conteudo);
        $ultimasLinhas = array_slice($linhas, -30);

        if (!empty(trim(implode('', $ultimasLinhas)))) {
            echo '<p>Últimas 30 linhas do log:</p>';
            echo '<pre>' . htmlspecialchars(implode("\n", $ultimasLinhas)) . '</pre>';
        } else {
            echo '<p class="ok">✅ Log vazio (nenhum erro registrado ainda)</p>';
        }
    } else {
        echo '<p class="ok">ℹ️ Arquivo de log ainda não existe (será criado na primeira requisição)</p>';
    }

    echo '</div>';

    // ====================================
    // RESUMO FINAL
    // ====================================
    echo '<div class="step">';

    if (!$temErro) {
        echo '<h2 style="color: #00ff88;">✅ TUDO OK! Sistema Pronto!</h2>';
        echo '<p>O erro 500 pode estar sendo causado por:</p>';
        echo '<ol>';
        echo '<li>JSON mal formatado na requisição</li>';
        echo '<li>Certificado digital não encontrado</li>';
        echo '<li>CSC ou CSC_ID incorretos</li>';
        echo '<li>Dados obrigatórios faltando</li>';
        echo '</ol>';
        echo '<p><strong>Próximo passo:</strong> Faça uma requisição de teste no Postman e me envie o erro exato.</p>';
    } else {
        echo '<h2 style="color: #ff4757;">❌ CORRIJA OS ERROS ACIMA</h2>';
        echo '<p>Após corrigir, recarregue esta página para verificar novamente.</p>';
    }

    echo '</div>';
    ?>

    <div style="text-align: center; margin: 30px 0;">
        <a href="?" style="background: #667eea; color: white; padding: 15px 30px; text-decoration: none; border-radius: 5px; font-weight: bold;">🔄 Recarregar Diagnóstico</a>
        <a href="/pontti_nfe/" style="background: #00ff88; color: #000; padding: 15px 30px; text-decoration: none; border-radius: 5px; font-weight: bold; margin-left: 10px;">← Voltar</a>
    </div>

    <p style="text-align: center; color: #888; margin-top: 30px;">
        Gerado em <?= date('d/m/Y H:i:s') ?><br>
        PHP <?= phpversion() ?>
    </p>
</body>
</html>

