<?php

// Configurações gerais
define('APP_NAME', 'API NFe Pontti');
define('APP_VERSION', '2.0');
define('APP_ENV', 'development'); // development ou production

// Configurações de diretórios
define('STORAGE_PATH', __DIR__ . '/storage/');
define('LOGS_PATH', __DIR__ . '/logs/');
define('CERTIFICATES_PATH', __DIR__ . '/certificados/');

// Configurações de NFe
define('DEFAULT_SERIE', '001');
define('DEFAULT_AMBIENTE', 'producao'); // homologacao ou producao

// Configurações de XML
define('XML_VERSION', '4.00');
define('XML_ENCODING', 'UTF-8');

// Configurações de timeout
define('SOAP_TIMEOUT', 30);
define('CURL_TIMEOUT', 30);

// Criar diretórios se não existirem
$directories = [STORAGE_PATH, LOGS_PATH, CERTIFICATES_PATH];
foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }
}

// Log de inicialização
error_log("[" . date('Y-m-d H:i:s') . "] API NFe iniciado sem banco de dados");