<?php

/**
 * Configurações para ambiente de PRODUÇÃO
 * ATENÇÃO: Este arquivo é para uso em produção real com SEFAZ
 */

// Configurações gerais
define('APP_NAME', 'API NFe Pontti - PRODUÇÃO');
define('APP_VERSION', '2.0');
define('APP_ENV', 'production'); // PRODUÇÃO

// Configurações de diretórios
define('STORAGE_PATH', __DIR__ . '/storage/');
define('LOGS_PATH', __DIR__ . '/logs/');
define('CERTIFICATES_PATH', __DIR__ . '/certificados/');

// Configurações de NFe - PRODUÇÃO
define('DEFAULT_SERIE', '001');
define('DEFAULT_AMBIENTE', 'producao'); // PRODUÇÃO

// Configurações de XML
define('XML_VERSION', '4.00');
define('XML_ENCODING', 'UTF-8');

// Configurações de timeout - PRODUÇÃO
define('SOAP_TIMEOUT', 60); // Timeout maior para produção
define('CURL_TIMEOUT', 60);

// Configurações de SEFAZ - PRODUÇÃO
define('SEFAZ_AMBIENTE', 1); // 1 = Produção, 2 = Homologação
define('SEFAZ_UF', 'PE'); // UF da empresa

// Criar diretórios se não existirem
$directories = [STORAGE_PATH, LOGS_PATH, CERTIFICATES_PATH];
foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }
}

// Configurar timezone para Brasil
date_default_timezone_set('America/Recife');

// Log de inicialização
error_log("[" . date('Y-m-d H:i:s') . "] API NFe iniciado em AMBIENTE DE PRODUÇÃO");