# Certificados Digitais - API NFe

## 📁 Estrutura de Pastas

```
certificados/
├── empresas/                    # Certificados organizados por empresa
│   ├── 12345678000199/         # CNPJ da empresa (exemplo)
│   │   ├── certificado.pfx     # Certificado principal (.pfx ou .p12)
│   │   ├── certificado.pem     # Formato alternativo (.pem)
│   │   └── chave_privada.key   # Chave privada (.key)
│   └── [outro_cnpj]/           # Outras empresas
└── README.md                    # Este arquivo
```

## 🔐 Tipos de Certificado Suportados

### **Formato Principal (.pfx/.p12)**
- **Extensão**: `.pfx` ou `.p12`
- **Uso**: Formato mais comum para Windows
- **Vantagem**: Contém certificado + chave privada

### **Formato Alternativo (.pem)**
- **Extensão**: `.pem`
- **Uso**: Formato padrão para Linux/Unix
- **Vantagem**: Mais compatível com sistemas

### **Chave Privada (.key)**
- **Extensão**: `.key`
- **Uso**: Chave privada separada
- **Vantagem**: Maior flexibilidade

## ⚠️ Segurança

### **NUNCA fazer:**
- ❌ Commitar certificados no Git
- ❌ Compartilhar certificados por email
- ❌ Armazenar em pastas públicas
- ❌ Usar certificados expirados

### **SEMPRE fazer:**
- ✅ Manter certificados em pasta segura
- ✅ Fazer backup regular
- ✅ Usar certificados válidos
- ✅ Configurar permissões corretas

## 🚀 Configuração no Banco

### **Tabela `empresas`:**
```sql
path_certificado = 'certificados/empresas/12345678000199/certificado.pfx'
senha_certificado = 'senha_do_certificado'
```

### **Exemplo de uso:**
```php
// No NFeService
$assinador = new \NFePHP\DA\AssinadorDigital(
    $empresa['path_certificado'],      // Caminho do certificado
    $empresa['senha_certificado']      // Senha do certificado
);
```

## 📋 Checklist de Implementação

- [ ] Criar pasta para cada empresa (CNPJ)
- [ ] Colocar certificado na pasta correta
- [ ] Configurar caminho no banco de dados
- [ ] Testar assinatura digital
- [ ] Verificar permissões de arquivo
- [ ] Fazer backup do certificado

## 🔧 Permissões Recomendadas

### **Windows:**
- Pasta: Acesso restrito ao usuário da aplicação
- Arquivos: Leitura apenas para usuário da aplicação

### **Linux/Unix:**
```bash
chmod 600 certificados/empresas/*/certificado.*
chmod 700 certificados/empresas/*/
```

## 📞 Suporte

Para dúvidas sobre certificados digitais:
- **Telefone**: 81 997102197
- **Email**: romildoconegundes@sistemapontti.com.br
