<?php

/**
 * Router da API - Processa requisições de API
 */

// ENVIAR CORS PRIMEIRO - ANTES DE QUALQUER COISA!
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, Accept, Origin, Access-Control-Request-Method, Access-Control-Request-Headers');
header('Access-Control-Max-Age: 86400');

// Tratar requisições OPTIONS (preflight)
if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Carregar autoload
require_once __DIR__ . '/vendor/autoload.php';

// Carregar configurações de produção
require_once __DIR__ . '/config_producao.php';

// Definir constantes SOAP se necessário
if (!defined('SOAP_1_2')) {
    define('SOAP_1_2', 2);
    define('SOAP_1_1', 1);
    define('SOAP_ENCODED', 1);
    define('SOAP_LITERAL', 2);
    define('SOAP_RPC', 1);
    define('SOAP_DOCUMENT', 2);
}

// Autoload já carregado acima

use App\Core\Router;
use App\Core\Cors;

try {
    // Criar e executar roteador
    $router = new Router();
    $router->dispatch();
} catch (Exception $e) {
    // Resposta de erro com CORS
    Cors::setHeaders();
    http_response_code(500);
    header('Content-Type: application/json');
    echo json_encode([
        'error' => 'Erro interno do servidor',
        'message' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ], JSON_UNESCAPED_UNICODE);
    exit;
}
