<?php
// Arquivo direto para testar a API
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, Accept, Origin, Access-Control-Request-Method, Access-Control-Request-Headers');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'cStat' => '405',
        'message' => 'Método não permitido. Use POST.'
    ]);
    exit;
}

try {
    require_once __DIR__ . '/../../vendor/autoload.php';
    require_once __DIR__ . '/../../config_producao.php';

    $input = file_get_contents('php://input');
    $dados = json_decode($input, true);

    if (!$dados) {
        http_response_code(400);
        echo json_encode([
            'cStat' => '400',
            'message' => 'Dados inválidos'
        ]);
        exit;
    }

    // Usar o serviço diretamente
    $nfeService = new \App\Services\NFeService();
    $resultado = $nfeService->emitirSemBanco($dados);

    if ($resultado['success']) {
        echo json_encode([
            'success' => true,
            'numero' => $resultado['numero'],
            'serie' => $resultado['serie'],
            'chave_acesso' => $resultado['chave_acesso'],
            'protocolo' => $resultado['protocolo'],
            'xml_path' => $resultado['xml_path'] ?? null,
            'pdf_path' => $resultado['pdf_path'] ?? null,
            'data_emissao' => $resultado['data_emissao'],
            'valor_total' => $resultado['valor_total'],
            'message' => 'NFe emitida com sucesso'
        ], JSON_UNESCAPED_UNICODE);
    } else {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'numero' => $resultado['numero'] ?? null,
            'serie' => $resultado['serie'] ?? null,
            'error' => $resultado['error']
        ], JSON_UNESCAPED_UNICODE);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'cStat' => '500',
        'message' => 'Erro interno: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}