<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, Accept, Origin, Access-Control-Request-Method, Access-Control-Request-Headers');
header('Access-Control-Max-Age: 86400');

// Responder a requisições OPTIONS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once __DIR__ . '/../../config_producao.php';
require_once __DIR__ . '/../../vendor/autoload.php';

use App\Services\NFeService;

try {
    // Verificar método HTTP
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode([
            'success' => false,
            'error' => 'Método não permitido. Use POST.'
        ], JSON_UNESCAPED_UNICODE);
        exit();
    }

    // Ler dados do JSON
    $input = file_get_contents('php://input');
    $dados = json_decode($input, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'error' => 'JSON inválido: ' . json_last_error_msg()
        ], JSON_UNESCAPED_UNICODE);
        exit();
    }

    // Validar dados obrigatórios
    $camposObrigatorios = ['chave_acesso', 'justificativa', 'empresa'];
    foreach ($camposObrigatorios as $campo) {
        if (!isset($dados[$campo]) || empty($dados[$campo])) {
            http_response_code(400);
            echo json_encode([
                'success' => false,
                'error' => "Campo obrigatório não informado: {$campo}"
            ], JSON_UNESCAPED_UNICODE);
            exit();
        }
    }

    // Validar justificativa (mínimo 15 caracteres)
    if (strlen($dados['justificativa']) < 15) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'error' => 'Justificativa deve ter pelo menos 15 caracteres'
        ], JSON_UNESCAPED_UNICODE);
        exit();
    }

    // Instanciar serviço
    $nfeService = new NFeService();

    // Cancelar NFe
    $resultado = $nfeService->cancelarNFe($dados);

    if ($resultado['success']) {
        echo json_encode([
            'success' => true,
            'chave_acesso' => $resultado['chave_acesso'],
            'protocolo_cancelamento' => $resultado['protocolo_cancelamento'],
            'data_cancelamento' => $resultado['data_cancelamento'],
            'message' => 'NFe cancelada com sucesso'
        ], JSON_UNESCAPED_UNICODE);
    } else {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'error' => $resultado['error']
        ], JSON_UNESCAPED_UNICODE);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Erro interno: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
