<?php

/**
 * API de Inclusão de Condutor em MDF-e
 *
 * Endpoint: POST /api/mdfe/incluir_condutor.php
 * Content-Type: application/json
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'error' => 'Método não permitido. Use POST.'
    ]);
    exit;
}

require_once __DIR__ . '/../../vendor/autoload.php';

use App\Services\MDFeService;

try {
    $json = file_get_contents('php://input');
    $dados = json_decode($json, true);

    if (!$dados) {
        throw new Exception('JSON inválido');
    }

    // Validações
    $camposObrigatorios = ['chave_acesso', 'cnpj', 'condutor'];
    foreach ($camposObrigatorios as $campo) {
        if (!isset($dados[$campo]) || empty($dados[$campo])) {
            throw new Exception("Campo '$campo' é obrigatório");
        }
    }

    // Validar dados do condutor
    if (!isset($dados['condutor']['nome']) || !isset($dados['condutor']['cpf'])) {
        throw new Exception("Campos 'condutor.nome' e 'condutor.cpf' são obrigatórios");
    }

    // Criar serviço e incluir condutor
    $service = new MDFeService();
    $resultado = $service->incluirCondutor($dados);

    if ($resultado['success']) {
        http_response_code(200);
    } else {
        http_response_code(400);
    }

    echo json_encode($resultado, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}

