<?php

/**
 * API de Consulta de MDF-e pela Chave de Acesso
 *
 * Endpoint: POST /api/mdfe/consultar.php
 * Content-Type: application/json
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'error' => 'Método não permitido. Use POST.'
    ]);
    exit;
}

require_once __DIR__ . '/../../vendor/autoload.php';

use NFePHP\Common\Tools;
use NFePHP\Common\Standardize;
use NFePHP\Common\Certificate;

try {
    $json = file_get_contents('php://input');
    $dados = json_decode($json, true);

    if (!$dados) {
        throw new Exception('JSON inválido');
    }

    // Validações
    if (!isset($dados['chave_acesso']) || empty($dados['chave_acesso'])) {
        throw new Exception('Chave de acesso é obrigatória');
    }

    if (!isset($dados['emitente']) || !isset($dados['emitente']['cnpj'])) {
        throw new Exception('CNPJ do emitente é obrigatório');
    }

    // Validar chave de acesso (44 dígitos)
    $chaveAcesso = preg_replace('/[^0-9]/', '', $dados['chave_acesso']);
    if (strlen($chaveAcesso) != 44) {
        throw new Exception('Chave de acesso deve ter 44 dígitos');
    }

    // Implementação simplificada para consulta
    $cnpj = preg_replace('/[^0-9]/', '', $dados['emitente']['cnpj']);

    // Simular consulta (em produção, usar SEFAZ real)
    $situacao = 'Autorizado'; // Simular MDF-e autorizado
    $cStat = '100';
    $xMotivo = 'Consulta realizada com sucesso';
    $protocolo = '126250000' . str_pad(rand(100000, 999999), 6, '0', STR_PAD_LEFT);
    $dataAutorizacao = date('Y-m-d\TH:i:sP');

    http_response_code(200);
    echo json_encode([
        'success' => true,
        'chave_acesso' => $chaveAcesso,
        'cStat' => $cStat,
        'xMotivo' => $xMotivo,
        'protocolo' => $protocolo,
        'data_autorizacao' => $dataAutorizacao,
        'situacao' => $situacao,
        'message' => 'Consulta realizada com sucesso (MODO SIMULAÇÃO)'
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}

