<?php

/**
 * API de Emissão de CT-e (Conhecimento de Transporte Eletrônico)
 *
 * Endpoint: POST /api/cte/emitir.php
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Método não permitido']);
    exit;
}

require_once __DIR__ . '/../../vendor/autoload.php';

use App\Services\CTEService;

try {
    $json = file_get_contents('php://input');
    $dados = json_decode($json, true);

    if (!$dados) throw new Exception('JSON inválido');

    // Validações básicas
    $camposObrigatorios = ['emitente', 'remetente', 'destinatario', 'valores', 'carga', 'cfop'];
    foreach ($camposObrigatorios as $campo) {
        if (!isset($dados[$campo])) {
            throw new Exception("Campo $campo é obrigatório");
        }
    }

    $service = new CTEService();
    $resultado = $service->emitir($dados);

    http_response_code($resultado['success'] ? 200 : 400);
    echo json_encode($resultado, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}

